/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.eq;

import java.util.ArrayList;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.eq.EQ;
import uk.org.toot.audio.filter.BiQuadFilter;
import uk.org.toot.audio.filter.Filter;
import uk.org.toot.audio.filter.FilterSpecification;

public abstract class AbstractEQ
extends EQ {
    protected ArrayList<Filter> filters = new ArrayList();
    protected EQ.Specification specification;
    protected int sampleRate = -1;
    private boolean wasBypassed;

    public AbstractEQ(EQ.Specification spec) {
        this.specification = spec;
        this.wasBypassed = !this.specification.isBypassed();
        this.createEQ(spec);
    }

    public void open() {
        for (Filter filter : this.filters) {
            filter.open();
        }
    }

    public void close() {
        for (Filter filter : this.filters) {
            filter.close();
        }
    }

    protected void clear() {
        for (Filter filter : this.filters) {
            filter.clear();
        }
    }

    protected void createEQ(EQ.Specification spec) {
        for (FilterSpecification fspec : spec.getFilterSpecifications()) {
            this.filters.add(this.createFilter(fspec));
        }
    }

    protected Filter createFilter(FilterSpecification fspec) {
        return new BiQuadFilter(fspec);
    }

    public int getSize() {
        return this.filters.size();
    }

    public EQ.Specification getSpecification() {
        return this.specification;
    }

    public int processAudio(AudioBuffer buffer) {
        boolean bypassed = this.specification.isBypassed();
        if (bypassed) {
            if (!this.wasBypassed) {
                this.clear();
                this.wasBypassed = true;
            }
            return 0;
        }
        int newRate = (int)buffer.getSampleRate();
        if (this.sampleRate != newRate) {
            this.sampleRate = newRate;
            this.updateDesigns();
        }
        int nc = buffer.getChannelCount();
        int ns = buffer.getSampleCount();
        int c = 0;
        while (c < nc) {
            this.filter(buffer.getChannel(c), ns, c);
            ++c;
        }
        this.wasBypassed = bypassed;
        return 0;
    }

    protected abstract int filter(float[] var1, int var2, int var3);

    protected void updateDesigns() {
        for (Filter f : this.filters) {
            f.setSampleRate(this.sampleRate);
        }
    }
}

