/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.eq;

import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.eq.CutEQ;
import uk.org.toot.audio.eq.GraphicEQ;
import uk.org.toot.audio.eq.ParametricEQ;
import uk.org.toot.audio.spi.TootAudioServiceProvider;
import uk.org.toot.localisation.Localisation;

public class EQServiceProvider
extends TootAudioServiceProvider {
    public EQServiceProvider() {
        super(Localisation.getString("EQ"), "0.3");
        String family = this.description;
        this.addControls(ParametricEQ.Controls.class, 1, Localisation.getString("Parametric.EQ"), family, "0.2");
        this.addControls(GraphicEQ.Controls.class, 2, Localisation.getString("Graphic.EQ"), family, "0.2");
        this.addControls(CutEQ.Controls.class, 3, Localisation.getString("Cut.EQ"), family, "0.1");
        this.add(ParametricEQ.class, Localisation.getString("Parametric.EQ"), family, "0.2");
        this.add(GraphicEQ.class, Localisation.getString("Graphic.EQ"), family, "0.2");
        this.add(CutEQ.class, Localisation.getString("Cut.EQ"), family, "0.1");
    }

    public AudioProcess createProcessor(AudioControls c) {
        if (c instanceof ParametricEQ.Controls) {
            return new ParametricEQ((ParametricEQ.Controls)c);
        }
        if (c instanceof GraphicEQ.Controls) {
            return new GraphicEQ((GraphicEQ.Controls)c);
        }
        if (c instanceof CutEQ.Controls) {
            return new CutEQ((CutEQ.Controls)c);
        }
        return null;
    }
}

