/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.filter;

import uk.org.toot.audio.filter.AbstractFilterDesign;
import uk.org.toot.audio.filter.Filter;
import uk.org.toot.audio.filter.FilterSpecification;
import uk.org.toot.audio.filter.FilterTools;

public class BiQuadDesign
extends AbstractFilterDesign {
    private static double M_LN2 = 0.6931471805599453;
    double a0;
    double a1;
    double a2;
    double a3;
    double a4;

    public BiQuadDesign(FilterSpecification spec) {
        super(spec);
    }

    public void design(int sampleRate) {
        this.design(this.spec.getClassicType(), 0.0f, this.spec.getFrequency(), sampleRate, FilterTools.getOctaveBandwidth(this.spec.getResonance()));
    }

    public void design(Filter.Type type, float dbGain, float freq, float srate, float bandwidth) {
        double a2;
        double a1;
        double a0;
        double b2;
        double b1;
        double b0;
        double A = Math.pow(10.0, dbGain / 40.0f);
        double omega = Math.PI * 2 * (double)freq / (double)srate;
        double sn = Math.sin(omega);
        double cs = Math.cos(omega);
        double alpha = sn * Math.sinh(M_LN2 / 2.0 * (double)bandwidth * omega / sn);
        double beta = Math.sqrt(A + A);
        switch (type) {
            case LPF: {
                b0 = (1.0 - cs) / 2.0;
                b1 = 1.0 - cs;
                b2 = (1.0 - cs) / 2.0;
                a0 = 1.0 + alpha;
                a1 = -2.0 * cs;
                a2 = 1.0 - alpha;
                break;
            }
            case HPF: {
                b0 = (1.0 + cs) / 2.0;
                b1 = -(1.0 + cs);
                b2 = (1.0 + cs) / 2.0;
                a0 = 1.0 + alpha;
                a1 = -2.0 * cs;
                a2 = 1.0 - alpha;
                break;
            }
            case BPF: {
                b0 = alpha;
                b1 = 0.0;
                b2 = -alpha;
                a0 = 1.0 + alpha;
                a1 = -2.0 * cs;
                a2 = 1.0 - alpha;
                break;
            }
            case NOTCH: {
                b0 = 1.0;
                b1 = -2.0 * cs;
                b2 = 1.0;
                a0 = 1.0 + alpha;
                a1 = -2.0 * cs;
                a2 = 1.0 - alpha;
                break;
            }
            case PEQ: {
                b0 = 1.0 + alpha * A;
                b1 = -2.0 * cs;
                b2 = 1.0 - alpha * A;
                a0 = 1.0 + alpha / A;
                a1 = -2.0 * cs;
                a2 = 1.0 - alpha / A;
                break;
            }
            case LSH: {
                b0 = A * (A + 1.0 - (A - 1.0) * cs + beta * sn);
                b1 = 2.0 * A * (A - 1.0 - (A + 1.0) * cs);
                b2 = A * (A + 1.0 - (A - 1.0) * cs - beta * sn);
                a0 = A + 1.0 + (A - 1.0) * cs + beta * sn;
                a1 = -2.0 * (A - 1.0 + (A + 1.0) * cs);
                a2 = A + 1.0 + (A - 1.0) * cs - beta * sn;
                break;
            }
            case HSH: {
                b0 = A * (A + 1.0 + (A - 1.0) * cs + beta * sn);
                b1 = -2.0 * A * (A - 1.0 + (A + 1.0) * cs);
                b2 = A * (A + 1.0 + (A - 1.0) * cs - beta * sn);
                a0 = A + 1.0 - (A - 1.0) * cs + beta * sn;
                a1 = 2.0 * (A - 1.0 - (A + 1.0) * cs);
                a2 = A + 1.0 - (A - 1.0) * cs - beta * sn;
                break;
            }
            default: {
                return;
            }
        }
        this.a0 = b0 / a0;
        this.a1 = b1 / a0;
        this.a2 = b2 / a0;
        this.a3 = a1 / a0;
        this.a4 = a2 / a0;
    }
}

