/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentLinkedQueue;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.meter.MeterControls;
import uk.org.toot.audio.meter.MeterProcess;
import uk.org.toot.audio.mixer.AudioMixerBus;
import uk.org.toot.audio.mixer.AudioMixerStrip;
import uk.org.toot.audio.mixer.BusControls;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.audio.server.AudioClient;
import uk.org.toot.audio.server.AudioServer;
import uk.org.toot.control.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioMixer
implements AudioClient {
    private MixerControls controls;
    protected AudioMixerBus mainBus;
    protected List<AudioMixerBus> busses;
    protected List<AudioMixerBus> auxBusses;
    protected List<AudioMixerBus> fxBusses;
    private List<AudioMixerStrip> strips;
    private List<AudioMixerStrip> channelStrips;
    private List<AudioMixerStrip> groupStrips;
    private List<AudioMixerStrip> fxStrips;
    private List<AudioMixerStrip> auxStrips;
    private AudioMixerStrip mainStrip;
    private AudioServer server;
    private AudioBuffer sharedAudioBuffer;
    private ConcurrentLinkedQueue<MixerControls.Mutation> mutationQueue;
    private boolean enabled = true;

    public AudioMixer(MixerControls controls, AudioServer server) throws Exception {
        if (controls == null) {
            throw new IllegalArgumentException("null MixerControls");
        }
        if (server == null) {
            throw new IllegalArgumentException("null AudioServer");
        }
        this.controls = controls;
        this.server = server;
        this.sharedAudioBuffer = server.createAudioBuffer("Mixer (shared)");
        this.mutationQueue = new ConcurrentLinkedQueue();
        this.strips = new ArrayList<AudioMixerStrip>();
        this.channelStrips = new ArrayList<AudioMixerStrip>();
        this.groupStrips = new ArrayList<AudioMixerStrip>();
        this.fxStrips = new ArrayList<AudioMixerStrip>();
        this.auxStrips = new ArrayList<AudioMixerStrip>();
        this.createBusses(controls);
        this.createStrips(controls);
        controls.addObserver(new MixerControlsObserver());
    }

    protected AudioBuffer getSharedBuffer() {
        return this.sharedAudioBuffer;
    }

    protected AudioBuffer createBuffer(String name) {
        return this.server.createAudioBuffer(name);
    }

    public boolean isMutating() {
        return !this.mutationQueue.isEmpty();
    }

    public void waitForMutations() {
        while (this.isMutating()) {
            if (this.isEnabled() && this.server.isRunning()) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.processMutations();
        }
        if (this.isEnabled() && this.server.isRunning()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public AudioMixerStrip getStrip(String name) {
        this.waitForMutations();
        return this.getStripImpl(name);
    }

    public AudioMixerStrip getStripImpl(String name) {
        for (AudioMixerStrip strip : this.strips) {
            if (!strip.getName().equals(name)) continue;
            return strip;
        }
        return null;
    }

    public List<AudioMixerStrip> getStrips() {
        this.waitForMutations();
        return Collections.unmodifiableList(this.strips);
    }

    @Override
    public void work(int nFrames) {
        if (!this.enabled) {
            return;
        }
        this.processMutations();
        this.silenceStrips(this.groupStrips);
        this.silenceStrips(this.fxStrips);
        this.silenceStrips(this.auxStrips);
        this.mainStrip.silence();
        this.evaluateStrips(this.channelStrips);
        this.evaluateStrips(this.groupStrips);
        this.evaluateStrips(this.fxStrips);
        this.evaluateStrips(this.auxStrips);
        this.mainStrip.processBuffer();
        this.writeBusBuffers();
    }

    protected void processMutations() {
        MixerControls.Mutation m = this.mutationQueue.poll();
        if (m == null) {
            return;
        }
        this.processMutation(m);
    }

    protected void processMutation(MixerControls.Mutation m) {
        if (!(m.getControl() instanceof AudioControlsChain)) {
            return;
        }
        AudioControlsChain controlsChain = (AudioControlsChain)m.getControl();
        switch (m.getOperation()) {
            case 1: {
                this.createStrip(controlsChain);
                break;
            }
            case 2: {
                this.removeStrip(controlsChain);
            }
        }
    }

    protected void evaluateStrips(List<AudioMixerStrip> evalStrips) {
        for (AudioMixerStrip strip : evalStrips) {
            strip.processBuffer();
        }
    }

    protected void silenceStrips(List<AudioMixerStrip> evalStrips) {
        for (AudioMixerStrip strip : evalStrips) {
            strip.silence();
        }
    }

    protected void writeBusBuffers() {
        for (AudioMixerBus bus : this.busses) {
            bus.write();
        }
    }

    protected void createBusses(MixerControls mixerControls) {
        AudioMixerBus bus;
        this.busses = new ArrayList<AudioMixerBus>();
        this.auxBusses = new ArrayList<AudioMixerBus>();
        this.fxBusses = new ArrayList<AudioMixerBus>();
        for (BusControls busControls : mixerControls.getAuxBusControls()) {
            bus = this.createBus(busControls);
            this.busses.add(bus);
            this.auxBusses.add(bus);
        }
        for (BusControls busControls : mixerControls.getFxBusControls()) {
            bus = this.createBus(busControls);
            this.busses.add(bus);
            this.fxBusses.add(bus);
        }
        this.mainBus = this.createBus(mixerControls.getMainBusControls());
        this.busses.add(this.mainBus);
    }

    protected AudioMixerBus createBus(BusControls busControls) {
        return new AudioMixerBus(this, busControls);
    }

    public AudioMixerBus getBus(String name) {
        for (AudioMixerBus bus : this.busses) {
            if (!bus.getName().equals(name)) continue;
            return bus;
        }
        return null;
    }

    public AudioMixerBus getMainBus() {
        return this.mainBus;
    }

    public AudioMixerStrip getMainStrip() {
        if (this.mainStrip == null) {
            System.err.println("getMainStrip() called before mainStrip set");
        }
        return this.mainStrip;
    }

    protected void createStrips(MixerControls mixerControls) {
        for (Control control : mixerControls.getControls()) {
            if (!(control instanceof AudioControlsChain)) continue;
            this.createStrip((AudioControlsChain)control);
        }
    }

    protected AudioMixerStrip createStrip(AudioControlsChain controls) {
        AudioMixerStrip strip = new AudioMixerStrip(this, controls){

            protected AudioProcess createProcess(AudioControls controls) {
                if (controls instanceof MeterControls) {
                    return new MeterProcess((MeterControls)controls);
                }
                return super.createProcess(controls);
            }
        };
        switch (strip.getId()) {
            case 120: {
                this.channelStrips.add(strip);
                break;
            }
            case 121: {
                this.groupStrips.add(strip);
                break;
            }
            case 122: {
                this.fxStrips.add(strip);
                break;
            }
            case 124: {
                this.auxStrips.add(strip);
                break;
            }
            case 123: {
                if (this.mainStrip == null) {
                    this.mainStrip = strip;
                    break;
                }
                throw new IllegalArgumentException("Only one main strip allowed");
            }
        }
        try {
            this.strips.add(strip);
            strip.open();
        }
        catch (Exception e) {
            System.err.println("Mixer failed to open strip " + strip.getName());
        }
        return strip;
    }

    protected void removeStrip(AudioControlsChain controls) {
        for (AudioMixerStrip strip : this.strips) {
            if (!strip.getName().equals(controls.getName())) continue;
            strip.close();
            this.strips.remove(strip);
            switch (strip.getId()) {
                case 120: {
                    this.channelStrips.remove(strip);
                    break;
                }
                case 121: {
                    this.groupStrips.remove(strip);
                    break;
                }
                case 122: {
                    this.fxStrips.remove(strip);
                    break;
                }
                case 124: {
                    this.auxStrips.remove(strip);
                    break;
                }
                case 123: {
                    this.mainStrip = null;
                }
            }
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected class MixerControlsObserver
    implements Observer {
        protected MixerControlsObserver() {
        }

        public void update(Observable obs, Object obj) {
            if (obj instanceof MixerControls.Mutation) {
                if (AudioMixer.this.isEnabled() && AudioMixer.this.server.isRunning()) {
                    AudioMixer.this.mutationQueue.add((MixerControls.Mutation)obj);
                } else {
                    AudioMixer.this.processMutation((MixerControls.Mutation)obj);
                }
            }
        }
    }
}

