/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.mixer.automation;

import java.util.Observable;
import java.util.Observer;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.audio.mixer.MixerControls;
import uk.org.toot.audio.mixer.automation.AutomationControls;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.Control;

public abstract class BasicAutomation {
    protected MixerControls mixerControls;
    private MutationObserver mutationObserver;

    public BasicAutomation(MixerControls controls) {
        this.mixerControls = controls;
        Control[] controlArray = this.mixerControls.getMemberControls();
        int n = 0;
        int n2 = controlArray.length;
        while (n < n2) {
            Control c = controlArray[n];
            if (c instanceof AudioControlsChain) {
                this.ensureControls((AudioControlsChain)c);
            }
            ++n;
        }
        this.mutationObserver = new MutationObserver();
        this.mixerControls.addObserver(this.mutationObserver);
    }

    protected void ensureControls(AudioControlsChain strip) {
        AutomationControls autoc = strip.find(AutomationControls.class);
        if (autoc == null) {
            autoc = new AutomationControls();
            strip.add(0, autoc);
        }
        this.ensureAutomationControls(autoc);
    }

    protected abstract void ensureAutomationControls(AutomationControls var1);

    protected class MutationObserver
    implements Observer {
        protected MutationObserver() {
        }

        public void update(Observable obs, Object obj) {
            CompoundControl cc;
            MixerControls.Mutation m;
            if (obj instanceof MixerControls.Mutation && (m = (MixerControls.Mutation)obj).getOperation() == 1 && (cc = m.getControl()) instanceof AudioControlsChain) {
                BasicAutomation.this.ensureControls((AudioControlsChain)cc);
            }
        }
    }
}

