/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.audio.spi;

import java.util.List;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioProcess;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.spi.AudioControlServiceDescriptor;
import uk.org.toot.control.spi.ControlServiceDescriptor;
import uk.org.toot.service.ServiceDescriptor;
import uk.org.toot.service.ServiceProvider;

public abstract class AudioServiceProvider
extends ServiceProvider {
    private List<ServiceDescriptor> controls = this.service(AudioControls.class);

    public AudioServiceProvider(int providerId, String providerName, String description, String version) {
        super(providerId, providerName, description, version);
    }

    public String lookupName(int moduleId) {
        for (ServiceDescriptor d : this.controls) {
            try {
                if (((ControlServiceDescriptor)d).getModuleId() != moduleId) continue;
                return d.getName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public AudioControls createControls(int moduleId) {
        for (ServiceDescriptor d : this.controls) {
            try {
                if (((ControlServiceDescriptor)d).getModuleId() != moduleId) continue;
                return (AudioControls)d.getServiceClass().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void addControls(Class clazz, int moduleId, String name, String description, String version) {
        this.add(new AudioControlServiceDescriptor(clazz, moduleId, name, description, version));
    }

    protected void addControls(Class clazz, int moduleId, String name, String description, String version, ChannelFormat format) {
        this.add(new AudioControlServiceDescriptor(clazz, moduleId, name, description, version, format));
    }

    public AudioControls createControls(String name) {
        for (ServiceDescriptor d : this.controls) {
            try {
                if (!d.getName().equals(name)) continue;
                return (AudioControls)d.getServiceClass().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public abstract AudioProcess createProcessor(AudioControls var1);
}

