/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.control.CompoundControlPersistence;
import uk.org.toot.control.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompoundControl
extends Control {
    public static final int MAX_INSTANCES = 8;
    private static CompoundControlPersistence persistence;
    protected List<Control> controls;
    int instanceIndex = 0;
    private Hashtable<Object, Object> properties;

    protected CompoundControl(int id, String name) {
        this(id, CompoundControl.deriveInstanceIndex(name), name);
    }

    protected CompoundControl(int id, int instanceIndex, String name) {
        super(id, name);
        this.checkInstanceIndex(instanceIndex);
        this.instanceIndex = instanceIndex;
    }

    protected static int deriveInstanceIndex(String name) {
        int hash = name.lastIndexOf(35);
        return hash > 0 ? Integer.parseInt(name.substring(hash + 1)) - 1 : 0;
    }

    protected void checkInstanceIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " instance " + index + " < 0!");
        }
        if (index > 7) {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + " instance " + index + " > 7!");
        }
    }

    protected void add(Control control) {
        if (control == null) {
            return;
        }
        if (this.controls == null) {
            this.controls = new ArrayList<Control>();
        }
        this.controls.add(control);
        control.parent = this;
    }

    protected void remove(Control control) {
        if (control == null) {
            return;
        }
        this.controls.remove(control);
        control.parent = null;
    }

    public Control[] getMemberControls() {
        Control[] emptyArray = new Control[]{};
        if (this.controls == null) {
            return emptyArray;
        }
        return this.controls.toArray(emptyArray);
    }

    public List<Control> getControls() {
        if (this.controls == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.controls);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.controls.size()) {
            if (i != 0) {
                buf.append(", ");
                if (i + 1 == this.controls.size()) {
                    buf.append("and ");
                }
            }
            buf.append(this.controls.get(i).getName());
            ++i;
        }
        return String.valueOf(this.getName()) + " Control containing " + buf + " Controls.";
    }

    public boolean isAlwaysVertical() {
        return false;
    }

    public boolean isAlwaysHorizontal() {
        return false;
    }

    public boolean isNeverBordered() {
        return false;
    }

    public String getAlternate() {
        return null;
    }

    public int getProviderId() {
        return this.getParent().getProviderId();
    }

    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public <T> T find(Class<T> clazz) {
        if (this.controls == null) {
            return null;
        }
        for (Control control : this.controls) {
            if (!clazz.isInstance(control)) continue;
            return (T)control;
        }
        return null;
    }

    public Control find(String name) {
        if (this.controls == null) {
            return null;
        }
        for (Control c : this.controls) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public CompoundControl find(int providerId, int moduleId, int instanceIndex) {
        Control[] controlArray = this.getMemberControls();
        int n = 0;
        int n2 = controlArray.length;
        while (n < n2) {
            CompoundControl cc;
            Control m = controlArray[n];
            if (m instanceof CompoundControl && providerId == (cc = (CompoundControl)m).getProviderId() && moduleId == cc.getId() && instanceIndex == cc.getInstanceIndex()) {
                return cc;
            }
            ++n;
        }
        return null;
    }

    public Control deepFind(int controlId) {
        Control[] controlArray = this.getMemberControls();
        int n = 0;
        int n2 = controlArray.length;
        while (n < n2) {
            Control c = controlArray[n];
            if (c instanceof CompoundControl) {
                Control c2 = ((CompoundControl)c).deepFind(controlId);
                if (c2 != null) {
                    return c2;
                }
            } else if (controlId == c.getId()) {
                return c;
            }
            ++n;
        }
        return null;
    }

    public final Object getClientProperty(Object key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public void putClientProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(key, value);
    }

    public static CompoundControlPersistence getPersistence() {
        return persistence;
    }

    public static void setPersistence(CompoundControlPersistence p) {
        persistence = p;
    }

    public boolean canBeMoved() {
        return true;
    }

    public boolean canBeMovedBefore() {
        return true;
    }

    public boolean canBeInsertedBefore() {
        return true;
    }

    public boolean canBeDeleted() {
        return true;
    }

    public boolean hasPresets() {
        return true;
    }

    protected static class ControlColumn
    extends CompoundControl {
        public ControlColumn() {
            super(0, "");
        }

        public void add(Control c) {
            super.add(c);
        }

        public boolean isAlwaysVertical() {
            return true;
        }

        public boolean isNeverBordered() {
            return true;
        }
    }

    protected static class ControlRow
    extends CompoundControl {
        public ControlRow() {
            super(0, "");
        }

        public void add(Control c) {
            super.add(c);
        }

        public boolean isAlwaysHorizontal() {
            return true;
        }

        public boolean isNeverBordered() {
            return true;
        }
    }

    public static class BypassControl
    extends BooleanControl {
        public BypassControl(int id) {
            super(id, "Bypass", true);
            this.setHidden(true);
        }
    }
}

