/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.CompoundControlPersistence;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlSysexMsg;
import uk.org.toot.control.MidiPersistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundControlMidiPersistence
implements CompoundControlPersistence {
    private File root;

    public CompoundControlMidiPersistence(File root) {
        this.root = root;
    }

    @Override
    public List<String> getPresets(CompoundControl c) {
        File[] files;
        File dir = new File(this.root, this.path(c.getProviderId(), c.getId()));
        ArrayList<String> names = new ArrayList<String>();
        if (!dir.exists() || !dir.isDirectory()) {
            return names;
        }
        File[] fileArray = files = dir.listFiles();
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File file = fileArray[n];
            if (!file.isDirectory()) {
                names.add(file.getName());
            }
            ++n;
        }
        return names;
    }

    @Override
    public void loadPreset(CompoundControl c, String name) {
        int moduleId;
        int providerId = c.getProviderId();
        File path = new File(this.root, this.path(providerId, moduleId = c.getId()));
        File file = new File(path, name);
        if (!file.exists()) {
            return;
        }
        try {
            Sequence sequence = MidiSystem.getSequence(file);
            Track track = sequence.getTracks()[0];
            int i = 0;
            while (i < track.size()) {
                Control control;
                MidiMessage msg = track.get(i).getMessage();
                if (ControlSysexMsg.isControl(msg) && ControlSysexMsg.getProviderId(msg) == providerId && ControlSysexMsg.getModuleId(msg) == moduleId && (control = c.deepFind(ControlSysexMsg.getControlId(msg))) != null && !(control instanceof CompoundControl.BypassControl)) {
                    control.setIntValue(ControlSysexMsg.getValue(msg));
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InvalidMidiDataException imde) {
            imde.printStackTrace();
        }
    }

    @Override
    public void savePreset(CompoundControl c, String name) {
        int providerId = c.getProviderId();
        int moduleId = c.getId();
        try {
            Sequence sequence = new Sequence(0.0f, 1);
            Track track = sequence.createTrack();
            MidiPersistence.store(providerId, moduleId, 0, c, track);
            File path = new File(this.root, this.path(providerId, moduleId));
            path.mkdirs();
            MidiSystem.write(sequence, 0, new File(path, name));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InvalidMidiDataException imde) {
            imde.printStackTrace();
        }
    }

    protected String path(int providerId, int moduleId) {
        return String.valueOf(providerId) + File.separator + moduleId;
    }

    protected String path(int providerId, int moduleId, String name) {
        return String.valueOf(this.path(providerId, moduleId)) + File.separator + name;
    }
}

