/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import java.util.List;
import uk.org.toot.control.Control;

public abstract class EnumControl
extends Control {
    private Object value;

    public EnumControl(int id, String name, Object value) {
        super(id, name);
        this.value = value;
    }

    public void setValue(Object value) {
        if (this.indicator) {
            return;
        }
        if (!this.isValueSupported(value)) {
            throw new IllegalArgumentException("Requested value " + value + " is not supported.");
        }
        if (!value.equals(this.value)) {
            this.value = value;
            this.notifyParent(this);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public abstract List getValues();

    protected boolean isValueSupported(Object value) {
        return this.getValues().contains(value);
    }

    public String toString() {
        return String.valueOf(this.getName()) + " with current value: " + this.getValue();
    }

    public String getValueString() {
        return this.getValue().toString();
    }

    public void setIntValue(int value) {
        this.setValue(this.getValues().get(value));
    }

    public int getIntValue() {
        return this.getValues().indexOf(this.getValue());
    }

    public boolean isWidthLimited() {
        return true;
    }
}

