/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.control;

import uk.org.toot.control.ControlLaw;
import uk.org.toot.control.LawControl;

public class FloatControl
extends LawControl {
    private final String minLabel;
    private final String maxLabel;
    private final String midLabel;

    public FloatControl(int id, String name, ControlLaw law, float precision, float initialValue) {
        this(id, name, law, precision, initialValue, "", "", "");
    }

    public FloatControl(int id, String name, ControlLaw law, float precision, float initialValue, String minLabel, String midLabel, String maxLabel) {
        super(id, name, law, precision, initialValue);
        this.minLabel = minLabel == null ? "" : minLabel;
        this.midLabel = midLabel == null ? "" : midLabel;
        this.maxLabel = maxLabel == null ? "" : maxLabel;
    }

    public boolean isRotary() {
        return true;
    }

    public float getMaximum() {
        return this.getLaw().getMaximum();
    }

    public float getMinimum() {
        return this.getLaw().getMinimum();
    }

    public String getMinLabel() {
        return this.minLabel;
    }

    public String getMidLabel() {
        return this.midLabel;
    }

    public String getMaxLabel() {
        return this.maxLabel;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " with current value: " + this.getValue() + " " + this.getLaw().getUnits() + " (range: " + this.getMinimum() + " - " + this.getMaximum() + ")";
    }
}

