/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.debug;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Observable;
import java.util.Timer;
import java.util.TimerTask;

public class ThreadLoad
extends Observable {
    protected static ThreadMXBean mxbean = ManagementFactory.getThreadMXBean();
    protected static Timer timer;

    static {
        if (!mxbean.isThreadCpuTimeSupported()) {
            System.out.println("Thread CPU Time is NOT supported");
        } else {
            if (!mxbean.isThreadCpuTimeEnabled()) {
                mxbean.setThreadCpuTimeEnabled(true);
            }
            if (mxbean.isThreadContentionMonitoringSupported()) {
                if (!mxbean.isThreadContentionMonitoringEnabled()) {
                    mxbean.setThreadContentionMonitoringEnabled(true);
                }
            } else {
                System.out.println("Thread Contention Monitoring is NOT supported");
            }
        }
        timer = new Timer("ThreadLoad Timer");
    }

    public ThreadLoad(String threadName, long milliseconds) {
        long threadId = ThreadLoad.getThreadId(threadName);
        if (threadId < 0L) {
            System.err.println(String.valueOf(threadName) + " thread id not found");
        } else {
            timer.schedule((TimerTask)new Task(threadId), milliseconds, milliseconds);
        }
    }

    protected static long getThreadId(String threadName) {
        long[] ids = mxbean.getAllThreadIds();
        int i = 0;
        while (i < ids.length) {
            if (mxbean.getThreadInfo(ids[i]).getThreadName().equals(threadName)) {
                return ids[i];
            }
            ++i;
        }
        return -1L;
    }

    protected class Task
    extends TimerTask {
        private long id;
        private long prevNanos = 0L;
        private long prevCpuNanos = 0L;
        private long prevUserNanos = 0L;
        private long prevBlockedMillis = 0L;
        private long prevWaitedMillis = 0L;

        public Task(long threadId) {
            this.id = threadId;
        }

        public void run() {
            long nanos = System.nanoTime();
            long elapsed = nanos - this.prevNanos;
            this.prevNanos = nanos;
            Info loadInfo = new Info();
            long cpuNanos = mxbean.getThreadCpuTime(this.id);
            loadInfo.cpu = (int)(100L * (cpuNanos - this.prevCpuNanos) / elapsed);
            this.prevCpuNanos = cpuNanos;
            long userNanos = mxbean.getThreadUserTime(this.id);
            loadInfo.user = (int)(100L * (userNanos - this.prevUserNanos) / elapsed);
            this.prevUserNanos = userNanos;
            ThreadInfo info = mxbean.getThreadInfo(this.id);
            if (info == null) {
                return;
            }
            long blockedMillis = info.getBlockedTime();
            loadInfo.blocked = (int)(100L * (blockedMillis - this.prevBlockedMillis) / (elapsed /= 1000000L));
            this.prevBlockedMillis = blockedMillis;
            long waitedMillis = info.getWaitedTime();
            loadInfo.waited = (int)(100L * (waitedMillis - this.prevWaitedMillis) / elapsed);
            this.prevWaitedMillis = waitedMillis;
            System.out.println(String.valueOf(info.getThreadName()) + ": " + loadInfo.cpu + "% " + loadInfo.user + "% " + loadInfo.blocked + "% " + loadInfo.waited + "%");
        }
    }

    public class Info {
        public int cpu;
        public int user;
        public int blocked;
        public int waited;
    }
}

