/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.org.toot.midi.core.ConnectedMidiSystem;
import uk.org.toot.midi.core.DefaultMidiSystem;
import uk.org.toot.midi.core.MidiConnection;
import uk.org.toot.midi.core.MidiDevice;
import uk.org.toot.midi.core.MidiInput;
import uk.org.toot.midi.core.MidiOutput;
import uk.org.toot.midi.core.MidiPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConnectedMidiSystem
extends DefaultMidiSystem
implements ConnectedMidiSystem {
    private List<MidiConnection> connections = new ArrayList<MidiConnection>();

    @Override
    public List<MidiConnection> getMidiConnections() {
        return Collections.unmodifiableList(this.connections);
    }

    @Override
    public void createMidiConnection(MidiOutput from, MidiInput to, int flags) {
        MidiConnection connection = new MidiConnection(from, to, flags);
        this.connections.add(connection);
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void closeMidiConnection(MidiOutput from, MidiInput to) {
        MidiConnection connection = this.getConnection(from, to);
        this.connections.remove(connection);
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void createMidiConnection(String fromPortName, String toPortName, int flags) {
        MidiOutput from = (MidiOutput)this.getPort(fromPortName, true);
        MidiInput to = (MidiInput)this.getPort(toPortName, false);
        this.createMidiConnection(from, to, flags);
    }

    @Override
    public void closeMidiConnection(String fromPortName, String toPortName) {
        MidiOutput from = (MidiOutput)this.getPort(fromPortName, true);
        MidiInput to = (MidiInput)this.getPort(toPortName, false);
        this.closeMidiConnection(from, to);
    }

    protected MidiConnection getConnection(MidiOutput from, MidiInput to) {
        for (MidiConnection c : this.connections) {
            if (c.getMidiOutput() != from || c.getMidiInput() != to) continue;
            return c;
        }
        throw new IllegalArgumentException("MidiConnection from " + from.getName() + " to " + to.getName());
    }

    protected MidiPort getPort(String name, boolean isOut) {
        for (MidiDevice device : this.getMidiDevices()) {
            List<MidiPort> ports = isOut ? device.getMidiOutputs() : device.getMidiInputs();
            for (MidiPort port : ports) {
                if (!name.equals(port.getName())) continue;
                return port;
            }
        }
        String portString = isOut ? "MidiOutput" : "MidiInput";
        throw new IllegalArgumentException(String.valueOf(name) + " " + portString + " not found");
    }
}

