/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.core;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import uk.org.toot.midi.core.AbstractMidiDevice;
import uk.org.toot.midi.core.DefaultMidiOutput;
import uk.org.toot.midi.core.MidiInput;
import uk.org.toot.midi.core.MidiSystem;

public class LegacyDevices {
    public static void addDevice(MidiDevice device, MidiSystem system) throws MidiUnavailableException {
        system.addMidiDevice(new DeviceAdaptor(device));
    }

    public static void installPlatformPorts(MidiSystem system) {
        MidiDevice device = null;
        MidiDevice.Info[] infos = javax.sound.midi.MidiSystem.getMidiDeviceInfo();
        int maxtx = 0;
        int maxrx = 0;
        int i = 0;
        while (i < infos.length) {
            try {
                device = javax.sound.midi.MidiSystem.getMidiDevice(infos[i]);
                maxtx = device.getMaxTransmitters();
                maxrx = device.getMaxReceivers();
                if (maxtx == 0 || maxrx == 0) {
                    LegacyDevices.addDevice(device, system);
                }
            }
            catch (MidiUnavailableException e) {
                System.err.println(String.valueOf(infos[i].getName()) + " Unavailable!");
            }
            ++i;
        }
    }

    public static void installPlatformComponents(MidiSystem system) {
        MidiDevice device = null;
        MidiDevice.Info[] infos = javax.sound.midi.MidiSystem.getMidiDeviceInfo();
        int maxtx = 0;
        int maxrx = 0;
        int i = 0;
        while (i < infos.length) {
            try {
                device = javax.sound.midi.MidiSystem.getMidiDevice(infos[i]);
                maxtx = device.getMaxTransmitters();
                maxrx = device.getMaxReceivers();
                if (maxtx != 0 && maxrx != 0) {
                    LegacyDevices.addDevice(device, system);
                }
            }
            catch (MidiUnavailableException e) {
                System.err.println(String.valueOf(infos[i].getName()) + " Unavailable!");
            }
            ++i;
        }
    }

    static class DeviceAdaptor
    extends AbstractMidiDevice {
        protected MidiDevice device;

        public DeviceAdaptor(MidiDevice device) throws MidiUnavailableException {
            super("");
            this.device = device;
            if (device.getMaxReceivers() != 0) {
                this.addMidiInput(new DeviceMidiInput(device));
            }
            if (device.getMaxTransmitters() != 0) {
                this.addMidiOutput(new DeviceMidiOutput(device));
            }
            this.open();
        }

        protected static String simpleName(String name) {
            String[] parts = name.split("\\s");
            if (parts == null) {
                return name;
            }
            if (name.startsWith("Microsoft ")) {
                return name.substring("Microsoft ".length(), name.length());
            }
            return name;
        }

        public void open() throws MidiUnavailableException {
            if (!this.isOpen()) {
                this.device.open();
            }
        }

        public void close() {
            this.device.close();
        }

        public boolean isOpen() {
            return this.device.isOpen();
        }

        public String getProvider() {
            return this.device.getDeviceInfo().getVendor();
        }

        public String getDescription() {
            return this.device.getDeviceInfo().getDescription();
        }

        public static class DeviceMidiInput
        implements MidiInput {
            private Receiver receiver;
            private MidiDevice device;

            public DeviceMidiInput(MidiDevice device) throws MidiUnavailableException {
                this.device = device;
                this.receiver = device.getReceiver();
            }

            public void transport(MidiMessage message, long timestamp) {
                this.receiver.send(message, timestamp);
            }

            public int getLatency() {
                if (this.device instanceof Synthesizer) {
                    return (int)((Synthesizer)this.device).getLatency();
                }
                return 0;
            }

            public String getName() {
                return DeviceAdaptor.simpleName(this.device.getDeviceInfo().getName());
            }
        }

        public static class DeviceMidiOutput
        extends DefaultMidiOutput {
            Transmitter tx;

            public DeviceMidiOutput(MidiDevice device) throws MidiUnavailableException {
                super(DeviceAdaptor.simpleName(device.getDeviceInfo().getName()));
                this.tx = device.getTransmitter();
                this.tx.setReceiver(new Receiver(this){
                    final /* synthetic */ DeviceMidiOutput this$2;
                    {
                        this.this$2 = deviceMidiOutput;
                    }

                    public void send(MidiMessage message, long timestamp) {
                        this.this$2.transport(message, timestamp);
                    }

                    public void close() {
                    }
                });
            }

            public void close() {
                this.tx.setReceiver(null);
                this.tx.close();
            }
        }
    }
}

