/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.core;

import javax.sound.midi.MidiUnavailableException;
import uk.org.toot.midi.core.MidiInput;
import uk.org.toot.midi.core.MidiOutput;

public class MidiConnection {
    public static final int PLAYBACK = 1;
    public static final int SYSTEM = 2;
    public static final int OUTPUT_LOCKED = 4;
    public static final int INPUT_LOCKED = 8;
    private MidiOutput from;
    private MidiInput to;
    private int flags = 0;

    public MidiConnection(MidiOutput from, MidiInput to) {
        this(from, to, 0);
    }

    public MidiConnection(MidiOutput from, MidiInput to, int flags) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("MidiConnection constructor null argument");
        }
        this.from = from;
        this.to = to;
        this.flags = flags;
        from.addConnectionTo(to);
    }

    public void connectTo(MidiInput to) throws MidiUnavailableException {
        if ((this.flags & 8) != 0) {
            throw new IllegalStateException("MidiConnection input is locked");
        }
        if (to == null) {
            throw new IllegalArgumentException("MidiConnection can't connectTo(null)");
        }
        this.from.removeConnectionTo(this.to);
        this.to = to;
        this.from.addConnectionTo(to);
    }

    public void connectFrom(MidiOutput from) throws MidiUnavailableException {
        if ((this.flags & 4) != 0) {
            throw new IllegalStateException("MidiConnection output is locked");
        }
        if (from == null) {
            throw new IllegalArgumentException("MidiConnection can't connectFrom(null)");
        }
        this.from.removeConnectionTo(this.to);
        this.from = from;
        this.from.addConnectionTo(this.to);
    }

    public void close() {
        this.from.removeConnectionTo(this.to);
        this.from = null;
        this.to = null;
    }

    public MidiOutput getMidiOutput() {
        return this.from;
    }

    public MidiInput getMidiInput() {
        return this.to;
    }

    public boolean isSystem() {
        return (this.flags & 2) != 0;
    }

    public boolean isPlayback() {
        return (this.flags & 1) != 0;
    }
}

