/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midi.core.channel;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import uk.org.toot.midi.core.MidiTransport;
import uk.org.toot.midi.core.channel.MidiChannelWriter;
import uk.org.toot.midi.message.ChannelMsg;
import uk.org.toot.midi.misc.Controller;

public class DefaultMidiChannelWriter
implements MidiChannelWriter {
    private MidiTransport port;
    private int index;

    public DefaultMidiChannelWriter(MidiTransport port, int index) {
        this.index = index;
        this.port = port;
    }

    public int getIndex() {
        return this.index & 0xF;
    }

    public void encode(int command, int data1, int data2) {
        try {
            MidiMessage msg = ChannelMsg.createChannel(command, this.index, data1, data2);
            this.port.transport(msg, -1L);
        }
        catch (InvalidMidiDataException imde) {
            imde.printStackTrace();
        }
    }

    public void encode(int command, int data) {
        this.encode(command, data, 0);
    }

    private void setPseudoControl(int control, int value) {
        switch (control) {
            case -224: {
                this.setPitchBend(value);
                break;
            }
            case -160: {
                break;
            }
            case -208: {
                this.setChannelPressure(value);
                break;
            }
            case -192: {
                this.programChange(value);
            }
        }
    }

    public void setPitchBend(int bend) {
        int msb = bend >> 7;
        int lsb = bend & 0x3F;
        this.encode(224, lsb, msb);
    }

    public void setControl(int control, int value) {
        if (control < 0) {
            this.setPseudoControl(control, value);
            return;
        }
        if (Controller.is7bit(control)) {
            this.controlChange(control, value);
        } else {
            int msb = value >> 7;
            this.controlChange(control &= 0x1F, msb);
        }
    }

    public void noteOn(int noteNumber, int velocity) {
        this.encode(144, noteNumber, velocity);
    }

    public void noteOff(int noteNumber, int velocity) {
        this.encode(128, noteNumber, velocity);
    }

    public void noteOff(int noteNumber) {
        this.encode(128, noteNumber, 0);
    }

    public void setPolyPressure(int noteNumber, int pressure) {
        this.encode(160, noteNumber, pressure);
    }

    public void setChannelPressure(int pressure) {
        this.encode(208, pressure);
    }

    public void controlChange(int controller, int value) {
        this.encode(176, controller, value);
    }

    public void programChange(int program) {
        this.encode(192, program);
    }

    public void programChange(int bank, int program) {
    }

    public void resetAllControllers() {
        this.encode(176, 121, 0);
    }

    public void allNotesOff() {
        this.encode(176, 123, 0);
    }

    public void allSoundOff() {
        this.encode(176, 120, 0);
    }

    public boolean localControl(boolean local) {
        this.encode(176, 122, local ? 127 : 0);
        return local;
    }

    public void setVolume(int volume) {
        this.setControl(7, volume);
    }

    public void setPan(int pan) {
        this.setControl(10, pan);
    }

    public void setMono(boolean on) {
        this.encode(176, 126, on ? 127 : 0);
    }

    public void setOmni(boolean on) {
        this.encode(176, 125, on ? 127 : 0);
    }

    public void setMute(boolean mute) {
    }

    public void setSolo(boolean soloState) {
    }
}

