/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.midix.control.neck;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import uk.org.toot.midix.control.neck.AShapeBarre;
import uk.org.toot.midix.control.neck.CShapeBarre;
import uk.org.toot.midix.control.neck.ChordShape;
import uk.org.toot.midix.control.neck.EShapeBarre;
import uk.org.toot.midix.control.neck.GShapeBarre;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChordFamily {
    private Hashtable<String, ChordShape> types = new Hashtable();
    private int rootString = -1;
    private static ArrayList<ChordFamily> families = new ArrayList();
    private String name;

    static {
        families.add(new CShapeBarre());
        families.add(new AShapeBarre());
        families.add(new GShapeBarre());
        families.add(new EShapeBarre());
    }

    public static ChordFamily named(String name) {
        for (ChordFamily f : families) {
            if (!name.equals(f.getName())) continue;
            return f;
        }
        return families.get(0);
    }

    public ChordFamily(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ChordShape create(String type) {
        ChordShape shape = new ChordShape();
        this.types.put(type, shape);
        return shape;
    }

    public ChordShape get(String type) {
        ChordShape shape = this.types.get(type);
        return shape;
    }

    protected void checkAll() {
        for (String type : this.keySet()) {
            this.checkShape(type);
        }
    }

    protected abstract void checkShape(String var1);

    public abstract ChordFamily other();

    public int getRootString() {
        return this.rootString;
    }

    protected void setRootString(int n) {
        this.rootString = n;
    }

    public Set<String> keySet() {
        return this.types.keySet();
    }
}

