/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.composition;

import uk.org.toot.music.Note;
import uk.org.toot.music.composition.AbstractComposer;
import uk.org.toot.music.tonality.Key;

public class RhythmicComposer
extends AbstractComposer {
    public int[] composeBar(Key key) {
        long timing = this.getContext().createTiming();
        int[] notes = new int[Long.bitCount(timing)];
        int n = 0;
        int i = 0;
        while (i < 64) {
            if ((timing & 1L << i) != 0L) {
                notes[n++] = Note.create(i, this.getContext().nextDrum(), this.getContext().getLevel(i));
            }
            ++i;
        }
        return notes;
    }

    public Context getContext() {
        return (Context)super.getContext();
    }

    public static abstract class Context
    extends AbstractComposer.Context {
        public abstract int nextDrum();
    }

    public static class SingleDrumContext
    extends Context {
        private int drum;

        public SingleDrumContext(int drum) {
            this.drum = drum;
        }

        public int nextDrum() {
            return this.drum;
        }
    }

    public static class DualDrumContext
    extends Context {
        private int drum1;
        private float probability1;
        private int drum2;

        public DualDrumContext(int drum1, float probability1, int drum2) {
            this.drum1 = drum1;
            this.probability1 = probability1;
            this.drum2 = drum2;
        }

        public int nextDrum() {
            return Math.random() < (double)this.probability1 ? this.drum1 : this.drum2;
        }
    }
}

