/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.tonality;

import uk.org.toot.music.tonality.ChordMode;
import uk.org.toot.music.tonality.Interval;
import uk.org.toot.music.tonality.Pitch;

public class Chord {
    private String symbol;
    private String spelling;
    private String name;
    private int[] intervals;

    public Chord(String aSymbol, String aSpelling, String aName) {
        this.symbol = aSymbol;
        this.spelling = aSpelling;
        this.name = aName;
        this.decodeIntervals(this.spelling);
    }

    void decodeIntervals(String aSpelling) {
        String[] intervalStrings = aSpelling.split("\\s");
        this.intervals = new int[intervalStrings.length];
        int i = 0;
        while (i < this.intervals.length) {
            this.intervals[i] = Interval.spelt(intervalStrings[i]);
            ++i;
        }
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getSpelling() {
        return this.spelling;
    }

    public String getName() {
        return this.name;
    }

    public int[] getIntervals() {
        return this.intervals;
    }

    public int getPoly() {
        return this.intervals.length;
    }

    public boolean matchesIntervals(int[] someIntervals) {
        if (this.intervals.length != someIntervals.length) {
            return false;
        }
        int i = 0;
        while (i < this.intervals.length) {
            if (this.intervals[i] != someIntervals[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] missingIntervals(int[] someIntervals, int missing) {
        if (someIntervals.length < 2) {
            return null;
        }
        if (missing == 0) {
            return this.matchesIntervals(someIntervals) ? new int[]{} : null;
        }
        if (this.intervals.length != someIntervals.length + missing) {
            return null;
        }
        int misses = 0;
        int[] missingIndices = new int[missing];
        int j = 0;
        int i = 0;
        while (i < this.intervals.length) {
            if (j == someIntervals.length || this.intervals[i] != someIntervals[j]) {
                if (i == 0) {
                    return null;
                }
                if (misses == missingIndices.length) {
                    return null;
                }
                missingIndices[misses++] = i;
            } else {
                ++j;
            }
            ++i;
        }
        if (j != someIntervals.length) {
            return null;
        }
        if (misses != missing) {
            return null;
        }
        return missingIndices;
    }

    public boolean matchesChordMode(int[] chordMode) {
        int i = 0;
        while (i < this.intervals.length) {
            if (!ChordMode.hasInterval(chordMode, this.intervals[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.getSymbol();
    }

    public static class Voicing {
        private Chord chord;
        private int[] missingIndices = null;

        public Voicing(Chord chord) {
            this.chord = chord;
        }

        public Voicing(Chord chord, int[] missingIndices) {
            this.chord = chord;
            this.missingIndices = missingIndices;
        }

        public Chord getChord() {
            return this.chord;
        }

        public int[] getMissingIndices() {
            return this.missingIndices;
        }

        public int[] getIntervals() {
            int[] allIntervals = this.getChord().getIntervals();
            if (this.missingIndices == null || this.missingIndices.length == 0) {
                return allIntervals;
            }
            int[] intervals = new int[allIntervals.length - this.missingIndices.length];
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < allIntervals.length) {
                if (this.missingIndices[k] == i) {
                    ++k;
                } else {
                    intervals[j++] = allIntervals[i];
                }
                ++i;
            }
            return intervals;
        }

        public String getMissingString() {
            String missingString = "";
            if (this.missingIndices != null) {
                int[] intervals = this.getChord().getIntervals();
                int i = 0;
                while (i < this.missingIndices.length) {
                    missingString = String.valueOf(missingString) + " no " + Interval.spell(intervals[this.missingIndices[i]]);
                    ++i;
                }
            }
            return missingString;
        }

        public String toString() {
            return String.valueOf(this.getChord().getSymbol()) + this.getMissingString();
        }
    }

    public static class PitchedVoicing {
        private Voicing voicing;
        private int root;
        private int slashBass = -1;

        public PitchedVoicing(Voicing voicing, int root) {
            this.voicing = voicing;
            this.root = root;
        }

        public PitchedVoicing(Voicing voicing, int root, int slashBass) {
            this(voicing, root);
            this.slashBass = slashBass;
        }

        public Voicing getVoicing() {
            return this.voicing;
        }

        public int getRoot() {
            return this.root;
        }

        public Chord getChord() {
            return this.getVoicing().getChord();
        }

        public int[] getPitches() {
            int[] intervals = this.getVoicing().getIntervals();
            int[] notes = new int[intervals.length];
            int i = 0;
            while (i < notes.length) {
                notes[i] = this.root + intervals[i];
                ++i;
            }
            return notes;
        }

        public String getSlashString() {
            if (this.slashBass < 0 || this.slashBass == this.root) {
                return "";
            }
            return " / " + Pitch.className(this.slashBass);
        }

        public String toString() {
            return String.valueOf(Pitch.className(this.root)) + this.getVoicing().toString() + this.getSlashString();
        }
    }
}

