/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.tonality;

public class ChordMode {
    public static final int SECUNDAL = 1;
    public static final int TERTIAN = 3;
    public static final int QUARTAL = 5;

    private ChordMode() {
    }

    public static int interval(int[] chordMode, int index) {
        return chordMode[index % chordMode.length];
    }

    public static int interval(int[] chordMode, int index1, int index2) {
        return ChordMode.interval(ChordMode.interval(chordMode, index1), ChordMode.interval(chordMode, index2));
    }

    protected static int interval(int i1, int i2) {
        if (i2 < i1) {
            i2 += 12;
        }
        return i2 - i1;
    }

    public static int[] getIntervals(int[] chordMode, int poly, int lowInterval) {
        if (poly < 1 || poly > 7) {
            throw new IllegalArgumentException("invalid polyphony = " + poly);
        }
        int[] intervals = new int[poly];
        int i = 0;
        int j = 0;
        intervals[j] = 0;
        ++j;
        while (j < poly) {
            int interval = ChordMode.interval(intervals[j - 1], chordMode[i]);
            if (interval == lowInterval || interval == lowInterval + 1) {
                intervals[j] = intervals[j - 1] + interval;
                ++j;
            }
            ++i;
            i %= chordMode.length;
        }
        return intervals;
    }

    public static boolean hasInterval(int[] chordMode, int interval) {
        interval %= 12;
        int i = 0;
        while (i < chordMode.length) {
            if (chordMode[i] == interval) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

