/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.music.tonality;

public class Pitch {
    private static String[] flatNames = new String[]{"C", "Db", "D", "Eb", "E", "F", "Gb", "G", "Ab", "A", "Bb", "B"};
    private static String[] sharpNames = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};

    private Pitch() {
    }

    public static String name(int pitch) {
        return String.valueOf(Pitch.className(pitch)) + (pitch / 12 - 1);
    }

    public static int value(String name, int register) {
        return Pitch.value(Pitch.classValue(name), register);
    }

    public static int value(int pitchClass, int register) {
        return pitchClass + 12 * (register + 1);
    }

    public static boolean isWhite(int pitch) {
        return !Pitch.isBlack(pitch);
    }

    public static boolean isBlack(int pitch) {
        int pc = Pitch.classValue(pitch);
        return pc == 1 || pc == 3 || pc == 6 || pc == 8 || pc == 10;
    }

    public static String className(int pitch) {
        return flatNames[Pitch.classValue(pitch)];
    }

    public static String classNames(int[] pitches) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < pitches.length) {
            sb.append(Pitch.className(pitches[i]));
            if (i < pitches.length - 1) {
                sb.append(' ');
            }
            ++i;
        }
        return sb.toString();
    }

    public static int classValue(int pitch) {
        if (pitch < 0) {
            throw new IllegalArgumentException("pitch < 0");
        }
        return pitch % 12;
    }

    public static int classValue(String pitch) {
        int qual = 32;
        char letter = Character.toUpperCase(pitch.charAt(0));
        int base = 0;
        int offset = 0;
        switch (letter) {
            case 'C': {
                base = 0;
                break;
            }
            case 'D': {
                base = 2;
                break;
            }
            case 'E': {
                base = 4;
                break;
            }
            case 'F': {
                base = 5;
                break;
            }
            case 'G': {
                base = 7;
                break;
            }
            case 'A': {
                base = 9;
                break;
            }
            case 'B': {
                base = 11;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(pitch) + " is not a valid pitch");
            }
        }
        if (pitch.length() > 1) {
            qual = pitch.charAt(1);
        }
        if (qual == 35) {
            ++offset;
        } else if (qual == 98) {
            --offset;
        }
        return Pitch.classValue(base + offset);
    }

    public static int[] classValues(String pitches) {
        String[] notes = pitches.split("\\s+");
        int[] values = new int[notes.length];
        int j = 0;
        int i = 0;
        while (i < notes.length) {
            try {
                values[j] = Pitch.classValue(notes[i]);
                ++j;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        while (j < values.length) {
            values[j] = values[j - 1];
            ++j;
        }
        return Pitch.distinctClasses(values);
    }

    public static int classCount(int[] pitches) {
        int count = 0;
        int mask = 0;
        int i = 0;
        while (i < pitches.length) {
            int pc = Pitch.classValue(pitches[i]);
            int bit = 1 << pc;
            if ((mask & bit) == 0) {
                mask |= bit;
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int[] distinctClasses(int[] pitches) {
        int count = Pitch.classCount(pitches);
        if (count == pitches.length) {
            return pitches;
        }
        int[] distinct = new int[count];
        count = 0;
        int mask = 0;
        int i = 0;
        while (i < pitches.length) {
            int pc = Pitch.classValue(pitches[i]);
            int bit = 1 << pc;
            if ((mask & bit) == 0) {
                mask |= bit;
                distinct[count++] = pitches[i];
            }
            ++i;
        }
        return distinct;
    }
}

