/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.audioui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.org.toot.audio.core.AudioControls;
import uk.org.toot.audio.core.AudioControlsChain;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlSelector;
import uk.org.toot.swingui.audioui.AudioCompoundControlPanel;
import uk.org.toot.swingui.controlui.ControlPanelFactory;
import uk.org.toot.swingui.controlui.PanelFactory;

public class AudioPanelFactory
extends ControlPanelFactory {
    protected boolean canBypass(CompoundControl control) {
        if (control instanceof AudioControls) {
            return ((AudioControls)control).canBypass();
        }
        return false;
    }

    protected JComponent createHeader(CompoundControl control, int axis) {
        boolean isShort = false;
        String title = control.getName();
        if (this.isMinimised(title) || axis == 1) {
            title = this.shorten(title);
            isShort = true;
        }
        if (this.canBypass(control)) {
            BypassButton button = new BypassButton(title, control, ((AudioControls)control).getBypassControl());
            if (isShort) {
                button.setToolTipText(control.getName());
            }
            button.setBorder(BorderFactory.createRaisedBevelBorder());
            return button;
        }
        if (control instanceof AudioControlsChain) {
            JPanel hdr = new JPanel();
            hdr.setLayout(new BoxLayout(hdr, axis));
            JLabel titleLabel = new JLabel(title, 0);
            titleLabel.setAlignmentX(0.5f);
            hdr.add(titleLabel);
            if (axis == 0) {
                hdr.add(Box.createHorizontalStrut(16));
            }
            hdr.add(new SourceLabel((AudioControlsChain)control, axis));
            return hdr;
        }
        return super.createHeader(control, axis);
    }

    protected void createTop(JComponent parent, CompoundControl control, int axis) {
        for (Control c : control.getControls()) {
            if (!c.isHidden() || !c.isIndicator()) continue;
            parent.add(this.createComponent(c, axis, false));
        }
    }

    protected JComponent createCompoundComponent(CompoundControl c, int axis, ControlSelector s, PanelFactory f, boolean hasBorder, boolean hasHeader) {
        return new AudioCompoundControlPanel(c, axis, s, f, hasBorder, hasHeader);
    }

    protected static class SourceLabel
    extends JLabel
    implements Observer {
        private AudioControlsChain chain;
        private int axis;

        public SourceLabel(AudioControlsChain chain, int axis) {
            super(" ", 0);
            this.chain = chain;
            this.axis = axis;
            this.setAlignmentX(0.5f);
            if (axis == 1) {
                this.setFont(this.getFont().deriveFont(10.0f));
            }
            this.labelSource(chain.getSourceLabel());
        }

        public void addNotify() {
            super.addNotify();
            this.chain.addObserver(this);
        }

        public void removeNotify() {
            this.chain.deleteObserver(this);
            super.removeNotify();
        }

        public void update(Observable obs, Object obj) {
            if (obj == null) {
                this.labelSource(this.chain.getSourceLabel());
            }
        }

        protected void labelSource(String string) {
            if (string == null) {
                string = " ";
            }
            if (this.axis == 1) {
                boolean tooLong = string.length() > 8;
                this.setText(tooLong ? string.substring(0, 8) : string);
                this.setToolTipText(tooLong ? string : null);
            } else {
                this.setText(string);
            }
        }
    }

    protected class BypassButton
    extends JButton
    implements Observer,
    ActionListener {
        private BooleanControl bypassControl;
        private AudioControls controls;
        private String name;

        public BypassButton(String title, CompoundControl cc, BooleanControl control) {
            super(title);
            this.bypassControl = control;
            this.controls = (AudioControls)cc;
            this.name = cc.getName();
            this.update(null, null);
        }

        public Dimension getMaximumSize() {
            Dimension d = super.getMaximumSize();
            if (!AudioPanelFactory.this.isMinimised(this.name)) {
                d.width = 512;
            }
            return d;
        }

        public void addNotify() {
            super.addNotify();
            this.bypassControl.addObserver(this);
            this.addActionListener(this);
        }

        public void removeNotify() {
            this.removeActionListener(this);
            this.bypassControl.deleteObserver(this);
            super.removeNotify();
        }

        public void actionPerformed(ActionEvent ae) {
            this.bypassControl.setValue(!this.bypassControl.getValue());
            this.controls.setBypassed(this.isSelected());
        }

        public void update(Observable obs, Object obj) {
            this.setForeground(this.bypassControl.getValue() ? Color.GRAY : Color.BLACK);
            this.setSelected(this.bypassControl.getValue());
        }
    }
}

