/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.audioui.faderui;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JSlider;
import uk.org.toot.audio.fader.FaderControl;

public class Fader
extends JSlider
implements Observer {
    private final FaderControl control;
    private static final String SINGLE_DASH = " -";
    private static final String DOUBLE_DASH = " --";

    public Fader(FaderControl control) {
        super(1, 0, control.getLaw().getResolution() - 1, 0);
        this.control = control;
        super.setValue(this.sliderValue(control.getValue()));
        this.setPaintTrack(false);
        this.setLabelTable(this.createLabelTable());
        this.setPaintLabels(true);
    }

    public void addNotify() {
        super.addNotify();
        this.control.addObserver(this);
    }

    public void removeNotify() {
        this.control.deleteObserver(this);
        super.removeNotify();
    }

    public void update(Observable obs, Object obj) {
        Fader.super.setValue(this.sliderValue(this.control.getValue()));
    }

    protected Hashtable createLabelTable() {
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        int i = 15;
        while (i > -101) {
            JLabel label = new JLabel(i == 0 ? DOUBLE_DASH : SINGLE_DASH);
            label.setHorizontalAlignment(4);
            table.put(new Integer(this.sliderValue(i)), label);
            i -= i > -39 ? 5 : 20;
        }
        return table;
    }

    protected float userValue(int sliderVal) {
        return this.control.getLaw().userValue(sliderVal);
    }

    protected int sliderValue(float userVal) {
        return this.control.getLaw().intValue(userVal);
    }

    public void setValue(int sliderVal) {
        super.setValue(sliderVal);
        this.control.setValue(this.userValue(sliderVal));
    }

    public Color getInsertColor() {
        return this.control.getInsertColor();
    }
}

