/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.audioui.meterui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import uk.org.toot.control.FloatControl;
import uk.org.toot.swingui.audioui.meterui.AbstractMeterIndicatorPanel;

public class GainReductionIndicatorPanel
extends AbstractMeterIndicatorPanel {
    private FloatControl indicator;
    private MeterMovement movement;

    public GainReductionIndicatorPanel(FloatControl indicator) {
        super(indicator, 59);
        this.indicator = indicator;
        this.setLayout(new BoxLayout(this, 1));
        this.movement = new MeterMovement();
        this.add(this.movement);
    }

    protected void pollAndUpdate() {
        if (!this.isShowing()) {
            return;
        }
        this.movement.updateState(this.indicator.getValue());
    }

    public int dBtoX(float dB) {
        float mindB = this.indicator.getMinimum();
        float maxdB = this.indicator.getMaximum();
        float dBRange = maxdB - mindB;
        int width = this.getWidth();
        if (width == 0) {
            return 0;
        }
        float c = maxdB / dBRange * (float)(width - 2);
        float m = (float)(2 - width) / dBRange;
        int x = (int)(m * dB + c);
        return width - x;
    }

    public class MeterMovement
    extends JPanel {
        private Marker bar = new Marker(Color.yellow);

        public MeterMovement() {
            this.setBackground(Color.darkGray);
            this.setMaximumSize(new Dimension(128, 10));
            this.setPreferredSize(new Dimension(100, 10));
            this.setMinimumSize(new Dimension(24, 6));
        }

        public void updateState(float dB) {
            this.bar.setdB(dB);
        }

        protected class Marker {
            protected Color color;
            protected int prevX = 10000;

            public Marker(Color c) {
                this.color = c;
            }

            public void setdB(float dB) {
                this.indicate(dB);
            }

            protected void indicate(float dB) {
                int x = GainReductionIndicatorPanel.this.dBtoX(dB);
                if (x == this.prevX) {
                    return;
                }
                Graphics g = MeterMovement.this.getGraphics();
                int h = MeterMovement.this.getHeight() - 2;
                int w = MeterMovement.this.getWidth() - 2;
                int x0 = GainReductionIndicatorPanel.this.dBtoX(-6.0f);
                int x1 = GainReductionIndicatorPanel.this.dBtoX(-12.0f);
                if (x > this.prevX) {
                    g.setColor(Color.darkGray);
                    g.fillRect(this.prevX, 1, x - 1, h);
                }
                this.prevX = x;
                g.setColor(Color.green);
                if (dB > -6.0f) {
                    g.fillRect(x, 1, w - x, h);
                } else if (dB > -12.0f) {
                    g.fillRect(x0, 1, w - x0, h);
                    g.setColor(Color.yellow);
                    g.fillRect(x, 1, x0 - x, h);
                } else {
                    g.fillRect(x0, 1, w - x0, h);
                    g.setColor(Color.yellow);
                    g.fillRect(x1, 1, x0 - x1, h);
                    g.setColor(Color.red);
                    g.fillRect(x, 1, x1 - x, h);
                }
                g.setColor(Color.darkGray);
                int i = 1;
                while (i >= -3) {
                    x = GainReductionIndicatorPanel.this.dBtoX(i);
                    g.drawLine(x, 1, x, h);
                    --i;
                }
                i = -6;
                while (i >= -24) {
                    x = GainReductionIndicatorPanel.this.dBtoX(i);
                    g.drawLine(x, 1, x, h);
                    i -= 3;
                }
            }
        }
    }
}

