/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.audioui.meterui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import uk.org.toot.audio.core.ChannelFormat;
import uk.org.toot.audio.meter.MeterControls;
import uk.org.toot.swingui.audioui.meterui.AbstractMeterIndicatorPanel;

public class KMeterIndicatorPanel
extends AbstractMeterIndicatorPanel {
    private MeterControls controls;
    private MeterMovement[] movement;
    private MeterScale scale;
    private int scaleRange = -1;
    private int nchannels;
    private static Font scaleFont = new Font("Arial", 0, 10);
    private static int[] times = new int[]{47, 53, 43, 59, 41, 37, 61, 67, 71, 73};
    private static int timeIndex = 0;

    public KMeterIndicatorPanel(MeterControls.MeterIndicator indicator) {
        super(indicator, times[timeIndex]);
        ++timeIndex;
        timeIndex %= times.length;
        this.setLayout(new BoxLayout(this, 0));
        this.controls = (MeterControls)indicator.getParent();
        ChannelFormat channelFormat = this.controls.getChannelFormat();
        this.nchannels = channelFormat.getCount();
        this.movement = new MeterMovement[this.nchannels];
        if (channelFormat == ChannelFormat.MONO) {
            this.movement[0] = new MeterMovement(indicator);
            this.add(this.movement[0]);
            this.scale = new MeterScale();
            this.add(this.scale);
        } else if (channelFormat == ChannelFormat.STEREO) {
            this.movement[0] = new MeterMovement(indicator);
            this.add(this.movement[0]);
            this.scale = new MeterScale();
            this.add(this.scale);
            this.movement[1] = new MeterMovement(indicator);
            this.add(this.movement[1]);
        } else if (channelFormat == ChannelFormat.QUAD) {
            this.movement[2] = new MeterMovement(indicator);
            this.add(this.movement[2]);
            this.movement[0] = new MeterMovement(indicator);
            this.add(this.movement[0]);
            this.scale = new MeterScale();
            this.add(this.scale);
            this.movement[1] = new MeterMovement(indicator);
            this.add(this.movement[1]);
            this.movement[3] = new MeterMovement(indicator);
            this.add(this.movement[3]);
        } else if (channelFormat == ChannelFormat.FIVE_1) {
            this.movement[2] = new MeterMovement(indicator);
            this.add(this.movement[2]);
            this.movement[0] = new MeterMovement(indicator);
            this.add(this.movement[0]);
            this.movement[4] = new MeterMovement(indicator);
            this.add(this.movement[4]);
            this.movement[1] = new MeterMovement(indicator);
            this.add(this.movement[1]);
            this.movement[3] = new MeterMovement(indicator);
            this.add(this.movement[3]);
            this.scale = new MeterScale();
            this.add(this.scale);
            this.movement[5] = new MeterMovement(indicator);
            this.add(this.movement[5]);
        }
    }

    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.height = 256;
        return size;
    }

    protected void pollAndUpdate() {
        if (!this.isShowing()) {
            return;
        }
        int c = 0;
        while (c < this.nchannels) {
            this.movement[c].updateState(this.controls.getState(c));
            ++c;
        }
        int newRange = (int)(this.controls.getMaxdB() - this.controls.getMindB());
        if (newRange != this.scaleRange) {
            this.scale.repaint();
            this.scaleRange = newRange;
        }
    }

    public float dBFS(float val) {
        return (float)(20.0 * Math.log10(val));
    }

    public float dBK(float val) {
        return this.dBFS(val) + this.controls.getMaxdB();
    }

    public int dBtoY(float dB) {
        float mindB = this.controls.getMindB();
        float maxdB = this.controls.getMaxdB();
        float dBRange = maxdB - mindB;
        int height = this.getHeight();
        if (height == 0) {
            return 0;
        }
        float c = maxdB / dBRange * (float)(height - 2);
        float m = (float)(2 - height) / dBRange;
        int y = (int)(m * dB + c);
        return y;
    }

    public class MeterScale
    extends JPanel {
        public MeterScale() {
            this.setOpaque(false);
        }

        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            pref.width = 20;
            return pref;
        }

        public Dimension getMaximumSize() {
            Dimension max = super.getMaximumSize();
            max.width = 20;
            return max;
        }

        public void paintComponent(Graphics g) {
            int textOffset = g.getFontMetrics().getAscent() / 2 - 2;
            float maxdB = KMeterIndicatorPanel.this.controls.getMaxdB();
            float mindB = KMeterIndicatorPanel.this.controls.getMindB();
            g.setColor(Color.darkGray);
            g.setFont(scaleFont);
            int i = -24;
            while ((float)i < maxdB) {
                if (i % 4 == 0 && (float)i > mindB) {
                    g.drawString(String.valueOf(i), 2, KMeterIndicatorPanel.this.dBtoY(i) + textOffset);
                }
                ++i;
            }
            i = -30;
            while ((float)i > mindB) {
                g.drawString(String.valueOf(i), 2, KMeterIndicatorPanel.this.dBtoY(i) + textOffset);
                i -= 10;
            }
        }
    }

    public class MeterMovement
    extends JPanel {
        private Marker maxPeakMarker = new Marker(Color.yellow);
        private Marker peakMarker = new Marker(Color.white);
        private Marker maxAverageMarker = new Marker(Color.yellow);
        private AverageBar averageBar = new AverageBar();

        public MeterMovement(MeterControls.MeterIndicator indicator) {
            this.setBackground(Color.darkGray);
        }

        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            pref.width = 10;
            return pref;
        }

        public Dimension getMaximumSize() {
            Dimension max = super.getMaximumSize();
            max.width = 10;
            return max;
        }

        public void updateState(MeterControls.ChannelState state) {
            this.averageBar.setdB(KMeterIndicatorPanel.this.dBK(state.average));
            this.maxAverageMarker.setdB(KMeterIndicatorPanel.this.dBK(state.maxAverage));
            this.peakMarker.setdB(KMeterIndicatorPanel.this.dBK(state.peak));
            this.maxPeakMarker.setdB(KMeterIndicatorPanel.this.dBK(state.maxPeak));
        }

        protected class Marker {
            protected Color color;
            protected int prevY = 2000;
            protected float prevdB = -150.0f;

            public Marker(Color c) {
                this.color = c;
            }

            public void setdB(float dB) {
                this.indicate(dB);
            }

            protected void indicate(float dB) {
                float mindB = KMeterIndicatorPanel.this.controls.getMindB();
                if (dB < mindB && this.prevdB < mindB) {
                    return;
                }
                this.prevdB = dB;
                Graphics g = MeterMovement.this.getGraphics();
                int w = MeterMovement.this.getWidth() - 2;
                int y = KMeterIndicatorPanel.this.dBtoY(dB);
                if (y != this.prevY) {
                    g.setColor(Color.darkGray);
                    g.drawLine(1, this.prevY, w, this.prevY);
                    this.prevY = y;
                }
                g.setColor(this.color);
                g.drawLine(1, y, w, y);
            }
        }

        protected class AverageBar
        extends Marker {
            public AverageBar() {
                super(Color.green);
            }

            protected void indicate(float dB) {
                float mindB = KMeterIndicatorPanel.this.controls.getMindB();
                if (dB < mindB && this.prevdB < mindB) {
                    return;
                }
                this.prevdB = dB;
                Graphics g = MeterMovement.this.getGraphics();
                int w = MeterMovement.this.getWidth() - 2;
                int h = MeterMovement.this.getHeight() - 1;
                int y = KMeterIndicatorPanel.this.dBtoY(dB);
                if (y > this.prevY) {
                    g.setColor(Color.DARK_GRAY);
                    g.fillRect(1, this.prevY, w, y - this.prevY);
                    this.prevY = y;
                } else {
                    this.prevY = y;
                    int y0 = KMeterIndicatorPanel.this.dBtoY(0.0f);
                    int y4 = KMeterIndicatorPanel.this.dBtoY(4.0f);
                    g.setColor(Color.green);
                    if (dB < 0.0f) {
                        g.fillRect(1, y, w, h - y);
                    } else if (dB < 4.0f) {
                        g.fillRect(1, y0, w, h - y0);
                        g.setColor(Color.yellow);
                        g.fillRect(1, y, w, y0 - y);
                    } else {
                        g.fillRect(1, y0, w, h - y0);
                        g.setColor(Color.yellow);
                        g.fillRect(1, y4, w, y0 - y4);
                        g.setColor(Color.red);
                        g.fillRect(1, y, w, y4 - y);
                    }
                    g.setColor(Color.darkGray);
                    int i = 20;
                    while (i >= -24) {
                        y = KMeterIndicatorPanel.this.dBtoY(i);
                        g.drawLine(1, y, w, y);
                        --i;
                    }
                    i = -30;
                    while (i >= -120) {
                        y = KMeterIndicatorPanel.this.dBtoY(i);
                        g.drawLine(1, y, w, y);
                        i -= 10;
                    }
                }
            }
        }
    }
}

