/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.controlui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;
import uk.org.toot.control.BooleanControl;
import uk.org.toot.control.CompoundControl;
import uk.org.toot.control.CompoundControlChain;
import uk.org.toot.control.CompoundControlPersistence;
import uk.org.toot.control.Control;
import uk.org.toot.control.ControlSelector;
import uk.org.toot.control.EnumControl;
import uk.org.toot.control.FloatControl;
import uk.org.toot.localisation.Localisation;
import uk.org.toot.service.ServiceDescriptor;
import uk.org.toot.swingui.audioui.meterui.GainReductionIndicatorPanel;
import uk.org.toot.swingui.controlui.BooleanControlPanel;
import uk.org.toot.swingui.controlui.BooleanIndicatorPanel;
import uk.org.toot.swingui.controlui.CompoundControlPanel;
import uk.org.toot.swingui.controlui.ControlPanel;
import uk.org.toot.swingui.controlui.EnumControlPanel;
import uk.org.toot.swingui.controlui.FloatControlPanel;
import uk.org.toot.swingui.controlui.PanelFactory;

public class ControlPanelFactory
extends Observable
implements PanelFactory {
    private Set<String> minimisedControlNames = new HashSet<String>();
    private JPopupMenu popupMenu = null;

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    public JComponent layout(CompoundControl control, int axis, boolean hasBorder, JComponent parent, boolean hasHeader) {
        parent.setLayout(new BoxLayout(parent, 1));
        if (hasBorder && !control.isNeverBordered()) {
            parent.setBorder(new TitledBorder(""));
        }
        if (hasHeader) {
            JComponent header = this.createHeader(control, axis);
            header.setAlignmentX(0.5f);
            if (header instanceof JButton) {
                header.setComponentPopupMenu(this.getPopupMenu());
            }
            parent.add(header);
        }
        if (this.addGlue()) {
            parent.add(Box.createVerticalGlue());
        }
        if (this.isMinimised(control.getName())) {
            return null;
        }
        this.createTop(parent, control, 1);
        JPanel target = new JPanel();
        target.setLayout(new BoxLayout(target, axis));
        parent.add(target);
        return target;
    }

    protected void createTop(JComponent parent, CompoundControl control, int axis) {
    }

    public JComponent createComponent(Control control, int axis, boolean hasHeader) {
        if (control instanceof CompoundControl) {
            CompoundControl cc = (CompoundControl)control;
            int a = axis;
            if (cc.isAlwaysVertical()) {
                a = 1;
            } else if (cc.isAlwaysHorizontal()) {
                a = 0;
            }
            return this.createCompoundComponent(cc, a, null, this, true, hasHeader);
        }
        if (control instanceof FloatControl) {
            ControlPanel floatPanel;
            if (control.isIndicator()) {
                floatPanel = new GainReductionIndicatorPanel((FloatControl)control);
            } else {
                floatPanel = new FloatControlPanel((FloatControl)control, axis);
                floatPanel.setAlignmentY(0.25f);
            }
            return floatPanel;
        }
        if (control instanceof BooleanControl) {
            if (control.isIndicator()) {
                return new BooleanIndicatorPanel((BooleanControl)control);
            }
            return new BooleanControlPanel((BooleanControl)control);
        }
        if (control instanceof EnumControl) {
            if (control.isIndicator()) {
                JLabel label = new JLabel(((EnumControl)control).getValue().toString());
                label.setBorder(BorderFactory.createEmptyBorder(3, 1, 2, 2));
                label.setAlignmentX(0.5f);
                return label;
            }
            return new EnumControlPanel((EnumControl)control);
        }
        return null;
    }

    protected JComponent createCompoundComponent(CompoundControl c, int axis, ControlSelector s, PanelFactory f, boolean hasBorder, boolean hasHeader) {
        return new CompoundControlPanel(c, axis, s, f, hasBorder, hasHeader);
    }

    protected boolean addGlue() {
        return false;
    }

    protected boolean canEdit() {
        return false;
    }

    protected boolean isMinimised(String name) {
        return this.minimisedControlNames.contains(name);
    }

    protected boolean toggleMinimised(String name) {
        if (this.isMinimised(name)) {
            this.minimisedControlNames.remove(name);
        } else {
            this.minimisedControlNames.add(name);
        }
        this.setChanged();
        this.notifyObservers(name);
        return this.isMinimised(name);
    }

    protected String shorten(String name) {
        String[] subs = name.split("\\s");
        int n = subs.length;
        if (n > 1) {
            if (n == 2) {
                return String.valueOf(this.shorten(subs[0])) + " " + this.shorten(subs[1]);
            }
            if (n == 3) {
                return String.valueOf(this.shorten(subs[0])) + " " + this.shorten(subs[2]);
            }
        }
        if (name.length() > 6) {
            int trunc = 4;
            char last = name.charAt(trunc - 1);
            if ("aeiou".indexOf(last) >= 0) {
                --trunc;
            }
            return name.substring(0, trunc);
        }
        return name;
    }

    protected JComponent createHeader(CompoundControl control, int axis) {
        boolean isShort = false;
        String title = control.getName();
        if (this.isMinimised(title) || axis == 1) {
            title = this.shorten(title);
            isShort = true;
        }
        if (this.canEdit() && control.getParent() instanceof CompoundControlChain) {
            JButton button = new JButton(title){

                public Dimension getMaximumSize() {
                    Dimension d = super.getPreferredSize();
                    d.width = 48;
                    return d;
                }
            };
            if (isShort) {
                button.setToolTipText(control.getName());
            }
            button.setBorder(BorderFactory.createRaisedBevelBorder());
            return button;
        }
        JLabel label = new JLabel(title);
        if (isShort) {
            label.setToolTipText(control.getName());
        }
        return label;
    }

    protected JPopupMenu createPopupMenu() {
        return new CompoundPopupMenu();
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.createPopupMenu();
        }
        return this.popupMenu;
    }

    protected class CompoundPopupMenu
    extends JPopupMenu {
        public void show(Component invoker, int x, int y) {
            CompoundControlPanel compoundPanel = (CompoundControlPanel)invoker.getParent();
            CompoundControl control = compoundPanel.getControl();
            CompoundControl parentControl = control.getParent();
            String name = control.getName();
            this.removeAll();
            if (parentControl instanceof CompoundControlChain) {
                CompoundControlChain chain = (CompoundControlChain)parentControl;
                if (control.canBeInsertedBefore()) {
                    this.add(new InsertMenu(control, chain));
                }
                if (control.canBeMoved()) {
                    this.add(new MoveMenu(control, chain));
                }
                if (control.canBeDeleted()) {
                    this.add(new DeleteAction(control.getName(), chain));
                }
                if (CompoundControl.getPersistence() != null && control.hasPresets()) {
                    this.addSeparator();
                    this.add(new LoadMenu(control));
                    this.add(new SaveAction(control));
                }
            } else {
                System.out.println(parentControl);
            }
            if (!control.isAlwaysVertical()) {
                String minOrMax = ControlPanelFactory.this.isMinimised(name) ? Localisation.getString("Maximise") : Localisation.getString("Minimise");
                this.addSeparator();
                this.add(new MinMaxAction(minOrMax, name));
            }
            super.show(invoker, x, y);
        }
    }

    protected static class MoveMenu
    extends JMenu {
        private CompoundControlChain parentChain;

        public MoveMenu(CompoundControl control, CompoundControlChain parentControl) {
            super(Localisation.getString("Move.before"));
            this.parentChain = parentControl;
            Control prev_c = null;
            int added = 0;
            for (Control c : this.parentChain.getControls()) {
                if (c != control && prev_c != control && c.getName().length() > 0 && ((CompoundControl)c).canBeMovedBefore()) {
                    this.add(new MoveAction(control.getName(), c.getName()));
                    ++added;
                }
                prev_c = c;
            }
            if (added == 0) {
                this.setEnabled(false);
            }
        }

        protected class MoveAction
        extends AbstractAction {
            private String moveName;
            private String moveBeforeName;

            public MoveAction(String moveName, String moveBeforeName) {
                super(moveBeforeName);
                this.moveName = moveName;
                this.moveBeforeName = moveBeforeName;
            }

            public void actionPerformed(ActionEvent e) {
                MoveMenu.this.parentChain.move(this.moveName, this.moveBeforeName);
            }
        }
    }

    protected static class InsertMenu
    extends JMenu {
        private CompoundControlChain parentChain;

        public InsertMenu(CompoundControl control, CompoundControlChain parentControl) {
            super(Localisation.getString("Insert"));
            this.parentChain = parentControl;
            List<ServiceDescriptor> inserts = this.parentChain.descriptors();
            HashMap<String, JMenu> menus = new HashMap<String, JMenu>();
            for (ServiceDescriptor d : inserts) {
                String category = d.getDescription();
                JMenu menu = (JMenu)menus.get(category);
                if (menu == null) {
                    menu = new JMenu(category);
                    this.add(menu);
                    menus.put(category, menu);
                }
                menu.add(new InsertAction(d.getName(), control.getName()));
            }
        }

        protected class InsertAction
        extends AbstractAction {
            private String insertName;
            private String insertBeforeName;

            public InsertAction(String insertName, String insertBeforeName) {
                super(insertName);
                this.insertName = insertName;
                this.insertBeforeName = insertBeforeName;
            }

            public void actionPerformed(ActionEvent e) {
                InsertMenu.this.parentChain.insert(this.insertName, this.insertBeforeName);
            }
        }
    }

    protected static class DeleteAction
    extends AbstractAction {
        private String deleteName;
        private CompoundControlChain parentChain;

        public DeleteAction(String deleteName, CompoundControlChain chain) {
            super(Localisation.getString("Delete"));
            this.deleteName = deleteName;
            this.parentChain = chain;
        }

        public void actionPerformed(ActionEvent e) {
            this.parentChain.delete(this.deleteName);
        }
    }

    protected static class LoadMenu
    extends JMenu {
        private CompoundControl control;

        public LoadMenu(CompoundControl control) {
            super(Localisation.getString("Load.Preset"));
            this.control = control;
            CompoundControlPersistence persistence = CompoundControl.getPersistence();
            List<String> presets = persistence.getPresets(control);
            for (String preset : presets) {
                this.add(new LoadAction(preset));
            }
            if (presets.size() == 0) {
                this.setEnabled(false);
            }
        }

        protected class LoadAction
        extends AbstractAction {
            public LoadAction(String preset) {
                super(preset);
            }

            public void actionPerformed(ActionEvent e) {
                CompoundControl.getPersistence().loadPreset(LoadMenu.this.control, e.getActionCommand());
            }
        }
    }

    protected static class SaveAction
    extends AbstractAction {
        private CompoundControl control;

        public SaveAction(CompoundControl control) {
            super(Localisation.getString("Save.Preset.As..."));
            this.control = control;
        }

        public void actionPerformed(ActionEvent e) {
            String name = JOptionPane.showInputDialog(Localisation.getString("Save.Preset.As..."));
            if (name != null) {
                CompoundControl.getPersistence().savePreset(this.control, name);
            }
        }
    }

    protected class MinMaxAction
    extends AbstractAction {
        private String name;

        public MinMaxAction(String action, String name) {
            super(action);
            this.name = name;
        }

        public void actionPerformed(ActionEvent e) {
            ControlPanelFactory.this.toggleMinimised(this.name);
        }
    }
}

