/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.controlui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import uk.org.toot.control.EnumControl;
import uk.org.toot.swingui.controlui.ControlPanel;

public class EnumControlPanel
extends ControlPanel {
    private final EnumControl control;
    private JButton button;
    private JPopupMenu popupMenu;
    private ActionListener popupListener;
    private ActionListener buttonListener;

    public EnumControlPanel(final EnumControl control) {
        super(control);
        this.setLayout(new BoxLayout(this, 1));
        this.control = control;
        String name = this.abbreviate(control.getValue().toString());
        this.button = new JButton(name){

            public Dimension getMaximumSize() {
                Dimension size = super.getPreferredSize();
                size.width = control.isWidthLimited() ? 40 : 128;
                return size;
            }
        };
        this.popupListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                control.setValue(ae.getActionCommand());
            }
        };
        this.popupMenu = this.createPopupMenu();
        this.buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EnumControlPanel.this.popupMenu.show(EnumControlPanel.this.button, 0, 0);
            }
        };
        this.button.setBorder(BorderFactory.createRaisedBevelBorder());
        this.button.setAlignmentX(0.5f);
        this.add(this.button);
    }

    public void addNotify() {
        super.addNotify();
        this.button.addActionListener(this.buttonListener);
    }

    public void removeNotify() {
        this.button.removeActionListener(this.buttonListener);
        super.removeNotify();
    }

    public void update(Observable obs, Object obj) {
        String text = this.abbreviate(this.control.getValue().toString());
        this.button.setText(text);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        for (Object o : this.control.getValues()) {
            JMenuItem item = new JMenuItem(o.toString());
            item.addActionListener(this.popupListener);
            menu.add(item);
        }
        return menu;
    }
}

