/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.controlui;

import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import uk.org.toot.control.FloatControl;
import uk.org.toot.swingui.controlui.ControlKnob;
import uk.org.toot.swingui.controlui.ControlPanel;
import uk.org.toot.swingui.controlui.ControlSlider;
import uk.org.toot.swingui.controlui.LawControlPresetMenu;

public class FloatControlPanel
extends ControlPanel {
    private final FloatControl control;
    private JComponent pot;
    private static Font font = new Font("Arial", 0, 10);

    public FloatControlPanel(FloatControl control, int axis) {
        super(control);
        boolean rotary;
        this.setLayout(new BoxLayout(this, 1));
        this.control = control;
        boolean bl = rotary = control.isRotary() || axis == 0;
        if (rotary) {
            this.pot = new ControlKnob(control);
            this.addMenu();
        } else {
            this.pot = new ControlSlider(control);
        }
        String name = this.abbreviate(control.getAnnotation());
        JLabel label = new JLabel(name);
        label.setLabelFor(this.pot);
        label.setFont(font);
        label.setAlignmentX(0.5f);
        this.add(label);
        this.pot.setAlignmentX(0.5f);
        this.add(this.pot);
    }

    protected void addMenu() {
        if (this.control.getPresetNames() == null) {
            return;
        }
        this.pot.setComponentPopupMenu(LawControlPresetMenu.getInstance());
    }
}

