/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.midixui.controlui.neckui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import uk.org.toot.midix.control.neck.ChordFamily;
import uk.org.toot.midix.control.neck.ChordShape;
import uk.org.toot.midix.control.neck.Player;
import uk.org.toot.midix.control.neck.StringTuning;
import uk.org.toot.midix.control.neck.StrungNeck;
import uk.org.toot.music.tonality.Chord;
import uk.org.toot.music.tonality.ChordMode;
import uk.org.toot.music.tonality.Chords;
import uk.org.toot.music.tonality.Key;
import uk.org.toot.music.tonality.Pitch;
import uk.org.toot.music.tonality.Scale;
import uk.org.toot.swingui.midixui.controlui.neckui.NeckView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeckController
extends NeckView
implements MouseWheelListener,
Observer {
    private int rootFret = -1;
    private int mouseString = -1;
    private JLabel chordLabel;
    private PlayingStyle style;
    private List<PlayingStyle> styles = new ArrayList<PlayingStyle>();
    private Player player;

    public NeckController(StrungNeck aNeck, Player aPlayer) {
        super(aNeck);
        this.player = aPlayer;
        this.add(new ChordStyle());
        this.add(new ModeStyle());
        this.style = this.styles.get(0);
        this.addMouseWheelListener(this);
        this.addMouseListener(new NeckMouseInputListener());
        this.addMouseMotionListener(new NeckMouseMotionListener());
        this.addKeyListener(new NeckKeyListener());
        this.setFocusable(true);
        this.chordLabel = new JLabel();
        this.chordLabel.setFont(this.chordLabel.getFont().deriveFont(16.0f));
        this.getKey().addObserver(this);
        this.updateDiatonics();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.getKey().equals(o)) {
            this.updateDiatonics();
        }
    }

    public void setTuning(StringTuning tuning) {
        this.getNeck().setTuning(tuning);
        this.updateDiatonics();
    }

    public void updateDiatonics() {
        for (StrungNeck.TunedString string : this.getNeck().getStrings()) {
            int mask = 0;
            int open = string.getOpenTuning();
            int f = 0;
            while (f <= this.getFrets()) {
                if (this.getKey().contains(open + f)) {
                    mask |= 1 << f;
                }
                ++f;
            }
            string.diatonics(mask);
        }
        this.refinger();
        this.repaint();
    }

    protected boolean refinger() {
        int fret = this.rootFret;
        int string = this.mouseString;
        this.rootFret = -1;
        return this.refinger(fret, string);
    }

    protected boolean refinger(MouseEvent e) {
        return this.refinger(this.fret(e.getX()), this.string(e.getY()));
    }

    protected boolean refinger(int fret, int string) {
        if (fret == this.rootFret && string == this.mouseString) {
            return false;
        }
        boolean ret = this.style.reRoot(fret, string);
        if (ret) {
            this.rootFret = fret;
            this.mouseString = string;
            this.repaint();
        }
        return ret;
    }

    public void useStyle(String name) {
        for (PlayingStyle s : this.getStyles()) {
            if (!s.getName().equals(name)) continue;
            this.style = s;
            this.refinger();
            this.repaint();
            return;
        }
    }

    protected void add(PlayingStyle s) {
        this.styles.add(s);
    }

    protected List<PlayingStyle> getStyles() {
        return this.styles;
    }

    protected PlayingStyle getStyle() {
        return this.style;
    }

    public Key getKey() {
        return this.player.getKey();
    }

    public int getVelocity() {
        return this.player.getVelocity();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.style.mouseWheelMoved(e);
    }

    public JLabel getChordLabel() {
        return this.chordLabel;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.style.paintFingering(g);
    }

    protected void paintFingerPosition(Graphics g, int fret, int string, int label) {
        g.fillOval(this.xfret(fret) - 24, this.ystring(string) - 12, 24, 24);
        g.setColor(Color.black);
        if (fret > 0 && label >= 0) {
            g.drawString(String.valueOf(label), this.xfret(fret) - 16, this.ystring(string) + 4);
        }
    }

    protected void paintMute(Graphics g, int fret, int string) {
        g.setColor(Color.red);
        int x = this.xfret(fret);
        int y = this.ystring(string);
        int SZ = 10;
        g.drawLine(x - SZ, y - SZ, x + SZ, y + SZ);
        g.drawLine(x - SZ, y + SZ, x + SZ, y - SZ);
    }

    @Override
    protected void paintFrets(Graphics g) {
        int s = 0;
        while (s < this.getStringCount()) {
            StrungNeck.TunedString string = this.getString(s);
            int f = 1;
            while (f <= this.getFrets()) {
                if (!string.diatonic(f)) {
                    g.setColor(s == this.style.getRootString() ? Color.darkGray.brighter().brighter() : Color.lightGray);
                    g.fillRect(this.xfret(f - 1) + 1, this.ystring(s) - this.getPixelsPerString() / 2, this.xfret(f) - this.xfret(f - 1) - 1, this.getPixelsPerString());
                }
                ++f;
            }
            ++s;
        }
        super.paintFrets(g);
    }

    public class PlayingStyle {
        private String name;
        protected boolean releasing = false;

        public PlayingStyle(String aName) {
            this.name = aName;
        }

        public String getName() {
            return this.name;
        }

        public boolean reRoot(int fret, int string) {
            return false;
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
        }

        public void paintFingering(Graphics g) {
        }

        public int getRootString() {
            return -1;
        }
    }

    private class ChordStyle
    extends PlayingStyle {
        private ChordFamily chordFamily;
        private ChordShape currentShape;
        private int prevStr;
        private long prevWhen;
        private boolean useSus4;
        private boolean use6;
        private boolean add9;

        public ChordStyle() {
            super("Chords");
            this.prevStr = -1;
            this.prevWhen = 0L;
            this.useSus4 = false;
            this.use6 = false;
            this.add9 = false;
            this.setChordFamily(ChordFamily.named("E"));
            this.currentShape = this.chordFamily.get("maj");
        }

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code >= 49 && code < 49 + NeckController.this.getStringCount()) {
                NeckController.this.pickString(code - 49, false, NeckController.this.getVelocity());
                return;
            }
            switch (code) {
                case 81: {
                    NeckController.this.setBending(0, true);
                    break;
                }
                case 87: {
                    NeckController.this.setBending(1, true);
                    break;
                }
                case 69: {
                    NeckController.this.setBending(2, true);
                    break;
                }
                case 82: {
                    NeckController.this.setBending(3, true);
                    break;
                }
                case 84: {
                    NeckController.this.setBending(4, true);
                    break;
                }
                case 89: {
                    NeckController.this.setBending(5, true);
                    break;
                }
                case 85: {
                    NeckController.this.setBending(6, true);
                    break;
                }
                case 73: {
                    NeckController.this.setBending(7, true);
                    break;
                }
                case 79: {
                    NeckController.this.setBending(8, true);
                    break;
                }
                case 80: {
                    NeckController.this.setBending(9, true);
                    break;
                }
                case 17: {
                    this.useSus4 = true;
                    this.reRoot(NeckController.this.rootFret, this.getRootString());
                    break;
                }
                case 524: {
                    this.add9 = true;
                    this.reRoot(NeckController.this.rootFret, this.getRootString());
                    break;
                }
                case 18: {
                    this.use6 = true;
                    this.reRoot(NeckController.this.rootFret, this.getRootString());
                    break;
                }
                case 120: {
                    this.setChordFamily(ChordFamily.named("C"));
                    break;
                }
                case 121: {
                    this.setChordFamily(ChordFamily.named("A"));
                    break;
                }
                case 122: {
                    this.setChordFamily(ChordFamily.named("G"));
                    break;
                }
                case 123: {
                    this.setChordFamily(ChordFamily.named("E"));
                    break;
                }
                default: {
                    System.out.println("NeckController: Pressed " + e.paramString());
                    return;
                }
            }
            e.consume();
        }

        public void keyReleased(KeyEvent e) {
            int code = e.getKeyCode();
            if (code >= 49 && code < 49 + NeckController.this.getStringCount() && this.releasing) {
                NeckController.this.muteString(code - 49);
                return;
            }
            switch (code) {
                case 81: {
                    NeckController.this.setBending(0, false);
                    break;
                }
                case 87: {
                    NeckController.this.setBending(1, false);
                    break;
                }
                case 69: {
                    NeckController.this.setBending(2, false);
                    break;
                }
                case 82: {
                    NeckController.this.setBending(3, false);
                    break;
                }
                case 84: {
                    NeckController.this.setBending(4, false);
                    break;
                }
                case 89: {
                    NeckController.this.setBending(5, false);
                    break;
                }
                case 85: {
                    NeckController.this.setBending(6, false);
                    break;
                }
                case 73: {
                    NeckController.this.setBending(7, false);
                    break;
                }
                case 79: {
                    NeckController.this.setBending(8, false);
                    break;
                }
                case 80: {
                    NeckController.this.setBending(9, false);
                    break;
                }
                case 17: {
                    this.useSus4 = false;
                    this.reRoot(NeckController.this.rootFret, this.getRootString());
                    break;
                }
                case 524: {
                    this.add9 = false;
                    this.reRoot(NeckController.this.rootFret, this.getRootString());
                    break;
                }
                case 18: {
                    this.use6 = false;
                    this.reRoot(NeckController.this.rootFret, this.getRootString());
                    break;
                }
                default: {
                    return;
                }
            }
            e.consume();
        }

        public int getFirstShapeString() {
            return NeckController.this.getNeck().getTuning().isLow() ? 1 : 0;
        }

        public int getRootString() {
            return this.chordFamily.getRootString() + this.getFirstShapeString();
        }

        protected void setChordFamily(ChordFamily family) {
            this.chordFamily = family;
            this.reRoot(NeckController.this.rootFret, this.getRootString());
            NeckController.this.repaint();
        }

        private int decodePoly(int string) {
            return string < 2 ? 3 : string + 1;
        }

        private int[] addInterval(int[] in, int addInt) {
            int[] out = new int[in.length + 1];
            int i = 0;
            int j = 0;
            while (i < in.length) {
                if (i == j && in[i] > addInt) {
                    out[j++] = addInt;
                }
                out[j++] = in[i++];
            }
            if (i == j) {
                out[out.length - 1] = addInt;
            }
            return out;
        }

        private int[] modifyIntervals(int[] in, int degree) {
            Scale scale = NeckController.this.getKey().getScale();
            if (this.useSus4 && scale.hasInterval(degree, 5) && scale.hasInterval(degree, 7)) {
                int i = 0;
                while (i < in.length) {
                    if (in[i] == 4 || in[i] == 3) {
                        in[i] = 5;
                    }
                    ++i;
                }
            }
            int[] ret = in;
            if (this.use6 && scale.hasInterval(degree, 9) && scale.hasInterval(degree, 7)) {
                ret = this.addInterval(ret, 9);
            }
            if (this.add9 && scale.hasInterval(degree, 2) && scale.hasInterval(degree, 7)) {
                ret = this.addInterval(ret, 2);
            }
            return ret;
        }

        public boolean reRoot(int fret, int string) {
            int root = NeckController.this.getString(this.getRootString()).getOpenTuning() + fret;
            if (!NeckController.this.getKey().contains(root)) {
                return false;
            }
            int index = NeckController.this.getKey().index(root);
            int poly = this.decodePoly(string);
            int[] chordMode = NeckController.this.getKey().getScale().getChordMode(index);
            ChordShape shape = null;
            int[] intervals = ChordMode.getIntervals(chordMode, poly, 3);
            Chord chord = Chords.withIntervals(intervals = this.modifyIntervals(intervals, index));
            if (chord != null && (shape = this.chordFamily.get(chord.getSymbol())) != null && !shape.isValidAt(fret) && (shape = this.chordFamily.other().get(chord.getSymbol())) != null && !shape.isValidAt(fret)) {
                shape = null;
            }
            if (shape == null || chord == null) {
                return false;
            }
            NeckController.this.rootFret = fret;
            NeckController.this.shape(NeckController.this.rootFret, shape, this.getFirstShapeString());
            this.setChordShape(shape);
            NeckController.this.getChordLabel().setText(String.valueOf(Pitch.className(root)) + " " + chord.getSymbol());
            NeckController.this.getChordLabel().setForeground(shape == null ? Color.red : Color.blue);
            return true;
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            int notches = e.getWheelRotation();
            long when = e.getWhen();
            long delta = when - this.prevWhen;
            boolean up = notches > 0;
            this.prevWhen = when;
            if (delta > 250L) {
                NeckController.this.repaint();
                this.prevStr = up ? NeckController.this.getStringCount() : this.getFirstShapeString() - 1;
            }
            NeckController.this.refinger(e);
            boolean picked = false;
            while (!picked) {
                int str = this.prevStr - notches;
                picked = str >= this.getFirstShapeString() && str < NeckController.this.getStringCount() ? NeckController.this.pickString(str, up, NeckController.this.getVelocity()) : true;
                this.prevStr = str;
            }
        }

        protected ChordShape getChordShape() {
            return this.currentShape;
        }

        protected void setChordShape(ChordShape chordShape) {
            this.currentShape = chordShape;
        }

        public void paintFingering(Graphics g) {
            if (this.getChordShape() == null) {
                return;
            }
            int last = NeckController.this.getStringCount() - this.getFirstShapeString();
            int i = 0;
            while (i < last) {
                ChordShape.Fretting f = this.getChordShape().getFretting(i);
                int fret = f.finger == -1 ? f.fret : NeckController.this.rootFret + f.fret;
                g.setColor(Color.white);
                if (fret >= 0) {
                    NeckController.this.paintFingerPosition(g, fret, i + this.getFirstShapeString(), f.finger);
                } else if (fret < 0) {
                    g.setColor(Color.red);
                    NeckController.this.paintMute(g, 0, i + this.getFirstShapeString());
                }
                ++i;
            }
        }
    }

    private class ModeStyle
    extends PlayingStyle {
        private int[] fingerFret;
        private int lastPressCode;

        public ModeStyle() {
            super("Modes");
            this.fingerFret = new int[10];
        }

        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code >= 49 && code <= 57) {
                this.lastPressCode = code;
                int finger = code - 49;
                NeckController.this.mute();
                NeckController.this.getString(NeckController.this.mouseString).hold(this.fingerFret[finger]);
                NeckController.this.pickString(NeckController.this.mouseString, false, NeckController.this.getVelocity());
                return;
            }
        }

        public void keyReleased(KeyEvent e) {
            int code = e.getKeyCode();
            if (code >= 49 && code <= 57) {
                if (code == this.lastPressCode && this.releasing) {
                    NeckController.this.muteString(NeckController.this.mouseString);
                }
                return;
            }
        }

        public boolean reRoot(int fret, int str) {
            StrungNeck.TunedString string = NeckController.this.getString(str);
            if (!string.diatonic(fret)) {
                return false;
            }
            int finger = 0;
            this.fingerFret[finger++] = fret;
            while (++fret <= NeckController.this.getFrets() && finger < 9) {
                if (!string.diatonic(fret)) continue;
                this.fingerFret[finger++] = fret;
            }
            NeckController.this.repaint();
            return true;
        }

        public void paintFingering(Graphics g) {
            int i = 0;
            while (i < 4) {
                g.setColor(Color.white);
                if (this.fingerFret[i] > NeckController.this.getFrets()) break;
                NeckController.this.paintFingerPosition(g, this.fingerFret[i], NeckController.this.mouseString, i + 1);
                ++i;
            }
            NeckController.this.getChordLabel().setText(" ");
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
        }
    }

    private class NeckMouseInputListener
    extends MouseInputAdapter
    implements MouseInputListener {
        private boolean in = false;

        private NeckMouseInputListener() {
        }

        public void mouseExited(MouseEvent e) {
            if (this.in) {
                this.in = false;
                NeckController.this.mute();
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (!this.in) {
                NeckController.this.requestFocusInWindow();
                this.in = true;
            }
        }

        public void mousePressed(MouseEvent e) {
            switch (e.getButton()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            switch (e.getButton()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    private class NeckMouseMotionListener
    extends MouseMotionAdapter
    implements MouseMotionListener {
        private boolean wasBending = false;
        private int bendx;

        private NeckMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent e) {
            this.moved(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.moved(e);
        }

        private void moved(MouseEvent e) {
            if (!NeckController.this.getNeck().isBending()) {
                NeckController.this.refinger(e);
                if (this.wasBending) {
                    NeckController.this.getNeck().bend(0);
                    this.wasBending = false;
                }
            } else if (!this.wasBending) {
                this.bendx = e.getX();
                this.wasBending = true;
            } else {
                NeckController.this.getNeck().bend(e.getX() - this.bendx);
            }
        }
    }

    private class NeckKeyListener
    extends KeyAdapter
    implements KeyListener {
        private int lastKey = -1;

        private NeckKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == this.lastKey) {
                return;
            }
            switch (e.getKeyCode()) {
                case 112: {
                    NeckController.this.useStyle("Modes");
                    break;
                }
                case 113: {
                    NeckController.this.useStyle("Chords");
                    break;
                }
                case 16: {
                    break;
                }
                default: {
                    NeckController.this.style.keyPressed(e);
                }
            }
            this.lastKey = e.getKeyCode();
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == this.lastKey) {
                this.lastKey = -1;
            }
            switch (e.getKeyCode()) {
                case 112: {
                    break;
                }
                case 113: {
                    break;
                }
                case 16: {
                    break;
                }
                default: {
                    NeckController.this.style.keyReleased(e);
                }
            }
        }
    }
}

