/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.miscui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SwingApplication {
    private final String basename;
    private final String fullname;
    private static Camera camera = new Camera();
    private static final String SHOOT_KEYS = "control alt S";
    private static final String SHOOT = "shoot";

    public SwingApplication(String aBasename, String aFullname) {
        this.basename = aBasename;
        this.fullname = aFullname;
        this.setLookAndFeel();
        UIManager.put("TabbedPane.selectedForeground", new Color(15, 50, 125));
    }

    public void setLookAndFeel() {
        SwingApplication.setNativeLookAndFeel();
    }

    public void setContent(final Container content) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingApplication.this.createAndShowGUI(content, String.valueOf(SwingApplication.this.basename) + " - " + SwingApplication.this.fullname);
            }
        });
    }

    private void createAndShowGUI(Container content, String title) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = SwingApplication.createFrame(content, title);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                SwingApplication.this.close();
            }
        });
    }

    public static JFrame createFrame(Container content, String title) {
        return SwingApplication.createFrame(content, title, SwingApplication.createFrameImage());
    }

    public static JFrame createFrame(final Container content, String title, Image image) {
        final JFrame frame = new JFrame(title);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                SwingApplication.unbindKeys(content);
                frame.setIconImage(null);
                frame.removeWindowListener(this);
                frame.getContentPane().removeAll();
            }
        });
        frame.getContentPane().add(content);
        frame.setDefaultCloseOperation(2);
        frame.setIconImage(image);
        frame.pack();
        frame.setVisible(true);
        SwingApplication.bindKeys(content);
        return frame;
    }

    protected static void bindKeys(Component comp) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            jcomp.getInputMap(2).put(KeyStroke.getKeyStroke(SHOOT_KEYS), SHOOT);
            jcomp.getActionMap().put(SHOOT, new ShootAction(jcomp));
        }
    }

    protected static void unbindKeys(Component comp) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            jcomp.getInputMap(2).remove(KeyStroke.getKeyStroke(SHOOT_KEYS));
            jcomp.getActionMap().remove(SHOOT);
        }
    }

    protected static Image createFrameImage() {
        SquareImage img = new SquareImage(16);
        Graphics g = img.getGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, 15, 15);
        g.setColor(Color.RED);
        g.fillOval(5, 3, 6, 6);
        g.dispose();
        return img;
    }

    public Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    protected void close() {
        System.exit(0);
    }

    public static void setNativeLookAndFeel() {
        try {
            String syslaf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(syslaf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setJavaLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setMotifLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ShootAction
    extends AbstractAction {
        private Component subject;

        public ShootAction(JComponent sub) {
            this.subject = sub.getTopLevelAncestor();
            if (this.subject == null) {
                this.subject = sub;
            }
        }

        public void actionPerformed(ActionEvent e) {
            camera.shootComponent(this.subject);
        }
    }

    public static class SquareImage
    extends BufferedImage {
        public SquareImage() {
            this(24);
        }

        public SquareImage(int size) {
            super(size, size, 1);
        }
    }

    public static class Camera {
        private int shot = 0;
        private File path = new File(new File(System.getProperty("user.home"), "toot"), "screenshots");

        public void shoot(Rectangle screenRect) {
            try {
                Robot robot = new Robot();
                BufferedImage image = robot.createScreenCapture(screenRect);
                String outFileName = "shot" + ++this.shot + ".png";
                File file = new File(this.path, outFileName);
                file.mkdirs();
                ImageIO.write((RenderedImage)image, "png", file);
                System.out.println(file.getPath());
            }
            catch (AWTException aWTException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void shootScreen() {
            this.shoot(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        }

        public void shootComponent(Component component) {
            Point loc = component.getLocationOnScreen();
            Dimension size = component.getSize();
            this.shoot(new Rectangle(loc.x, loc.y, size.width, size.height));
        }
    }
}

