/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.tonalityui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.org.toot.music.tonality.Chord;
import uk.org.toot.music.tonality.Chords;
import uk.org.toot.music.tonality.Interval;
import uk.org.toot.music.tonality.Scale;
import uk.org.toot.swingui.tonalityui.ChordList;

public class ModeChordsPanel
extends JPanel {
    private Scale scale;
    private int degrees = 0;

    public ModeChordsPanel() {
        this.setLayout(new BoxLayout(this, 0));
    }

    public void setScale(Scale scale) {
        int i;
        int d = scale.length();
        if (d > this.degrees) {
            i = this.degrees;
            while (i < d) {
                this.add(new DegreeChordsView(i));
                ++i;
            }
        } else if (d < this.degrees) {
            i = this.degrees - 1;
            while (i >= d) {
                this.remove(i);
                --i;
            }
        }
        this.degrees = d;
        this.scale = scale;
        i = 0;
        while (i < this.getComponentCount()) {
            Component comp = this.getComponent(i);
            if (comp instanceof DegreeChordsView) {
                ((DegreeChordsView)comp).updateChords();
            }
            ++i;
        }
    }

    class DegreeChordsView
    extends JPanel {
        private ChordList chordList;
        private int degree;
        private JLabel label;

        public DegreeChordsView(int degree) {
            this.setLayout(new BorderLayout());
            this.label = new JLabel(String.valueOf(degree + 1));
            this.add((Component)this.label, "North");
            this.chordList = new ChordList();
            this.add((Component)this.chordList, "Center");
            this.degree = degree;
        }

        public void updateChords() {
            int[] chordMode = ModeChordsPanel.this.scale.getChordMode(this.degree);
            this.label.setToolTipText(Interval.spell(chordMode));
            List<Chord> chords = Chords.fromChordMode(chordMode);
            this.chordList.setChords(chords);
        }
    }
}

