/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.transportui;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JToolBar;
import uk.org.toot.audio.server.NonRealTimeAudioServer;
import uk.org.toot.swingui.transportui.TransportAction;
import uk.org.toot.swingui.transportui.TransportLocation;
import uk.org.toot.swingui.transportui.TransportToggleButton;
import uk.org.toot.transport.Transport;
import uk.org.toot.transport.TransportAdapter;
import uk.org.toot.transport.TransportListener;

public class TransportActions {
    private TransportAction loopAction = new LoopAction();
    private TransportAction stopAction = new StopAction();
    private TransportAction playAction = new PlayAction();
    private TransportAction recordAction = new RecordAction();
    private TransportAction realTimeAction = null;
    private TransportListener transportListener;
    private Transport transport;

    public TransportActions(Transport t) {
        this.transport = t;
        this.transportListener = new TransportAdapter(){

            public void stop() {
                TransportActions.this.stopAction.setSelected(true);
                TransportActions.this.playAction.setSelected(false);
                if (TransportActions.this.realTimeAction != null) {
                    TransportActions.this.realTimeAction.setEnabled(true);
                }
            }

            public void play() {
                TransportActions.this.stopAction.setSelected(false);
                TransportActions.this.playAction.setSelected(true);
                if (TransportActions.this.realTimeAction != null) {
                    TransportActions.this.realTimeAction.setEnabled(false);
                }
            }

            public void record(boolean rec) {
                TransportActions.this.recordAction.setSelected(TransportActions.this.transport.isRecording());
            }
        };
        this.transport.addTransportListener(this.transportListener);
    }

    public void dispose() {
        this.transport.removeTransportListener(this.transportListener);
        this.transportListener = null;
        this.loopAction = null;
        this.stopAction = null;
        this.playAction = null;
        this.recordAction = null;
        this.realTimeAction = null;
    }

    public static void addTransportTools(TransportActions transportActions, JToolBar toolBar) {
        toolBar.addSeparator();
        toolBar.add(new TransportToggleButton(transportActions.getStopAction()));
        toolBar.add(new TransportToggleButton(transportActions.getPlayAction()));
        toolBar.add(new TransportToggleButton(transportActions.getRecordAction()));
        toolBar.addSeparator();
        toolBar.add(new TransportLocation(transportActions.getTransport()));
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Action getLoopAction() {
        return this.loopAction;
    }

    public Action getStopAction() {
        return this.stopAction;
    }

    public Action getPlayAction() {
        return this.playAction;
    }

    public Action getRecordAction() {
        return this.recordAction;
    }

    public Action getRealTimeAction(NonRealTimeAudioServer server) {
        return new RealTimeAction(server);
    }

    public void enableActions(boolean enable) {
        this.loopAction.setEnabled(enable);
        this.stopAction.setEnabled(enable);
        this.playAction.setEnabled(enable);
        this.recordAction.setEnabled(enable);
        if (this.realTimeAction != null) {
            this.realTimeAction.setEnabled(enable);
        }
    }

    public static class LoopAction
    extends TransportAction {
        public LoopAction() {
            this.putValue("Name", "Loop");
            this.putValue("SmallIcon", this.icon("general/Refresh16", "Loop"));
            this.putValue("ShortDescription", "Loop");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    public class StopAction
    extends TransportAction {
        public StopAction() {
            this.putValue("Name", "Stop");
            this.putValue("SmallIcon", this.icon("media/Stop16", "Stop"));
            this.putValue("ShortDescription", "Stop");
            this.setSelected(true);
        }

        public void actionPerformed(ActionEvent e) {
            boolean reset = !TransportActions.this.transport.isPlaying();
            TransportActions.this.transport.stop();
        }
    }

    public class PlayAction
    extends TransportAction {
        public PlayAction() {
            this.putValue("Name", "Play");
            this.putValue("SmallIcon", this.icon("media/Play16", "Play"));
            this.putValue("ShortDescription", "Play");
        }

        public void actionPerformed(ActionEvent e) {
            TransportActions.this.transport.play();
        }
    }

    public class RecordAction
    extends TransportAction {
        public RecordAction() {
            this.putValue("Name", "Record");
            this.putValue("SmallIcon", this.icon("general/Stop16", "Record"));
            this.putValue("ShortDescription", "Record");
        }

        public void actionPerformed(ActionEvent e) {
            TransportActions.this.transport.record(!TransportActions.this.transport.isRecording());
        }
    }

    public static class RealTimeAction
    extends TransportAction {
        private NonRealTimeAudioServer server;

        public RealTimeAction(NonRealTimeAudioServer server) {
            this.server = server;
            this.setSelected(true);
            this.putValue("Name", "RealTime");
            this.putValue("ShortDescription", "RealTime");
        }

        public void actionPerformed(ActionEvent e) {
            this.setSelected(!this.isSelected());
            this.server.setRealTime(this.isSelected());
        }
    }
}

