/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.transport;

import java.util.ArrayList;
import java.util.List;
import uk.org.toot.transport.SystemTimeSource;
import uk.org.toot.transport.TimeSource;
import uk.org.toot.transport.Transport;
import uk.org.toot.transport.TransportListener;

public class DefaultTransport
implements Transport {
    private boolean playing = false;
    private boolean recording = false;
    private List<TransportListener> listeners = new ArrayList<TransportListener>();
    private TimeSource timeSource = new SystemTimeSource(this);

    public void stop() {
        if (!this.playing) {
            if (this.getMicrosecondLocation() != 0L) {
                this.locate(0L);
            }
            return;
        }
        for (TransportListener l : this.listeners) {
            l.stop();
        }
        this.playing = false;
    }

    public void play() {
        if (this.playing) {
            return;
        }
        this.playing = true;
        for (TransportListener l : this.listeners) {
            l.play();
        }
    }

    public void record(boolean rec) {
        this.recording = rec;
        for (TransportListener l : this.listeners) {
            l.record(this.recording);
        }
    }

    public void locate(long microseconds) {
        for (TransportListener l : this.listeners) {
            l.locate(microseconds);
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void addTransportListener(TransportListener listener) {
        if (!this.listeners.contains(listener) && listener != this) {
            this.listeners.add(listener);
        }
    }

    public void removeTransportListener(TransportListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public long getMicrosecondLocation() {
        return this.timeSource.getMicrosecondLocation();
    }
}

