/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.transport;

import uk.org.toot.transport.TimeSource;
import uk.org.toot.transport.Transport;
import uk.org.toot.transport.TransportAdapter;

public class SystemTimeSource
implements TimeSource {
    private Transport transport;
    private long startTime = 0L;
    private long stopTime = 0L;

    public SystemTimeSource(Transport t) {
        this.transport = t;
        TransportAdapter transportListener = new TransportAdapter(){

            public void play() {
                SystemTimeSource.this.startTime = SystemTimeSource.this.microsecondTime() - SystemTimeSource.this.stopTime;
            }

            public void stop() {
                SystemTimeSource.this.stopTime = SystemTimeSource.this.getMicrosecondLocation();
            }

            public void locate(long microseconds) {
                SystemTimeSource.this.stopTime = microseconds;
            }
        };
        this.transport.addTransportListener(transportListener);
    }

    protected long microsecondTime() {
        return System.nanoTime() / 1000L;
    }

    public long getMicrosecondLocation() {
        if (this.transport.isPlaying()) {
            return this.microsecondTime() - this.startTime;
        }
        return this.stopTime;
    }
}

