/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ENGINE_H
#define ENGINE_H

#include "midi_voice.h"

/**
  *@author Juan Linietsky
  * Base class for engine
  */

class Engine {
public:

	virtual string get_name()=0; // get engine name


	/*
	  Add a bank, return the index of it
	*/
        virtual int add_bank()=0;
	
	virtual int get_bank_count()=0; //how many banks does this engine have?
	virtual string get_bank_name(int p_bank_index)=0;
	
	virtual bool bank_has_patch(int p_patch_index)=0;
	
	virtual string get_patch_name(int p_bank_index,int p_patch_index)=0;

	/* get voice! */
	virtual Midi_Voice * get_midi_voice(int p_bank, int p_pach)=0;
	virtual Midi_Voice * get_midi_drum_voice(int p_bank,int p_drum_bank,char p_instrument)=0;
	

	Engine();
	~Engine();
};

#endif
