//
// C++ Interface: ladspa_effect
//
// Description: 
//
//
// Author: Juan Linietsky <coding@reduz.com.ar>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef LADSPA_EFFECT_H
#define LADSPA_EFFECT_H


#ifdef LADSPA_ENABLED


#include "common/plugins/effects/ladspa/ladspa.h"
#include "components/audio/effect.h"
#include <vector>
	using std::vector;

/**
@author Juan Linietsky
*/
class LADSPA_Effect : public Effect {

	enum {
		MAX_SAMPLES=8192
	};


	float buffer_l_src[MAX_SAMPLES];
	float buffer_r_src[MAX_SAMPLES];
	float buffer_l_dst[MAX_SAMPLES];
	float buffer_r_dst[MAX_SAMPLES];
	float buffer_thrash[MAX_SAMPLES]; //seems this is needed?
	float buffer_zero[MAX_SAMPLES]; //seems this is needed?




	struct Property {

		enum Type {
			TYPE_INT,
			TYPE_BOOL,
			TYPE_FLOAT
		};

		Property_Bridge *bridge;

                Type type;

		struct ParamControl {
			float float_control;
			int int_control;
			bool bool_control;
		} bridged;

		float ladspa_control;

		Property() {

			type=TYPE_FLOAT;
			bridge=NULL;
			memset(&bridged,0,sizeof(ParamControl));
			ladspa_control=0;
		}
	};

	vector<Property*> properties;

        bool working;

	const LADSPA_Descriptor *descriptor;

	bool stereo;
	LADSPA_Handle handle;
	LADSPA_Handle handle2;

	string display_name;
	string name;

	float mixing_freq;
	void *library;

public:


	void reset();
        void process_buffer(sample_32s_t* p_buffer,int p_length,bool p_stereo_samples,int p_buffer_freq);
	string get_name();
	string get_display_name();
	list<Property_Bridge*> get_properties();

	LADSPA_Effect(string p_filename,int p_index); //from which file, which of the plugins
	~LADSPA_Effect();

};

#endif //ladspa enabled

#endif
