
import os;
import os.path;
import re;


def sconize_dir(libname): 

	aux_files=os.listdir(".");
	files = [];
	dirs = [];
	
	for x in aux_files:
		if (re.search(".cpp",x)):
			files.append(x);
		if (os.path.isdir(x) == 1):
			dirs.append(x);


	if (files == []): # no files! Let's add the dirs
		
		scsub=open("SCsub","w");
		scsub.write("\nImport('env');\n");
		scsub.write("Export('env');\n\n\n");
		for x in dirs:

			scsub.write("SConscript('" + x + "/SCsub');\n");

		scsub.close();
	else:

		scsub=open("SCsub","w");
		scsub.write("\nImport('env');\n");
		scsub.write("env2=env.Copy();\n\n\n");
		scsub.write("file_list=[\\\n");

		for x in files:
			scsub.write("'" + x + "',\\\n");

		scsub.write("]\n\n");
		scsub.write("env2.Library('" + libname + "', file_list);\n");
	
		scsub.close();



def parse_dir(p_dir,p_lib):


	sconize_dir("lib"+p_lib+".a");
	files=os.listdir(p_dir);

	for x in files:

		if (os.path.isdir(x)):

			new_dir=p_dir+"/"+x;
			
			os.chdir(new_dir);
			parse_dir(new_dir,p_lib + "_" + x);
			os.chdir(p_dir);
	

parse_dir(os.getcwd(),"");

	
	