
import os;
import string;


def parse_libs(cmd):

        ret = { 'flags' : [],  'libs' : [] }

        parts = string.split(os.popen(cmd).readlines()[0])
        for part in parts:
                if part[:2] == "-l":
                        ret['libs'].append(part[2:])
                else:
                        ret['flags'].append(part)

        return ret

def check_pkg_config():

	print "Detecting if PKG-CONFIG is installed... ";

	errorval=os.system("pkg-config --version");


	if (errorval):
		print "Error: cant execute pkg-config, please install pkg-config!"
		return 1;
	else:
		print "pkg-config found!";
		return 0;


def check_libdl(libdata):

	print "Checking for libdl...";
	dl_search_dirs=[ \
		"/sw", \
		"/usr", \
		"/usr/local", \
	];

	# search for extra include dirs to add
	for x in dl_search_dirs:
		if (os.path.isfile(x + "/include/dlfcn.h")):
			print "Found dlfcn.h in " + x + "/include";
			libdata.dl_flags=["-I" + x + "/include"];
			break;

	f=open("test.cpp","w");
	f.write("#include <dlfcn.h>\n#include <stdio.h>\nint main() { printf(\"Testing dlfcn.\"); return 0; }\n");
	f.close();

	for x in dl_search_dirs:
		execline="c++ -L" + x + "/lib " + libdata.dl_flags[0] + " test.cpp -o test -ldl 2>>config_errors.log";
		res=os.system(execline);

		if (res == 0):
			libdata.dl_libs=['dl'];
			libdata.dl_link_flags=["-L" + x + "/lib"];
			os.system("rm test.cpp");
			os.system("rm test");
			return 0;
	return 1;

def check_jack(libdata):

	print "Checking for JACK...";

	errorval=os.system("pkg-config jack --modversion");

	if (errorval):
		libdata.has_jack=0;
		return 1;

	print "JACK found!";

	res=parse_libs("pkg-config jack --cflags");
	libdata.jack_flags=res['flags'];
	res=parse_libs("pkg-config jack --libs");
	libdata.jack_link_flags=res['flags'];
	libdata.jack_libs=res['libs'];
	libdata.has_jack=1;

	return 0;

def check_sigc(libdata):

	print "Checking for libsigc++-1.2...";

	errorval=os.system("pkg-config sigc++-1.2 --modversion");

	if (errorval):
		return 1;

	print "libsigc++-1.2 found!";

	res=parse_libs("pkg-config sigc++-1.2 --cflags");
	libdata.sigc_flags=res['flags'];
	res=parse_libs("pkg-config sigc++-1.2 --libs");
	libdata.sigc_link_flags=res['flags'];
	libdata.sigc_libs=res['libs'];

	return 0;

#list of dirs I can test..

def check_qt(libdata):

	#list of dirs I can test..
	qt_unix_library_dirs = [\
		"",\
		"/usr/lib",\
		"/usr/X11R6/lib",\
		"/usr/lib/qt3/lib",\
		"/usr/local/lib",\
		"/usr/local/lib/qt3/lib",\
		"/opt/qt3/lib"\
	];

	qt_unix_bin_dirs = [\
                "",\
		"/usr/bin",\
		"/usr/X11R6/bin",\
		"/usr/lib/qt3/bin",\
		"/usr/local/bin",\
		"/usr/local/lib/qt3/bin",\
		"/opt/qt3/bin"\
	];

	qt_unix_include_dirs = [\
		"/usr/include",\
		"/usr/include/qt3",\
		"/usr/X11R6/include",\
		"/usr/X11R6/include/qt3",\
		"/usr/lib/qt3/include",\
		"/usr/lib/qt3/include/qt3",\
		"/usr/local/include",\
		"/usr/local/include/qt3",\
		"/usr/local/lib/qt3/include",\
		"/usr/local/lib/qt3/include/qt3",\
		"/opt/qt3/include"\
	];

	print "QT Check:";

	if (os.environ.has_key('QTDIR')):
                qtdir=os.environ['QTDIR'];
		print "$QTDIR exists at, using QTDIR instead of harcdoded pathlist " + qtdir;
		include_qtdir=qtdir+'/include';
		qt_unix_include_dirs=[];
		qt_unix_include_dirs.append(include_qtdir);
		qt_unix_include_dirs.append(include_qtdir + '/qt');
		qt_unix_include_dirs.append(include_qtdir + '/qt3');

		lib_qtdir=qtdir+'/lib';
		qt_unix_library_dirs=[];
		qt_unix_library_dirs.append(lib_qtdir);

		bin_qtdir=qtdir+'/bin';
		qt_unix_bin_dirs=[];
		qt_unix_bin_dirs.append(bin_qtdir);
	else:
		print "$QTDIR not found, you could define this pointing to a proper QT location if not found";
		print "I will try to check if you have Qt in a bunch of paths..";

	print "Looking for QT 3.x Includes:";

        qt_inc_found=0;
        for x in qt_unix_include_dirs:

		file_to_check = "qglobal.h"
		current_file=x + "/" + file_to_check;

		if (os.path.isfile(current_file)):
			print x;
			print "Checking QT version.. \n";
			version=os.popen("cat " + current_file + " | grep \"QT_VERSION_STR \" ").readlines();
			if not len(version):
				print "Cant determine QT version! (qglobal.h not found at " +x+ ")\n";
				continue;

			ver_str=version[0];
			pos=ver_str.find("\"3.");
			if (pos >=0 ): #found QT header
				print ver_str;
				libdata.qt_flags=["-I"+x];
				qt_inc_found=1;
				break;

	print "Looking for QT 3.x Libraries:";

	qt_lib_found=0;

        for x in qt_unix_library_dirs:
		if (not qt_inc_found):
			break;

		test_program="#include <qglobal.h>\n #include<stdio.h>\n int main() { \n printf(\"Testing QT: %s\\n\",QT_VERSION);\n return 0;\n }\n";

		f=open("test.cpp","w");
		f.write(test_program);
                f.close();

		auxlibpath="";
		if (len(x)>0):
			auxlibpath="-L"+x;
		#check if we must use -lqt
		execline="c++ " + auxlibpath + " "+libdata.qt_flags[0]+" test.cpp -o test -lqt  2>> config_errors.log"; # 2>/dev/null";
		res=os.system(execline);

		if (res == 0):
			qt_lib_found=1;
			print "using: -lqt" + auxlibpath;
			libdata.qt_link_flags=[auxlibpath];
			libdata.qt_libs=['qt'];
			os.system("rm test.cpp");
			os.system("rm test");
			break;


		execline="c++ " + auxlibpath + " "+libdata.qt_flags[0]+" test.cpp -o test -lqt-mt 2>> config_errors.log";
		res=os.system(execline);
		os.system("rm test.cpp");
		if (res==0):
			os.system("rm test");
			print "using: -lqt-mt" + auxlibpath;
			qt_lib_found=1;
			libdata.qt_link_flags=[auxlibpath];
			libdata.qt_libs=['qt-mt'];
			break;

	print "Looking for QT 3.x 'moc' Binary:";

	qt_found=0;

        for x in qt_unix_bin_dirs:
		if (not qt_lib_found):
			break;

		command="moc";
		if (len(x)):
			command=x+"/moc";

		res=os.system(command + " -v 2>/dev/null");
		if (res!=256):
                        continue;

       		version=os.popen(command +" -v 2>&1").readlines();
                if (not len(version)):
                        continue;

                pos=version[0].find(" 3.");
                if (pos<0):
                        print("Not version 3:" + command);
                        continue;

       		qt_found=1;
       		print "found moc command: " + command;
       		libdata.moc_bin=command;
		break;


        if (not qt_found):
		print("I Couldnt find QT in your system :(\n");
		print("If you think it is actually installed, you could try the following:\n");
		print("-Define/undefine the $QTDIR env var. Some distros/unixes dont place Qt in standard locations (Like Debian)\n");
		print("-Check if the path where your Qt 3.x stuff is and add it to the list at detect.py!\n");
		print("-I am not a good python coder so detect.py may be buggy, if you fixed it, please send patches to coding@reduz.com.ar :)\n");

		return 1;

	else:
		print("QT was found!\n");
		return 0;



def check_system(libdata):
	f=os.popen("uname");
	sysname=f.readlines()[0];
	libdata.os_is_cygwin=(sysname.find("CYGWIN")>=0);
	libdata.os_is_macosx=(sysname.find("Darwin")>=0);


def check_oss(libdata):

	print "Detecting if OSS exists on the system..";

	test_program="#include <sys/soundcard.h>\n #include <stdio.h>\n int main() { \n printf(\"Testing OSS: \\n\");\n return 0;\n }\n";

	f=open("test.cpp","w");
	f.write(test_program);
	f.close();

	execline="cc test.cpp -o test  2>> config_errors.log"; # 2>/dev/null";
	res=os.system(execline);
	libdata.is_oss_installed=(res==0);
	if (libdata.is_oss_installed):
		print("OSS was found.");
	else:
		print("OSS was not detected.");
	os.system("rm test.cpp");






def read_dep_cache(libdata):

	return 0;

def write_dep_cache(libdata):

	return 0;

def check_dependences(libdata):

	check_system(libdata);

	if (read_dep_cache(libdata)):
		return 0;

	if ( check_libdl(libdata) ):
		return 1;

	if ( check_pkg_config() ):
		return 1;

	if ( check_sigc(libdata) ):
		return 1;

	if ( check_qt(libdata) ):
		return 1;


	check_jack(libdata)

	check_oss(libdata);
	print "Dependency check successful, writing cache";

	write_dep_cache(libdata);

	return 0;
