
    org $be00
gal_rom:
    incbin "rom.bin"

    org &de00
gal_screen:  equ &2800   ; list of chars to print
screen:      equ &c000   ; Speccy screen
char_lookup: equ &dd00   ; character mapping lookup
ldstart:     equ &8000+(moveend-moveit)
newsp:	     equ &ffff	 ; SP at the end of the mem

throttle:    equ 0    ; maximum number of unchanged characters to skip when drawing

main:                   ; to allow maximum speed to be controlled
start:
    di

    ld  sp,newsp

; Patch ROM IM1 handler after PUSH AF/BC/DE/HL
    ld  a,&c3           ; JP
    ld  (gal_rom + &3c),a
    ld  hl,int_handler
    ld  (gal_rom + &3d),hl

; Patch ROM OLD (LOAD)
    ld 	hl, gal_rom + &e97
    ld 	(hl), $c3
    inc	hl
    ld 	(hl), romold & 255
    inc	hl
    ld 	(hl), romold >> 8

; Patch RAM TEST
    ld  a,&21
    ld  (gal_rom + &3ea),a
;    ld  hl,screen       ; set RAMTOP at sam_screen
    ld  hl,$a800	 ; now a diff buffer is below screen
    ld  (gal_rom + &3eb),hl

;Check for divide here (if divide connected then ALWAYS use it)
; map divide page3 to $2000
    ld  c,&e3
    ld  a,%10000011
    out (c),a
;If divide then there should be RAM at $2000
    ld  hl, $2000
    xor a
    ld  (hl),a
    ld  a,(hl)
    cp  $00
    jr  nz, mb02test
    ld  a,$ff
    ld  (hl),a
    ld  a,(hl)
    cp  $ff
    jr  nz, mb02test
divide:
    ld  a,$00
    ld  (useplus3),a
    ; page3 already paged in from test...
    ; copy rom
    ld  hl, gal_rom
    ld  de, $2000
    ld  bc, $2000
    ldir
    ; divide page3 to $0000 , page0 to $2000
    ld  c, &e3
;   ld  a, %01000000
    ld  a, %01000010
    out (c),a
    jp  donepaging
mb02test:
    ld c, &17
    ld a, %01100011
    out (c), a
; paging MB02 bank3 with write enable
    ld hl, $0000
    xor a
    ld  (hl),a
    ld  a,(hl)
    cp  $00
    jr  nz, plus3
    ld  a,$ff
    ld  (hl),a
    ld  a,(hl)
    cp  $ff
    jr  nz, plus3    
mb02:
    ld  hl, mb02line
    ld  de, oldmenu
    ld  bc, 32
    ldir
    ld  a,$02
    ld  (useplus3),a
    ld  hl, gal_rom
    ld  de, $0000
    ld  bc, $2000
    ldir
    jp  donepaging
plus3:
    ld  hl, plus3line
    ld  de, oldmenu
    ld  bc, 32
    ldir
    ld  a,$01
    ld  (useplus3),a
    ; copy rom to $6000 (cause next paging will page it out)
    ld  hl, gal_rom
    ld  de, $6000
    ld  bc, $2000
    ldir
    ; pages: 4 5 6 7 special paging !
    ld  a,&03
    ld  bc,&1ffd
    out (c),a
    ; copy rom
    ld hl, $6000
    ld de, $0000
    ld bc, $2000
    ldir

donepaging:
    ld  bc,&0338        ; 3 blocks of 256, black on white
    ld  hl,&c000+&1800  ; attributes
attrlp:
    ld  (hl),c
    inc l
    jp  nz,attrlp
    inc h
    djnz attrlp

    ; map $c000 as video
    ld  a,&1f
    ld  bc,&7ffd
    out (c),a
    ; border black
    ld  a,&00
    ld  c,&fe
    ld  b,&00
    out (c),a

; Create lookup table for each character address on the screen
    ld  c,8             ; 8 pairs of chars vertically
    exx
    ld  hl,char_addrs
    ld  de,screen
    ld  bc,screen+32
chrlp1:
    ld  a,32            ; 32 columns
chrlp2:
    ld (hl),e
    inc l
    ld (hl),d
    inc l
    ld (hl),c
    inc l
    ld (hl),b
    inc hl
    inc e
    inc c
    dec a
    jr nz,chrlp2            ; complete row

    set 2,b
    ld  a,c
    sub 32
    ld  c,a
    ld  a,e
    sub 32
    ld  e,a
    add a,64
    cp  e
    ld  e,a
    jr  nc, noadd1_
    ld  a,d
    add a,8
    ld  d,a
noadd1_:

    ld  a, 32
chrlp3:
    ld (hl),c
    inc l
    ld (hl),b
    inc l
    ld (hl),e
    inc l
    ld (hl),d
    inc hl
    inc e
    inc c
    dec a
    jr  nz,chrlp3           ; complete row

    res 2,b
    ld  a,c
    sub 32
    add a,96
    ld  c,a
    jr  nc,noadd2_
    ld  a,b
    add a,8
    ld  b,a
noadd2_:
    ld  a,e
    and a
    jr  nz,noadd3_
    ld  a,d
    add a,8
    ld  d,a
noadd3_:
    exx
    dec c
    exx
    jp  nz,chrlp1

    ld  bc,&a000        ; 160 blocks of 256, &00 fill
    ld  h,&20           ; clear from &2000
clearlp:
    ld  (hl),c
    inc l
    jp  nz,clearlp
    inc h
    djnz clearlp

; Create lookup table to fix swapped bits 6+7 in character values
    ld  hl,char_lookup
lookuplp:
    ld  a,l
    and &bf
    rla
    jr  nc,noth
    or  &80
noth:
    ld  (hl),a
    inc l
    jp  nz,lookuplp

; start the emulation
    im  1
    ei
    jp  &0000   


; RST &38 routine - refresh display & keyboard
int_handler:
    ex af,af'
    push af
    exx
    push bc
    push de
    push hl
    push ix
    push iy

;    ld  c,&fe
;    ld  a,%110
;    out (c),a

menu_draw:

    ld  (draw_sp+1),sp
    ld  sp,char_addrs   ; 512 addresses for each Gal character on screen

    ld  ix,throttle     ; maximum unchanged characters to skip
    ld  a,&be           ; CP (HL)
    ld  (cp_patch1),a   ; begin by comparing to skip identical characters
    ld  (cp_patch2),a   ; begin by comparing to skip identical characters

    ld  hl,gal_screen
    ld  d,char_lookup/256
    ld  c,8

draw_lp:
    ld  b,32
draw_lp1:
    res 7,h
    ld  a,(hl)
    set 7,h
cp_patch1:
    cp  (hl)
    jp  z,samesame1
    ld  (hl),a
    ld  e,a
    ld  a,(de)

    exx
    ld  l,a
    ld  h,gal_font/256
    pop de

    ld  a,(hl) ; this bit on first character row
    ld  (de),a
    inc d
    inc l
    ld  a,(hl)
    ld  (de),a
    inc d
    inc h
    ld  a,(hl)
    ld  (de),a
    inc d
    dec l
    ld  a,(hl)
    ld  (de),a
    inc d
    inc h
    ld  a, (hl)
    ld  (de),a
    inc d
    inc l
    ld  a,(hl)
    ld  (de),a
    inc d
    inc h
    ld  a,(hl)
    ld  (de),a
    inc d
    dec l
    ld  a,(hl)
    ld  (de),a
    inc h

    pop de

    ld  a,(hl) ; this bit on 2nd character row
    ld  (de),a
    inc d
    inc l
    ld  a,(hl)
    ld  (de),a
    inc d
    inc h
    ld  a,(hl)
    ld  (de),a
    inc d
    dec l
    ld  a,(hl)
    ld  (de),a

    exx
end_draw1:
    inc hl                  ; advance to next character to draw
    djnz draw_lp1

    ld  b,32
draw_lp2:
    res 7,h
    ld  a,(hl)
    set 7,h
cp_patch2:
    cp  (hl)
    jp  z,samesame2
    ld  (hl),a
    ld  e,a
    ld  a,(de)

    exx
    ld  l,a
    ld  h,gal_font/256
    pop de

    ld  a, (hl) ; this bit on 2nd character row
    ld  (de),a
    inc d
    inc l
    ld  a,(hl)
    ld  (de),a
    inc d
    inc h
    ld  a,(hl)
    ld  (de),a
    inc d
    dec l
    ld  a,(hl)
    ld  (de),a
    inc h

    pop de

    ld  a, (hl) ; this bit on third character row
    ld  (de),a
    inc d
    inc l
    ld  a,(hl)
    ld  (de),a
    inc d
    inc h
    ld  a,(hl)
    ld  (de),a
    inc d
    dec l
    ld  a,(hl)
    ld  (de),a
    inc d
    inc h
    ld  a, (hl)
    ld  (de),a
    inc d
    inc l
    ld  a,(hl)
    ld  (de),a
    inc d
    inc h
    ld  a,(hl)
    ld  (de),a
    inc d
    dec l
    ld  a,(hl)
    ld  (de),a

    exx
end_draw2:
    inc hl                  ; advance to next character to draw
    djnz draw_lp2

    dec c
    jp  nz,draw_lp
    jr  draw_sp

samesame1:
    pop af                  ; junk the 2 addresses
    pop af

throt1jp:
;    jp  end_draw1           ; *** remove jump to activate throttling
    defb $00, $00, $00

    nop
    nop
    nop
    nop
    nop
    nop
    nop
    dec ixl
    jp nz, end_draw1
    dec ixh
    jp nz, end_draw1
    ld  a,&a7              ; change CP (HL) to AND A, for NZ flags
    ld  (cp_patch1),a
    ld  (cp_patch2),a
    jp  end_draw1

samesame2:
    pop af                  ; junk the 2 addresses
    pop af

throt2jp:
;    jp  end_draw2           ; *** remove jump to activate throttling
    defb $00, $00, $00

    nop
    nop
    nop
    nop
    nop
    nop
    nop
    dec ixl
    jp nz, end_draw2
    dec ixh
    jp nz, end_draw2
    ld  a,&a7                ; change CP (HL) to AND A, for NZ flags
    ld  (cp_patch1),a
    ld  (cp_patch2),a
    jp  end_draw2

draw_sp:
    ld  sp,0                ; restore normal stack

keybrd:
; clear currently pressed keys
    ld  hl,&2000            ; start of keyboard buffer
    ld  bc,&38ff            ; 56 positions to clear with &ff
clearkblp:
    ld  (hl),c
    inc l
    djnz clearkblp

; Skip scanning if not keys are pressed
    xor a
    in  a,(&fe)
    cpl
    and %00011111
    jp  z,done_matrix

    ld  h,&20
    ld  c,&fe

    ;check individual keys
    ld  b,&7f
    in  a,(c)
    bit 1,a                 ;; sym shift
    jr  nz, notpr0
    ld  l,53
    ld  (hl),c
notpr0:
    ld  b,&fe
    in  a,(c)
    rra                     ;; shift
    jp  c,done_shift
    rra                     ;; shift+z
    jr  c, notprs7
    ld  l,42
    ld  (hl),c
notprs7:
    rra
    rra
    rra                     ;; shift+v
    jr  c,notprs9
    ld  l,47
    ld  (hl),c
notprs9:
    ld  b, $f7
    in  a,(c)
    bit 1,a
    jr  nz, notdel	     ;; shfit+2 = del
    ld  l,51
    ld  (hl),c
notdel:
    bit 2,a
    jr  nz, notrep           ;; shift +3 = repeat
    ld  l,50
    ld  (hl),c
notrep:
    bit 3,a		    ;; shift + 4 = LIST
    jr  nz, notlist	
    ld  l,52
    ld  (hl),c
notlist:
    bit 4,a
    jr  nz, notthrot        ;; shift +_5 = throttling ... future
    ld  a,(throton)
    xor 1
    ld  (throton),a
    jr  nz, enablethrot
    ld  hl, $0000
    ld  (throt1jp),hl
    ld  (throt2jp),hl
    ld  a, $00
    ld  (throt1jp+2),a
    ld  (throt2jp+2),a
    jr  doefektthr   
enablethrot:
    ld  a,$c3
    ld  (throt1jp),a
    ld  (throt2jp),a
    ld  hl, end_draw1
    ld  (throt1jp+1), hl
    ld  hl, end_draw2
    ld  (throt2jp+1), hl
doefektthr:
    ld  a,(throton)
    or  %010
    out (c),a
    jp  doefekt2
notthrot:
    ld  b,$f7
    in  a,(c)
    rra			    ;; shift+1 = cursors
    jr  c, notprscur
    ; check if cursors are on
    ld  a,(cursorson)
    xor 1
    ld  (cursorson),a
    jr  nz, enablecur
    ld  hl, $2726		; cursors off
    ld  (sinclair1),hl
    ld  hl, $2928
    ld  (sinclair1+2),hl 
    ld  a, 32
    ld  (sinclair1+4),a
    jr  doefekt
enablecur:
    ld  hl, $1e1d		; cursors on
    ld  (sinclair1),hl
    ld  hl, $1b1c
    ld  (sinclair1+2),hl
    ld  a, 46
    ld  (sinclair1+4),a
doefekt:
    ld  a,(cursorson)
    or  %100
    out (c),a
doefekt2:
    in	a,(c)
    cpl
    and %00011111
    jp  nz,doefekt2
    ld  a,0
    out (c),a
    jp  done_matrix
notprscur:
    ld  b,&7f
    in  a,(c)
    rra                     ;; shift+space
    jr  c,notprs2
    ld  l,49
    ld  (hl),c
notprs2:
    rra
    rra                     ;; shift+m
    jr  c,notprs4
    ld  l,46
    ld  (hl),c
notprs4:
    rra                     ;; shift+n
    jr  c,notprs6
    ld  l,44
    ld  (hl),c
notprs6:
    ld  b,&ef
    in  a,(c)
    rra                     ;; shift + 0
    jr  c,notprs3
    ld  l,29
    ld  (hl),c
notprs3:
    bit 2,a                 ;; shift + 7
    jr  nz,notprs8
    ld  l,43
    ld  (hl),c
notprs8:
    ld  b,&bf
    in  a,(c)
    bit 1,a                 ;; shift + L
    jr  nz,notprs5
    ld  l,45
    ld  (hl),c
notprs5:
    ld  b,&fd
    in  a,(c)
    rra
    rra
    jp c, done_matrix
    rra                     ;; shift + a + d
    jp  nc,&0000            ;; reset
    jp  done_matrix
done_shift:

; Scan the full keymap
    ld  hl,keymap
    ld  d,&20           ; Gal keyboard mapped at &20xx
    ld  b,&fe           ; keyboard row mask
key_lp1:
    ld  c,&fe           ; Speccy keyboard port
    in  a,(c)
    or  %11100000       ; only bottom 5 bits used for keys
    inc a
    jr  z,no_row        ; jump if no keys on row are pressed
    dec a
    rla
    rla
    rla
    ld  c,5             ; 5 bits to scan in each byte
key_lp2:
    rla                 ; shift next bit into carry
    jr  c,no_press      ; jump if not pressed
    ld  e,(hl)
    bit 7,e             ; check for unused map entry
    jr  nz,no_press
    ex  de,hl
    ld  (hl),&fe        ; flag Gal key as pressed
    ex  de,hl
no_press:
    inc hl              ; next key in map
    dec c
    jr  nz,key_lp2      ; complete row
next_row:
    rlc b               ; move to next row to scan
    jr  c,key_lp1
    jp  done_matrix
no_row:
    ld  a,l
    add a,5             ; skip 1 row in keymap
    ld  l,a
    jr  next_row

    ALIGN 256

; Mapping from 5x8 keyboard matrix to native $20xx I/O address LSB
keymap:
    defb 22, 3,24,26,53   ; V C X Z Shift
    defb  7, 6, 4,19, 1   ; G F D S A
    defb 20,18, 5,23,17   ; T R E W Q
    defb 37,36,35,34,33   ; 5 4 3 2 1
sinclair1:
    defb 38,39,40,41,32   ; 6 7 8 9 0
    defb 25,21, 9,15,16   ; Y U I O P
    defb  8,10,11,12,48   ; H J K L Return
    defb  2,14,13,53,31   ; B N M Sym Space

done_matrix:
    ld  hl,0
    ld  (&2bb0),hl      ; clear window offset?

;    ld  c,&fe
;    ld  a,0
;    out (c),a

    pop iy
    pop ix
    pop hl
    pop de
    pop bc
    exx
    pop af
    ex  af,af'

    jp  &00c0           ; rest of Gal int handler and POP HL/DE/BC/AF

romold:
    di

    ld	(oldsp),sp
    ld	sp,newsp
    push af
    push bc
    push de
    push hl
    push ix
    push iy
    ld  iy, 23610	;; for rom calls
    exx	
    ex	af,af'
    push af
    push bc
    push de
    push hl
    ld hl, 10072	;; for rom calls
    exx
    ex	af,af'

    ; clear currently pressed keys
    ld  hl,&2000            ; start of keyboard buffer
    ld  bc,&38ff            ; 56 positions to clear with &ff
clearkblp2:
    ld  (hl),c
    inc l
    djnz clearkblp2

	; wait for space to be released
keyp1:
    ld	a, $7f
    in	a, ($fe)
    rra
    jp	nc, keyp1

    ;preserve screen
    ld  hl, $2800
    ld  de, menustore
    ld  bc, 512
    ldir
    ; draw menu
    ld  hl, oldmenu
    ld  de, $2800
    ld  bc, 512
    ldir
    ; RET instead of JR
    ld  a,$c9
    ld  (keybrd),a
    ; refresh the screen
    call menu_draw

    ; wait for key 1-9
menukey:
    ld  c, $fe
    ld  hl, oldtable
    ld  de,$0004
    ld  b, $f7
    in  a,(c)
    ld  b, 5
firstrow:
    rra
    jr  c, mk1
    jp  getpage
mk1:
    add hl,de
    djnz firstrow
    ld  b,&ef
    in  a,(c)
    rra
    jp  nc, divideout
    ld  b,4
secondrow:
    rra
    jr  c, mk2
    jp  getpage
mk2:
    add hl,de
    djnz secondrow
    jp  menukey

getpage:
    push hl
;check for plus3
    ld  a,(useplus3)
    cp  $01
    jr  nz, notplus3_2
;go to normal paging
    ld	a, $3c
    ld	bc, $1ffd
    out	(c), a    
    ld  hl, moveitp3
    ld  de, $8000
    ld  bc, moveendp3-moveitp3
    ldir
    jr  aftermove
notplus3_2:
    ld  hl, moveit
    ld  de, $8000
    ld  bc, moveend-moveit
    ldir
aftermove:
    pop hl
    ld  a,(hl)
    inc hl
    ld  d,(hl)
    inc hl
    ld  c,(hl)
    inc hl
    ld  b,(hl)
    ld  e,$00
    push bc
    pop hl
    call $8000
;check for plus3
    ld  a,(useplus3)
    cp  $01
    jr  nz, notplus3_3
;go back to special paging
    ld  a,&03
    ld  bc,&1ffd
    out (c),a
notplus3_3
    ld  a,($2800)
    cp  $97	; is it super sah ?
    jp  z, noneed
    ; back screen
    ld  hl, menustore
    ld  de, $2800
    ld  bc, 512
    ldir
noneed:
    call menu_draw
    ; back LD HL,nn
    ld  a,$21
    ld  (keybrd),a

keystill:
    xor a
    in  a,(&fe)
    cpl
    and %00011111
    jp  nz, keystill

    ex	af,af'
    exx
    pop	hl
    pop	de
    pop	bc
    pop	af
    ex	af,af'
    exx
    pop	iy
    pop	ix
    pop hl
    pop	de
    pop	bc
    pop	af
    ld	sp,(oldsp)
    ret

oldsp:
    dw	$0000

; the moveit routine - divide version
moveit:
    ld  bc,&7ffd
    out (c),a
    ld  b,h
    ld  c,l
    ex  de,hl
    ld  a,(hl)
    inc hl
    ld  d,(hl)
    ld  e,a
    inc hl
    inc hl
    inc hl
    ldir
    ld  bc,&7ffd
    ld  a,$1f
    out (c),a
    ret    
moveend:

; movit - Plus3 version
movep3len equ ($8000+(moveendp3-moveitp3)-2)
moveitp3:
    ld (movep3len),hl

    ld  bc,&7ffd
    out (c),a
    ld  b,h
    ld  c,l
    ex  de,hl
    ld  de,$9000
    ldir

; page in page4 - rom + $2000
    ld  bc,&7ffd
    ld  a,$1c
    out (c),a

    ld bc,(movep3len)
    ld hl,$9000
    ld  e,(hl)
    inc hl
    ld  a,(hl)
    add a, $c0
    ld  d,a
    inc hl
    inc hl
    inc hl
    ldir

    ld  bc,&7ffd
    ld  a,$1f
    out (c),a
    ret    
    dw $0000
moveendp3:

divideout:
;check for plus3
    ld  a,(useplus3)
    cp  $01
    jr  nz, notplus3_4
    ld	a, $00
    ld	bc, $1ffd
    out	(c), a
    ld	a, $07
    ld	bc, $7ffd
    out	(c), a
    jp  $0000
; exit to BASIC with current firmware copied to mapram
notplus3_4:
    cp  $02
    jr  z, mb02out
    ld  c, &e3
    ld  a, %10000011
    out (c),a
    ld  hl, $0000
    ld  de, $2000
    ld  bc, $2000
    ldir
    ld  c, &e3
    ld  a, %01000000
    out (c),a
    jp  $0000
mb02out:
; Go back to basic prompt of MB02
    ld c, &17
    ld a, %01000000
    out (c), a
    jp  $3978

cursorson:
    defb $00
throton:
    defb $00
currhalf:
    defb $00
useplus3:
    defb $00

    ALIGN 256
gal_font:
    incbin "OUTPUT.BIN"

oldmenu:
    defb "                          DIVIDE"
    defb " PLEASE CHOOSE A GAME :         "
    defb "                                "
    defb "    1. GALAKTICKI RAT           "
    defb "    2. JUMPING JACK             "
    defb "    3. SUPER CRUISER            "
    defb "    4. TETRIS                   "
    defb "    5. BLADE ALLEY              "
    defb "    6. DIJAMANTSKI RUDNIK       "
    defb "    7. ZAMAK                    "
    defb "    8. INSPEKTOR SPIRIDON       "
    defb "    9. SUPER SAH                "
    defb "    ------------------------    "  
    defb "    0. EXIT BACK TO SPECTRUM    "
    defb "                                "
    defb " TYPE  RUN  WHEN THE GAME LOADS "

plus3line:
    defb "                          PLUS/3"
mb02line:
    defb "                           MB-02"

oldtable:
; first row - 1 2 3 4 5
    defb %11000, &c0
    defw 2231
    defb %11000, &d0
    defw 1884
    defb %11000, &e0
    defw 2543
    defb %11000, &f0
    defw 2685
    defb %11001, &c0
    defw 1855
; these in reversed order - 9 8 7 6
    defb %11011, &e0
    defw 5766
    defb %11011, &c0
    defw 4915
    defb %11001, &e0
    defw 3008
    defb %11001, &d0
    defw 2723

endofsave:

menustore:
    defs 512

    ALIGN 4

    ; Table of addresses for each Gal character on the display
char_addrs:
    defs 512*4

endofall:
    defb $66, $66, $66


