;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                   ARCLDS.ASM                    
;                                                 
;           Archive List and Date Stamp           
;

		jumps				;Automatic jump sizing

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

		.386				;Enable 32-bit operands

;Boolean constants
False		equ	0
True		equ	1

ProgramSize	equ	16384			;Memory to retain for program
FileNameMax	equ	80			;Max length for short names
LongFileNameMax	equ	255			;Max length for long names
BufferMax	equ	1024			;Size for data buffer
MaxNesting	equ	64			;Maximum directory nesting
DirAttrib	equ	0010h			;Attribute for directories
kbEsc		equ	011Bh			;Escape scan code
DirSep		equ	'\'			;Path component separator

;Long name search record
LongSearchRec	struc
lsAttr		dd	?
lsCreateDate	dd	?, ?
lsAccessDate	dd	?, ?
lsModifyDate	dd	?, ?
lsSizeHi	dd	?
lsSize		dd	?
lsReserved	db	8 dup (?)
lsName		db	260 dup (?)
lsShortName	db	14 dup (?)
LongSearchRec	ends

Main:		mov	ax, ds:[0006h]
		cmp	ax, ProgramSize
		jbe	@01
		mov	bx, ProgramSize / 16
		mov	ah, 4Ah
		int	21h
		mov	sp, ProgramSize
		xor	ax, ax
		push	ax
@01:		mov	di, Offset DataStart
		mov	cx, DataEnd - DataStart
		xor	al, al
		cld
		rep	stosb
		mov	dx, Offset Hello
		mov	ah, 9
		int	21h
		mov	bl, 1
		mov	si, 0081h
@19:		lodsb
		cmp	al, ' '
		je	@19
		cmp	al, 9
		je	@19
		cmp	al, 13
		je	@21
		cmp	al, '-'
		je	@20
		cmp	al, '/'
		jne	@21
@20:		inc	bl
@42:		lodsb
		cmp	al, ' '
		je	@19
		cmp	al, 9
		je	@19
		call	UpCase
		cmp	al, 'D'
		jne	@57
		mov	SkipDirs, True
		jmp	@42
@57:		cmp	al, 'G'
		jne	@49
		mov	GrandTotal, True
		jmp	@42
@49:		cmp	al, 'L'
		jne	@56
		mov	LongLines, True
		jmp	@42
@56:		cmp	al, 'P'
		jne	@50
		mov	Pause, True
		jmp	@42
@50:		cmp	al, 'S'
		jne	@41
		mov	StampDate, True
		jmp	@42
@41:		cmp	al, 'V'
		jne	@42
		mov	MultiVolumes, True
		jmp	@42
@21:		mov	di, Offset SearchPar
		mov	cx, LongFileNameMax
		call	ParamStr
		cmp	bh, bl
		je	@05
		mov	dx, Offset Usage
		mov	ah, 9
		int	21h
		call	PrintLineFeed
		jmp	@02
@05:		xor	al, al
		cmp	Pause, al
		je	@32
		mov	LineCount, al
		push	es
		mov	ax, 0040h
		mov	es, ax
		mov	al, es:[0084h]
		pop	es
		inc	al
		mov	ScreenHeight, al
		push	ds
		pop	es
		mov	di, Offset ClrLine
		cld
		mov	al, 0Dh
		stosb
		mov	al, ' '
		mov	cx, 79
		rep	stosb
		mov	al, 0Dh
		stosb
@32:		mov	si, Offset SearchPar
		mov	di, Offset ReadPath
		xor	bx, bx
		xor	bp, bp
		call	FSplit
		mov	ArchFile, -1
		mov	dx, Offset SearchPar
		mov	cx, 27h
		call	FindFirst
		jnc	@06
		jmp	@11
@06:		mov	si, FileNameOffs
		xor	di, di
		mov	bx, Offset ReadFName
		mov	bp, Offset ReadExt
		call	FSplit
		mov	si, Offset ReadPath
		mov	di, Offset SearchPar
		push	di
		mov	cx, LongFileNameMax
		clc
		call	StrCopy
		mov	si, FileNameOffs
		stc
		call	StrCopy
		call	ArchType
		pop	si
		jne	@14
		jmp	@47
@14:		mov	di, Offset OrigArchName
		mov	cx, LongFileNameMax
		stc
		call	StrCopy
		xor	eax, eax
		mov	Error, al
		mov	ArchOpened, al
		mov	EndOfFile, al
		mov	ContFromPrev, al
		mov	AltVolNumbering, al
		mov	ArchDateTime, eax
		mov	FileNum, eax
		mov	DirNum, eax
		mov	FileCount, eax
		mov	DirCount, eax
		mov	ArchCount, eax
		mov	dword ptr ThisVolPack[0], eax
		mov	dword ptr ThisVolPack[4], eax
		mov	dword ptr ArchOrigAll[0], eax
		mov	dword ptr ArchOrigAll[4], eax
		mov	dword ptr ArchPackAll[0], eax
		mov	dword ptr ArchPackAll[4], eax
		inc	al
		mov	FirstVolume, al
		mov	PrintHeader, al
		mov	CheckContName, al
		mov	HundredsInExt, al
@08:		mov	OrigArchAttr, -1
		xor	al, al
		call	OpenArch
		jnc	@15
		mov	ContOnNext, False
		jmp	@09
@15:		mov	al, True
		mov	Found, al
		mov	ArchOpened, al
		inc	ArchCount
		xor	al, al
		cmp	FeedLine, al
		je	@16
		cmp	FirstVolume, al
		je	@16
		cmp	StampDate, al
		jne	@16
		mov	dx, Offset DummyStr
		stc
		call	PrintStr
@16:		mov	FeedLine, True
		cmp	FirstVolume, False
		je	@43
		inc	TotalArchNum
		mov	dx, Offset Listing
		cmp	StampDate, False
		je	@30
		mov	dx, Offset Stamping
@30:		clc
		call	PrintStr
		mov	dx, Offset Archive
		clc
		call	PrintStr
		mov	dx, Offset Colon
		clc
		call	PrintStr
		mov	dx, Offset SearchPar
		stc
		call	PrintStr
@43:		xor	ax, ax
		mov	NoAttribs, al
		mov	NoPackSize, al
		mov	ContOnNext, al
		inc	al
		mov	First, al
@07:		call	Escape
		cmp	EscHit, False
		je	@31
		jmp	@09
@31:		xor	al, al
		mov	byte ptr FileName[0], al
		mov	IsDirectory, al
		call	NextProg
		jnc	@26
		jmp	@09
@26:		cmp	byte ptr FileName[0], 0
		jne	@27
		mov	First, False
		jmp	@07
@27:		mov	DateTime, ecx
		mov	Attrib, edx
		cmp	ContFromPrev, False
		jne	@45
		mov	dword ptr OrigSize[0], eax
		mov	dword ptr OrigSize[4], ebx
		mov	dword ptr PackSize[0], esi
		mov	dword ptr PackSize[4], edi
		jmp	@46
@45:		cmp	CheckContName, False
		je	@52
		push	si
		push	di
		mov	si, Offset FileName
		mov	di, Offset PrevFileName
		call	StrComp
		pop	di
		pop	si
		je	@52
		mov	Error, True
		jmp	@09
@52:		cmp	SumOrigSizes, False
		je	@48
		add	dword ptr OrigSize[0], eax
		adc	dword ptr OrigSize[4], ebx
@48:		add	dword ptr PackSize[0], esi
		adc	dword ptr PackSize[4], edi
@46:		cmp	ContOnNext, False
		je	@51
		cmp	CheckContName, False
		je	@51
		mov	si, Offset FileName
		mov	di, Offset PrevFileName
		mov	cx, LongFileNameMax
		stc
		call	StrCopy
@51:		xor	al, al
		mov	First, al
		cmp	ContOnNext, al
		je	@53
@33:		jmp	@07
@53:		cmp	IsDirectory, al
		je	@37
		inc	DirCount
		jmp	@38
@37:		inc	FileCount
@38:		cmp	IsDirectory, al
		je	@35
		cmp	SkipDirs, al
		jne	@33
@35:		cmp	StampDate, al
		jne	@22
		cmp	PrintHeader, al
		je	@23
		mov	PrintHeader, al
		call	PrintTitle
@23:		call	ListFile
		mov	eax, dword ptr OrigSize[0]
		mov	ebx, dword ptr OrigSize[4]
		add	dword ptr ArchOrigAll[0], eax
		adc	dword ptr ArchOrigAll[4], ebx
		cmp	NoPackSize, False
		jne	@22
		mov	eax, dword ptr PackSize[0]
		mov	ebx, dword ptr PackSize[4]
		add	dword ptr ArchPackAll[0], eax
		adc	dword ptr ArchPackAll[4], ebx
@22:		mov	ecx, DateTime
		cmp	ecx, ArchDateTime
		jbe	@17
		mov	ArchDateTime, ecx
@17:		jmp	@07
@09:		mov	eax, dword ptr ThisVolPack[0]
		mov	edx, dword ptr ThisVolPack[4]
		add	dword ptr ArchPackAll[0], eax
		adc	dword ptr ArchPackAll[4], edx
		cmp	StampDate, False
		jne	@24
		cmp	ContOnNext, False
		jne	@24
		mov	eax, FileCount
		or	eax, DirCount
		je	@24
		mov	dx, Offset Separator
		stc
		call	PrintStr
@24:		cmp	Error, False
		je	@12
		mov	dx, Offset TwoSpaces
		clc
		call	PrintStr
		mov	dx, Offset SearchPar
		clc
		call	PrintStr
		mov	dx, Offset NotValid
		mov	eax, FileCount
		add	eax, DirCount
		or	eax, eax
		je	@36
		mov	dx, Offset Damaged
@36:		clc
		call	PrintStr
		mov	dx, Offset ArchExt
		clc
		call	PrintStr
		mov	dx, Offset Archive
		stc
		call	PrintStr
		jmp	@13
@12:		mov	eax, FileCount
		mov	ebx, DirCount
		mov	FileNum, eax
		mov	DirNum, ebx
		cmp	EscHit, False
		je	@29
@34:		jmp	@25
@29:		xor	cl, cl
		cmp	StampDate, cl
		jne	@34
		cmp	ContOnNext, cl
		jne	@34
		or	ebx, eax
		jne	@28
		cmp	ArchOpened, cl
		je	@34
		mov	dx, Offset DummyStr
		stc
		call	PrintStr
		mov	dx, Offset NoFiles
		stc
		call	PrintStr
		jmp	@25
@28:		mov	NoPackSize, cl
		call	CountFiles
		mov	eax, dword ptr ArchOrigAll[0]
		mov	ebx, dword ptr ArchOrigAll[4]
		mov	ecx, ArchDateTime
		mov	esi, dword ptr ArchPackAll[0]
		mov	edi, dword ptr ArchPackAll[4]
		mov	edx, 5A5A5A5Ah
		call	StoreFileData
		cmp	GrandTotal, False
		je	@40
		add	dword ptr TotalOrigSize[0], eax
		adc	dword ptr TotalOrigSize[4], ebx
		cmp	ecx, TotalDateTime
		jbe	@18
		mov	TotalDateTime, ecx
@18:		add	dword ptr TotalPackSize[0], esi
		adc	dword ptr TotalPackSize[4], edi
		mov	eax, FileNum
		add	TotalFileNum, eax
		mov	eax, DirNum
		add	TotalDirNum, eax
@40:		call	ListFile
@25:		mov	eax, FileNum
		or	eax, DirNum
		je	@13
		xor	al, al
		cmp	StampDate, al
		je	@13
		cmp	MultiVolumes, al
		jne	@13
		mov	al, 1
		call	OpenArch
		call	StampArch
@13:		call	CloseArch
@47:		xor	al, al
		cmp	EscHit, al
		jne	@11
		cmp	ContOnNext, al
		je	@44
		call	NextVolProg
		jc	@44
		jmp	@08
@44:		xor	eax, eax
		cmp	Error, al
		jne	@54
		cmp	StampDate, al
		je	@54
		cmp	MultiVolumes, al
		je	@54
		cmp	ArchCount, eax
		je	@54
		mov	FirstVolume, True
		mov	eax, ArchCount
		mov	ArchNum, eax
		mov	si, Offset OrigArchName
		mov	di, Offset SearchPar
		mov	cx, LongFileNameMax
		stc
		call	StrCopy
@55:		mov	al, 1
		call	OpenArch
		jc	@54
		call	StampArch
		call	CloseArch
		mov	OrigArchAttr, -1
		call	NextVolProg
		jc	@54
		dec	ArchNum
		jne	@55
@54:		call	FindNext
		jc	@11
		jmp	@06
@11:		call	FindClose
		cmp	Found, False
		je	@03
		cmp	EscHit, False
		je	@61
		mov	dx, Offset DummyStr
		stc
		call	PrintStr
		mov	dx, Offset Aborted
		mov	ah, 9
		int	21h
		call	PrintLineFeed
		jmp	@02
@61:		call	PrintTotal
		jmp	@02
@03:		mov	dx, Offset NoArchives
		mov	ah, 9
		int	21h
		call	PrintLineFeed
		mov	al, 1
		jmp	@04
@02:		xor	al, al
@04:		mov	ah, 4Ch
		int	21h

;Start search, find first file
;  Input : CX: attributes allowed
;          DS:DX: file name pattern to search for
;  Output: CF: when not 0, an error occurred
;          AX: error code
FindFirst:	xor	ch, ch
		mov	si, 1
		push	ds
		pop	es
		mov	di, Offset LFNSearchRec
		mov	ax, 714Eh
		stc
		int	21h
		jnc	@02_FindFirst
		cmp	ax, 7100h
		stc
		jne	@01_FindFirst
		mov	ah, 4Eh
		int	21h
		mov	FilenameOffs, 009Eh
		jmp	@01_FindFirst
@02_FindFirst:	mov	LFNSearchHandle, ax
		mov	FileNameOffs, Offset LFNSearchRec.lsName
@01_FindFirst:	retn

;Continue search, find next file
;  Output: CF: when not 0, an error occurred
;          AX: error code
FindNext:	mov	bx, LFNSearchHandle
		mov	si, 1
		push	ds
		pop	es
		mov	di, Offset LFNSearchRec
		mov	ax, 714Fh
		stc
		int	21h
		jnc	@01_FindNext
		cmp	ax, 7100h
		stc
		jne	@01_FindNext
		mov	ah, 4Fh
		int	21h
@01_FindNext:	retn

;Terminate search, close search handle
FindClose:	mov	bx, LFNSearchHandle
		mov	ax, 71A1h
		int	21h
		retn

;Open file
;  Input : DS:DX: file name
;          AL: when 0, open file for read only; when 1, open file for write
;              only; when 2, open file for read and write
;  Output: CF: when not 0, an error occurred
;          AX: if an error occurred, error code; if no error, file handle
OpenFile:	mov	ah, 40h
		mov	si, 0001h
		or	al, al
		je	@01_OpenFile
		mov	ah, 20h
		cmp	al, 1
		jne	@01_OpenFile
		mov	si, 0012h
@01_OpenFile:	mov	bl, al
		xor	bh, bh
		xchg	si, dx
		xor	di, di
		push	cx
		xor	cx, cx
		mov	ax, 716Ch
		stc
		int	21h
		pop	cx
		jnc	@02_OpenFile
		cmp	ax, 7100h
		je	@03_OpenFile
		cmp	ax, 5
		stc
		jne	@02_OpenFile
		and	bl, 0Fh
		xor	cx, cx
		stc
		mov	ax, 716Ch
		int	21h
		jmp	@02_OpenFile
@03_OpenFile:	mov	dx, si
		mov	al, bl
		mov	ah, 3Ch
		cmp	al, 1
		je	@04_OpenFile
		mov	ah, 3Dh
		xor	cx, cx
@04_OpenFile:	push	ax
		int	21h
		pop	bx
		jnc	@02_OpenFile
		cmp	ax, 5
		stc
		jne	@02_OpenFile
		mov	ax, bx
		and	al, 0Fh
		int	21h
@02_OpenFile:	retn

;Close file
;  Input : BX: file handle
CloseFile:	mov	ah, 3Eh
		int	21h
		retn

;Fill file data with generated values
;  Input : EBX:EAX: original file size
;          EDI:ESI: packed file size
;          ECX: date stamp
;          EDX: attributes
StoreFileData:	mov	dword ptr OrigSize[0], eax
		mov	dword ptr OrigSize[4], ebx
		mov	DateTime, ecx
		mov	dword ptr PackSize[0], esi
		mov	dword ptr PackSize[4], edi
		mov	Attrib, edx
		retn

;Create a line, displaying total number of files and directories
CountFiles:	mov	eax, FileNum
		xor	edx, edx
		mov	bx, 10
		mov	cx, dx
		call	NumStr
		mov	cx, FileNameMax
		mov	si, dx
		mov	di, Offset FileName
		clc
		call	StrPartCopy
		mov	si, Offset File
		clc
		call	StrPartCopy
		cmp	FileNum, 1
		je	@01_CountFiles
		mov	al, 's'
		stosb
@01_CountFiles:	xor	eax, eax
		cmp	SkipDirs, al
		jne	@02_CountFiles
		cmp	DirNum, eax
		je	@02_CountFiles
		mov	si, Offset Conjunctive
		clc
		call	StrPartCopy
		push	cx
		mov	eax, DirNum
		xor	edx, edx
		mov	bx, 10
		mov	cx, dx
		call	NumStr
		pop	cx
		mov	si, dx
		clc
		call	StrPartCopy
		mov	si, Offset Directory
		clc
		call	StrPartCopy
		mov	si, Offset YSingular
		cmp	DirNum, 1
		je	@03_CountFiles
		mov	si, Offset YPlural
@03_CountFiles:	clc
		call	StrPartCopy
@02_CountFiles:	xor	al, al
		stosb
		retn

;Display list header
PrintTitle:	mov	dx, Offset DummyStr
		stc
		call	PrintStr
		mov	dx, Offset ListTitle
		stc
		call	PrintStr
		mov	dx, Offset Separator
		stc
		jmp	PrintStr

;Display grand total
PrintTotal:	xor	al, al
		cmp	GrandTotal, al
		je	@01_PrintTotal
		cmp	StampDate, al
		jne	@01_PrintTotal
		mov	dx, Offset DummyStr
		stc
		call	PrintStr
		mov	dx, Offset TotalTitle
		clc
		call	PrintStr
		mov	eax, TotalArchNum
		xor	edx, edx
		mov	bx, 10
		mov	cx, dx
		call	NumStr
		clc
		call	PrintStr
		mov	dx, Offset Archive
		clc
		call	PrintStr
		mov	dx, Offset DummyStr
		cmp	TotalArchNum, 1
		je	@02_PrintTotal
		mov	dx, Offset Plural
@02_PrintTotal:	stc
		call	PrintStr
		call	PrintTitle
		mov	eax, TotalFileNum
		mov	FileNum, eax
		mov	eax, TotalDirNum
		mov	DirNum, eax
		call	CountFiles
		mov	eax, dword ptr TotalOrigSize[0]
		mov	ebx, dword ptr TotalOrigSize[4]
		mov	ecx, TotalDateTime
		mov	esi, dword ptr TotalPackSize[0]
		mov	edi, dword ptr TotalPackSize[4]
		mov	edx, 5A5A5A5Ah
		call	StoreFileData
		call	ListFile
@01_PrintTotal:	retn

;Feed one line
PrintLineFeed:	mov	dx, Offset LineFeed
		mov	ah, 9
		int	21h
		retn

;Check press of Escape key
Escape:		mov	ah, 1
		int	16h
		mov	ax, 0
		je	@01_Escape
		xor	ah, ah
		int	16h
		cmp	ax, kbEsc
		jne	@01_Escape
		mov	EscHit, True
@01_Escape:	retn

;Get or set file attributes
;  Input : AL: when 0, file attributes are read; when 1, file attributes are
;              are written
;          DS:DX: file name
;  Output: CF: when not 0, an error occurred
FileAttr:	push	bx
		mov	bl, al
		mov	ax, 7143h
		stc
		int	21h
		pop	bx
		jnc	@01_FileAttr
		cmp	ax, 7100h
		stc
		jne	@01_FileAttr
		mov	ah, 43h
		int	21h
@01_FileAttr:	retn

;Open archive file
;  Input : AL: when 0, open file for reading through; otherwise for stamping
;  Output: CF: when not 0, an error occurred, or the file is not a valid
;              archive, or multi-volume mode is enabled and the file is not
;              the first volume of a volume set
OpenArch:	push	dx
		cmp	ArchFile, -1
		jne	@05_OpenArch
		call	CloseArch
		jc	@01_OpenArch
@05_OpenArch:	mov	dx, Offset SearchPar
@04_OpenArch:	push	ax
		or	al, al
		je	@02_OpenArch
		mov	al, 2
@02_OpenArch:	call	OpenFile
		pop	dx
		jnc	@03_OpenArch
		cmp	ax, 5
		stc
		jne	@01_OpenArch
		or	dl, dl
		stc
		je	@01_OpenArch
		cmp	OrigArchAttr, -1
		stc
		jne	@01_OpenArch
		mov	dx, Offset SearchPar
		xor	al, al
		call	FileAttr
		jc	@01_OpenArch
		push	cx
		and	cl, 0FEh
		mov	al, 1
		call	FileAttr
		pop	cx
		jc	@01_OpenArch
		mov	OrigArchAttr, cx
		mov	ax, dx
		jmp	@04_OpenArch
@03_OpenArch:	mov	ArchFile, ax
		or	dl, dl
		jne	@01_OpenArch
		xor	eax, eax
		mov	ArchPos, eax
		cmp	MultiVolumes, False
		clc
		je	@01_OpenArch
		cmp	FirstVolume, False
		clc
		je	@01_OpenArch
		call	FirstVolProg
		jnc	@01_OpenArch
		call	CloseArch
		stc
@01_OpenArch:	pop	dx
		retn

;Close archive file
CloseArch:	mov	bx, ArchFile
		cmp	bx, -1
		je	@01_CloseArch
		call	CloseFile
		jc	@01_CloseArch
		mov	ArchFile, -1
		push	cx
		mov	cx, OrigArchAttr
		cmp	cx, -1
		je	@02_CloseArch
		push	dx
		mov	dx, Offset SearchPar
		mov	al, 1
		call	FileAttr
		pop	dx
		jnc	@02_CloseArch
@02_CloseArch:	pop	cx
@01_CloseArch:	retn

;Change date stamp of archive file
StampArch:	mov	cx, word ptr ArchDateTime[0]
		mov	dx, word ptr ArchDateTime[2]
		mov	ax, cx
		or	ax, dx
		je	@01_StampArch
		mov	bx, ArchFile
		mov	ax, 5701h
		int	21h
@01_StampArch:	retn

;Determine archive type from extension of file name
;  Output: ZF: when 0, the archive is of known type; otherwise unknown
ArchType:	cmp	byte ptr ReadExt[0], '.'
		jne	@04_ArchType
		mov	si, Offset ReadExt[1]
		push	si
		mov	cx, 3
		xor	ah, ah
		cld
@06_ArchType:	lodsb
		cmp	al, '0'
		jb	@05_ArchType
		cmp	al, '9'
		ja	@05_ArchType
		mov	al, '#'
		inc	ah
@05_ArchType:	call	UpCase
		mov	byte ptr [si][-1], al
		loop	@06_ArchType
		pop	si
		mov	di, Offset ArchExts
		mov	cx, (NextVolProgs - NextProgs) / word
		xor	bx, bx
		mov	dx, bx
@02_ArchType:	inc	dx
		push	cx
		push	si
		push	di
		mov	cx, 3
		cld
		repe	cmpsb
		pop	di
		pop	si
		pop	cx
		je	@03_ArchType
		add	bx, 2
		add	di, 3
		loop	@02_ArchType
@04_ArchType:	xor	dx, dx
		jmp	@01_ArchType
@03_ArchType:	cmp	ah, 0
		je	@07_ArchType
		cmp	MultiVolumes, False
		jne	@04_ArchType
		sub	di, 3
@07_ArchType:	mov	si, di
		mov	di, Offset ArchExt
		mov	cx, 3
		cld
		rep	movsb
		lodsb
		mov	VolBaseChar, al
		xor	al, al
		stosb
		mov	ax, NextProgs[bx]
		mov	NextProg, ax
		mov	ax, NextVolProgs[bx]
		mov	NextVolProg, ax
		mov	ax, FirstVolProgs[bx]
		mov	FirstVolProg, ax
@01_ArchType:	or	dx, dx
		retn

;"Increase" a digit or letter and round it if it overflows
;  Input : BL: maximum value for character
;          BH: minimum value for character
;  Output: CF and ZF: if both are 0, an overflow occurred
IncChar:	lodsb
		inc	al
		cmp	al, bl
		jbe	@01_IncChar
		mov	al, bh
@01_IncChar:	stosb
		retn

;Compute offset of the first character of extension in file name, assuming
;  that the extension is exactly 3 characters long
VolExtOffs:	cmp	FirstVolume, False
		je	@01_VolExtOffs
		push	si
		push	ax
		mov	si, Offset SearchPar
		call	StrLen
		add	si, ax
		sub	si, 3
		mov	ArchExtOffs, si
		pop	ax
		pop	si
@01_VolExtOffs: retn

;Generate file name for next volume, "increasing" extension
;  Input : AL: when 0, the last character of the extension in the file name of
;              the second volume is "0"; when 1, "1"
;          AH: when 0, the entry of the same file, spanned across volumes,
;              contains the original file size; otherwise the length of
;              original data compressed into this volume, in which case these
;              sizes must be summed from all volumes
;  Output: CF: 0, there is a next volume
NextVol:	call	VolExtOffs
		cmp	FirstVolume, False
		je	@01_NextVol
		mov	SumOrigSizes, ah
		push	ax
		mov	di, ArchExtOffs
		cld
		mov	al, VolBaseChar
		stosb
		mov	al, '0'
		stosb
		pop	ax
		add	al, '0'
		stosb
		jmp	@02_NextVol
@01_NextVol:	mov	si, ArchExtOffs
		add	si, 2
		mov	di, si
		std
		mov	bx, '09'
		call	IncChar
		jbe	@02_NextVol
		call	IncChar
		jbe	@02_NextVol
		inc	bh
		cmp	HundredsInExt, False
		jne	@03_NextVol
		mov	bx, 'AZ'
@03_NextVol:	call	IncChar
@02_NextVol:	mov	FirstVolume, False
		clc
		retn

;Dummy "next volume" routine
;  Output: CF: 1, there is no next volume
NoNextVol:	stc
		retn

;Dummy "first volume" routine
;  Output: CF: 0, this volume is the first volume of a volume set
NoFirstVol:	clc
		retn

;Generate file name for next volume, "increasing" end of file name
;  Output: CF: 0, there is a next volume
AltNextVol:	call	VolExtOffs
		mov	si, ArchExtOffs
		sub	si, 2
		mov	di, si
		std
@02_AltNextVol:	lodsb
		inc	si
		cmp	al, '0'
		jb	@01_AltNextVol
		cmp	al, '9'
		ja	@01_AltNextVol
		mov	bx, '09'
		call	IncChar
		ja	@02_AltNextVol
		jmp	@03_AltNextVol
@01_AltNextVol:	mov	cx, si
		mov	si, ArchExtOffs
		add	si, 3
		mov	di, si
		inc	di
		sub	cx, si
		neg	cx
		rep	movsb
		mov	al, '1'
		stosb
@03_AltNextVol:	cmp	FirstVolume, False
		je	@04_AltNextVol
		mov	dx, Offset SearchPar
		xor	al, al
		call	FileAttr
		jnc	@04_AltNextVol
		mov	AltVolNumbering, False
		mov	si, Offset OrigArchName
		mov	di, Offset SearchPar
		mov	cx, LongFileNameMax
		stc
		call	StrCopy
		jmp	NextVol
@04_AltNextVol:	clc
		mov	FirstVolume, False
		retn

;Change the complete archive file name
;  Input : DS:BX: new archive file name
ChangeName:	mov	si, Offset ReadPath
		mov	di, Offset SearchPar
		jmp	AddToPath

;Display data of current file in the archive
ListFile:	mov	eax, dword ptr OrigSize[0]
		mov	edx, dword ptr OrigSize[4]
		call	IndentNum
		cmp	NoPackSize, False
		je	@01_ListFile
		mov	dx, Offset TenSpaces
		clc
		call	PrintStr
		mov	dx, Offset FiveSpaces
		clc
		call	PrintStr
		jmp	@02_ListFile
@01_ListFile:	mov	eax, dword ptr PackSize[0]
		mov	edx, dword ptr PackSize[4]
		call	IndentNum
		call	Ratio
@02_ListFile:	call	UnpackDate
		mov	dx, Offset SixSpaces
		cmp	Attrib, 5A5A5A5Ah
		je	@03_ListFile
		call	MakeAttr
		mov	dx, Offset AttribStr
@03_ListFile:	clc
		call	PrintStr
		call	ProcName
		mov	bx, dx
		mov	cx, 30
		call	MakeName
		stc
		jmp	PrintStr

;Process file name; convert forward slashes to backslashes; for directories,
;  append a backslash to the directory name
ProcName:	mov	si, Offset FileName
		mov	dx, si
		push	si
		cld
@02_ProcName:	lodsb
		or	al, al
		je	@01_ProcName
		cmp	al, '/'
		jne	@02_ProcName
		mov	byte ptr [si][-1], DirSep
		jmp	@02_ProcName
@01_ProcName:	pop	si
		cmp	IsDirectory, False
		je	@03_ProcName
		mov	si, dx
		call	StrLen
		add	si, ax
		mov	ax, DirSep
		mov	word ptr [si], ax
@03_ProcName:	retn

;Create a string from file attributes
;  Input : ES:DI: pointer to put the string to
MakeAttr:	mov	ah, byte ptr Attrib
		mov	dl, '-'
		xor	bh, bh
		cmp	NoAttribs, bh
		je	@04_MakeAttr
		and	ah, DirAttrib
		mov	dl, ' '
@04_MakeAttr:	mov	si, Offset AttribDefs
		mov	cx, 8
		cld
@03_MakeAttr:	lodsb
		mov	bl, al
		lodsb
		shl	ah, 1
		jc	@01_MakeAttr
		or	al, al
		je	@02_MakeAttr
		mov	al, dl
@01_MakeAttr:	or	al, al
		je	@02_MakeAttr
		mov	byte ptr AttribStr[bx], al
@02_MakeAttr:	loop	@03_MakeAttr
		mov	word ptr AttribStr[5], ' '
		retn

;Display decimal number, padded with leading spaces to 9 characters, and a
;  space appended
;  Input : EDX:EAX: number
IndentNum:	mov	bx, 10
		mov	cx, 0920h
		call	NumStr
		clc
		call	PrintStr
		cmp	cl, 9
		ja	@01_IndentNum
		mov	dl, ' '
		mov	ah, 2
		int	21h
@01_IndentNum:	retn

;Create a string from compression ratio
;  Input : ES:DI: pointer to put the string to
Ratio:		mov	ecx, dword ptr OrigSize[0]
		mov	ebx, dword ptr OrigSize[2]
		mov	eax, ecx
		or	eax, ebx
		jne	@01_Ratio
		mov	eax, 100
		jmp	@02_Ratio
@01_Ratio:	mov	eax, dword ptr PackSize[0]
		mov	edx, dword ptr PackSize[4]
		mov	ecx, 100
		xor	ebx, ebx
		cmp	edx, 0FFFFh / 200
		ja	@03_Ratio
		call	LongMul
		mov	ecx, dword ptr OrigSize[0]
		mov	ebx, dword ptr OrigSize[4]
		call	LongDiv
		jmp	@04_Ratio
@03_Ratio:	mov	eax, dword ptr OrigSize[0]
		mov	edx, dword ptr OrigSize[4]
		call	LongDiv
		mov	ecx, eax
		mov	ebx, edx
		mov	eax, dword ptr PackSize[0]
		mov	edx, dword ptr PackSize[4]
		call	LongDiv
@04_Ratio:	or	edx, edx
		jne	@05_Ratio
		cmp	eax, 999
		jbe	@02_Ratio
@05_Ratio:	mov	eax, 999
@02_Ratio:	xor	edx, edx
		mov	bx, 10
		mov	cx, 0320h
		call	NumStr
		clc
		call	PrintStr
		mov	dx, Offset Percent
		clc
		call	PrintStr
		retn

;Compress stand alone date stamp components to DOS-style packed date stamp
PackDate:	mov	si, Offset Year
		lodsw
		sub	ax, 1980
		mov	cl, 9
		shl	ax, cl
		xchg	ax, dx
		lodsb
		xor	ah, ah
		mov	cl, 5
		shl	ax, cl
		add	dx, ax
		lodsb
		xor	ah, ah
		add	dx, ax
		lodsb
		mov	cl, 11
		shl	ax, cl
		xchg	ax, bx
		lodsb
		xor	ah, ah
		mov	cl, 5
		shl	ax, cl
		add	bx, ax
		lodsb
		xor	ah, ah
		shr	ax, 1
		add	ax, bx
		mov	di, Offset DateTime
		stosw
		xchg	ax, dx
		stosw
		retn

;Uncompress DOS-style packed date stamp to stand alone date stamp components
;  and display those
UnpackDate:	mov	bx, word ptr DateTime[0]
		mov	dx, word ptr DateTime[2]
		mov	di, Offset Year
		mov	ax, dx
		mov	cl, 9
		shr	ax, cl
		add	ax, 1980
		stosw
		mov	ax, dx
		mov	cl, 5
		shr	ax, cl
		and	al, 15
		stosb
		mov	ax, dx
		and	al, 31
		stosb
		mov	ax, bx
		mov	cl, 11
		shr	ax, cl
		stosb
		mov	ax, bx
		mov	cl, 5
		shr	ax, cl
		and	al, 63
		stosb
		mov	ax, bx
		and	al, 31
		shl	al, 1
		stosb
		mov	al, Month
		mov	dl, '-'
		call	DisplayNum
		mov	al, Day
		mov	dl, '-'
		call	DisplayNum
		mov	ax, Year
		xor	dx, dx
		mov	bx, 100
		div	bx
		mov	ax, dx
		mov	dl, ' '
		call	DisplayNum
		mov	al, Hours
		mov	dl, ':'
		call	DisplayNum
		mov	al, Minutes
		mov	dl, ':'
		call	DisplayNum
		mov	al, Seconds
		mov	dl, ' '
		call	DisplayNum
		retn

;Display single-byte number, padded with leading zeros to 2 characters
;  Input : AL: number
;          DL: when not 0, prepend this character to number
DisplayNum:	push	dx
		and	eax, 000000FFh
		xor	edx, edx
		mov	bx, 10
		mov	cx, 0230h
		call	NumStr
		clc
		call	PrintStr
		pop	dx
		or	dl, dl
		je	@01_DisplayNum
		mov	ah, 2
		int	21h
@01_DisplayNum:	retn

;Convert number to string
;  Input : EDX:EAX: number
;  Output: DS:DX: resulting string
NumStr:		push	si
		push	di
		push	cx
		xor	esi, esi
		mov	si, bx
		mov	di, Offset NumStrBuffer[11]
		mov	byte ptr [di], 0
		mov	cx, di
		mov	ebx, edx
@01_NumStr:	xor	edx, edx
		xchg	ebx, eax
		div	esi
		xchg	ebx, eax
		div	esi
		add	dl, '0'
		cmp	dl, '9'
		jbe	@02_NumStr
		add	dl, 'A' - '0' - 10
@02_NumStr:	dec	di
		mov	[di], dl
		mov	edx, eax
		or	edx, ebx
		jne	@01_NumStr
		sub	cx, di
		pop	bx
		or	bh, bh
		je	@03_NumStr
		sub	bh, cl
		jbe	@03_NumStr
@04_NumStr:	dec	di
		mov	byte ptr [di], bl
		inc	cx
		dec	bh
		jne	@04_NumStr
@03_NumStr:	mov	dx, di
		pop	di
		pop	si
		retn

;Integer multiplication
;  Input : EDX:EAX: the multiplicand
;          ECX:EBX: the multiplier
;  Output: EDX:EAX: the product
LongMul:	push	esi
		push	edi
		mov	esi, eax
		mov	edi, edx
		mul	ecx
		push	eax
		push	edx
		mov	eax, esi
		mul	ebx
		mov	ebx, eax
		mov	eax, edi
		mul	ecx
		mov	ecx, eax
		pop	edx
		pop	eax
		add	edx, ebx
		add	edx, ecx
		pop	edi
		pop	esi
		retn

;Integer division
;  Input : EDX:EAX: the dividend
;          ECX:EBX: the divisor
;  Output: CF: when not 0, an attempt was made to divide by 0
;          EDX:EAX: the quotient
LongDiv:	push	esi
		push	edi
		xor	edx, ebx
		pushf
		xor	edx, ebx
		pushf
		jns	@01_LongDiv
		not	edx
		neg	eax
		sbb	edx, -1
@01_LongDiv:	or	ebx, ebx
		jns	@02_LongDiv
		not	ebx
		neg	ecx
		sbb	ebx, -1
@02_LongDiv:	jne	@03_LongDiv
		cmp	edx, ecx
		jb	@04_LongDiv
		jcxz	@10_LongDiv
		xchg	eax, ebx
		xchg	eax, edx
		div	ecx
		xchg	eax, ebx
@04_LongDiv:	div	ecx
		mov	ecx, edx
		mov	edx, ebx
		xor	ebx, ebx
		jmp	@05_LongDiv
@03_LongDiv:	push	edx
		push	eax
		mov	esi, ecx
		mov	edi, ebx
		test	ebx, 0FFFF0000h
		je	@06_LongDiv
		shrd	ecx, ebx, 8
		shrd	eax, edx, 8
@06_LongDiv:	shr	edx, 1
		rcr	eax, 1
		shr	ebx, 1
		rcr	ecx, 1
		jne	@06_LongDiv
		div	ecx
		mov	ecx, eax
		mov	ebx, eax
		mul	edi
		xchg	eax, ecx
		mul	esi
		add	edx, ecx
		pop	ecx
		sub	ecx, eax
		mov	eax, ebx
		pop	ebx
		sbb	ebx, edx
		jnb	@07_LongDiv
		add	ecx, esi
		adc	ebx, edi
		dec	eax
@07_LongDiv:	xor	edx, edx
@05_LongDiv:	popf
		jns	@08_LongDiv
		not	ebx
		neg	ecx
		sbb	ebx, -1
@08_LongDiv:	popf
		jns	@09_LongDiv
		not	edx
		neg	eax
		sbb	edx, -1
@09_LongDiv:	clc
		jmp	@11_LongDiv
@10_LongDiv:	popf
		popf
		stc
@11_LongDiv:	pop	edi
		pop	esi
		retn

;Shorten string, if longer than maximum length
;  Input : DS:BX: original string
;          ES:DX: pointer to put shortened string to
;          CL: maximum length
MakeName:	push	si
		push	di
		mov	si, bx
		mov	di, dx
		cmp	LongLines, False
		jne	@01_MakeName
		call	StrLen
		cmp	al, cl
		jbe	@01_MakeName
		add	si, ax
		sub	si, cx
		add	si, 6
		add	di, 3
		mov	ax, '..'
		stosw
		stosb
@01_MakeName:	lodsb
		stosb
		or	al, al
		jne	@01_MakeName
		pop	di
		pop	si
		retn

;Split full file name to path, file name and extension
;  Input : DS:DX: full file name
;          ES:DI: pointer to put path component to; ignored if offset is 0
;          ES:BX: pointer to put name component to; ignored if offset is 0
;          ES:BP: pointer to put extension component to; ignored if offset is
;                 0
FSplit:		mov	dx, si
		call	StrLen
		add	si, ax
		dec	si
		xor	cx, cx
		std
@04_FSplit:	cmp	si, dx
		jb	@01_FSplit
		lodsb
		cmp	al, '.'
		jne	@02_FSplit
		or	cx, cx
		jne	@02_FSplit
		mov	cx, si
		inc	cx
@02_FSplit:	cmp	al, DirSep
		je	@03_FSplit
		cmp	al, ':'
		jne	@04_FSplit
@03_FSplit:	inc	si
@01_FSplit:	inc	si
		or	cx, cx
		jne	@05_FSplit
		mov	cx, dx
		xchg	si, dx
		call	StrLen
		xchg	si, dx
		add	cx, ax
@05_FSplit:	xchg	si, dx
		sub	cx, dx
		sub	dx, si
		push	cx
		mov	cx, LongFileNameMax
		stc
		call	StrPartCopy
		mov	di, bx
		pop	dx
		mov	cx, LongFileNameMax
		stc
		call	StrPartCopy
		mov	di, bp
		mov	cx, LongFileNameMax
		stc
		call	StrCopy
		retn

;Merge path and file name into full file name
;  Input : DS:SI: path component
;          DS:BX: file name component, including extension
;          ES:DI: pointer to put full file name to
AddToPath:	mov	cx, LongFileNameMax
		cmp	byte ptr [si], 0
		je	@01_AddToPath
		clc
		call	StrCopy
		cmp	byte ptr [di][-1], DirSep
		je	@01_AddToPath
		mov	al, DirSep
		stosb
@01_AddToPath:	mov	si, bx
		stc

;Copy one string to another
;  Input : DS:SI: original string
;          ES:DI: pointer to copy original string to
;          CX: maximum number of characters to copy
;          CF: when not 0, a 0 byte is appended to terminate the copied string
StrCopy:	mov	dx, cx
StrPartCopy:	cld
		pushf
		or	di, di
		jne	@04_StrCopy
		popf
		retn
@04_StrCopy:	or	cx, cx
		je	@01_StrCopy
@02_StrCopy:	or	dx, dx
		je	@01_StrCopy
		lodsb
		or	al, al
		je	@01_StrCopy
		stosb
		dec	dx
		loop	@02_StrCopy
@01_StrCopy:	xor	al, al
		popf
		jnc	@03_StrCopy
		stosb
@03_StrCopy:	retn

;Determine length of string
;  Input : DS:SI: the string
;  Output: AX: the length of the string
StrLen:		cld
		push	si
		xor	ah, ah
@02_StrLen:	lodsb
		or	al, al
		je	@01_StrLen
		inc	ah
		or	ah, ah
		jne	@02_StrLen
@01_StrLen:	pop	si
		mov	al, ah
		xor	ah, ah
		retn

;Compare two strings, in case-sensitive mode
;  Input : DS:SI: first string
;          ES:DI: second string
;  Output: ZF: when not 0, the two strings match
StrComp:	push	ax
		push	cx
		push	si
		push	di
		call	StrLen
		mov	cx, ax
		cld
		repe	cmpsb
		pop	di
		pop	si
		pop	cx
		pop	ax
		retn

;Display a string; pause at the bottom of the screen; check Escape key press
;  Input : DS:DX: the string
;          CF: when not 0, a line feed is added
PrintStr:	push	si
		push	bx
		push	cx
		pushf
		mov	si, dx
		mov	bx, 1
		call	StrLen
		or	ax, ax
		je	@01_PrintStr
		mov	cx, ax
		mov	ah, 40h
		int	21h
@01_PrintStr:	popf
		jnc	@02_PrintStr
		mov	dx, Offset LineFeed
		mov	cx, 2
		mov	ah, 40h
		int	21h
		cmp	Pause, False
		je	@02_PrintStr
		mov	al, LineCount
		inc	al
		cmp	al, ScreenHeight
		jb	@03_PrintStr
		mov	dx, Offset Continue
		clc
		call	PrintStr
@04_PrintStr:	int	28h
		call	Escape
		or	ax, ax
		je	@04_PrintStr
		mov	dx, Offset ClrLine
		clc
		call	PrintStr
		xor	al, al
@03_PrintStr:	mov	LineCount, al
@02_PrintStr:	pop	cx
		pop	bx
		pop	si
		retn

;Fetch parameter from command line
;  Input : BL: parameter number
;          ES:DI: pointer to put parameter value to
;          CX: maximum length for parameter value
;  Output: BH: number of last parameter processed
ParamStr:	mov	si, 0081h
		xor	bh, bh
		xor	ah, ah
@01_ParamStr:	lodsb
		cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		inc	bh
		cmp	bl, bh
		je	@03_ParamStr
@04_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, '"'
		jne	@07_ParamStr
		xor	ah, 1
		jmp	@08_ParamStr
@07_ParamStr:	or	ah, ah
		jne	@08_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
@08_ParamStr:	lodsb
		jmp	@04_ParamStr
@03_ParamStr:	or	di, di
		je	@05_ParamStr
@06_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, '"'
		jne	@09_ParamStr
		xor	ah, 1
		jmp	@10_ParamStr
@09_ParamStr:	or	ah, ah
		jne	@11_ParamStr
		cmp	al, ' '
		je	@02_ParamStr
		cmp	al, 9
		je	@02_ParamStr
@11_ParamStr:	stosb
@10_ParamStr:	lodsb
		loop	@06_ParamStr
@02_ParamStr:	xor	al, al
		stosb
@05_ParamStr:	retn

;Convert character to uppercase
;  Input : AL: original character
;  Output: AL: uppercase character
UpCase:		cmp	al, 'a'
		jb	@01_UpCase
		cmp	al, 'z'
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

;Abort processing the archive file with an error
;  Output: CF: 1, an error occurred or the end of archive has been reached
ArchError:	mov	Error, True
		stc
		retn

;Terminate processing the archive file
;  Output: CF: 1, an error occurred or the end of archive has been reached
ArchEnd:	mov	EndOfFile, True
		stc
		retn

;Read file name from archive file
;  Input : CF: when 0, compute the length of file name; otherwise the file
;              name length is the first character of file name
ReadName:	mov	dx, Offset FileName
		pushf
		sbb	dx, 0
		mov	cx, LongFileNameMax
		call	BlockRead
		popf
		jc	@01_ReadName
		mov	si, Offset FileName
		call	StrLen
		mov	FileNameLen, al
@01_ReadName:	mov	bl, FileNameLen
CutName:	mov	FileNameLen, bl
		xor	bh, bh
		mov	byte ptr FileName[bx], 0
		retn

;Check continuation bits in header flags, subroutine
;  Input : AL: header flags
;          BL: continuation bit
;  Output: AH: when not 0, the continuation bit is set among the header flags
ContFlag:	xor	ah, ah
		cmp	MultiVolumes, ah
		je	@01_ContFlag
		test	al, bl
		je	@01_ContFlag
		inc	ah
@01_ContFlag:	retn

;Check continuation bits in header flags
;  Input : AL: header flags
;          BL: "continued from previous volume" bit
;          BH: "continued on next volume" bit
CheckCont:	call	ContFlag
		mov	ContFromPrev, ah
		mov	bl, bh
		call	ContFlag
		mov	ContOnNext, ah
		retn

;Set directory attribute and flag
;  Input : EDX: attributes
;          AL: attributes
CheckDir:	test	al, 10h
		je	@01_CheckDir
SetDir:		inc	IsDirectory
		or	dl, 10h
@01_CheckDir:	retn

;Read header from archive file
;  Input : CX: number of bytes to read
;  Output: CF: when not 0, an error occurred
ReadHeader:	mov	dx, Offset Header

;Read data from archive file
;  Input : DS:DX: buffer to read data into
;          CX: number of bytes to read
;  Output: CF: when not 0, an error occurred
BlockRead:	mov	di, dx
		push	cx
		xor	al, al
		cld
		rep	stosb
		pop	cx
		mov	bx, ArchFile
		mov	ah, 3Fh
		int	21h
		retn

;Increase file pointer and seek there in archive file
;  Input : CX:DX: value to add to current file pointer
SeekNext:	add	dx, word ptr ArchPos[0]
		adc	cx, word ptr ArchPos[2]

;Set file pointer and seek there in archive file
;  Input : CX:DX: new value of current file pointer
SeekArch2:	mov	word ptr ArchPos[0], dx
		mov	word ptr ArchPos[2], cx
		xor	al, al

;Seek in archive file
;  Input : CX:DX: new value of current file pointer
SeekArch:	mov	bx, ArchFile
		mov	ah, 42h
		int	21h
		retn

;Search for string backwards in archive file
;  Input : DS:SI: string to search for
;          CX: length of search string
;          ES:DI: buffer to use for search and to read header into, when
;                 string found
;          BX: length of search buffer
;  Output: CF: when 0, string has been found, buffer filled with header;
;              otherwise an error occurred or the string has not been found
RevSearch:	dec	si
		mov	SearchOffs, si
		mov	SearchLen, cx
		mov	TargetOffs, di
		mov	TargetLen, bx
		mov	SearchFirst, True
		xor	cx, cx
		mov	dx, cx
		mov	al, 2
		call	SeekArch
		mov	word ptr ArchPos[0], ax
		mov	word ptr ArchPos[2], dx
@03_RevSearch:	xor	ax, ax
@06_RevSearch:	mov	MatchLen, ax
		mov	dx, word ptr ArchPos[0]
		mov	cx, word ptr ArchPos[2]
		mov	bx, BufferMax
		or	cx, cx
		jne	@01_RevSearch
		or	dx, dx
		je	@02_RevSearch
		cmp	dx, bx
		jae	@01_RevSearch
		mov	bx, dx
@01_RevSearch:	mov	BufferSize, bx
		sub	dx, bx
		sbb	cx, 0
		call	SeekArch2
		mov	cx, BufferSize
		mov	dx, Offset Buffer
		call	BlockRead
		jc	@02_RevSearch
		mov	di, dx
		add	di, cx
		dec	di
		xor	al, al
		cmp	SearchFirst, al
		je	@08_RevSearch
		mov	SearchFirst, al
		mov	ax, TargetLen
		sub	ax, SearchLen
		sub	di, ax
		sub	cx, ax
@08_RevSearch:	mov	ax, MatchLen
		or	ax, ax
		je	@04_RevSearch
		mov	si, SearchOffs
		add	si, ax
		push	di
		push	cx
		jmp	@07_RevSearch
@02_RevSearch:	stc
		retn
@04_RevSearch:	mov	si, SearchOffs
		add	si, SearchLen
		mov	al, byte ptr [si]
		std
		repne	scasb
		jne	@03_RevSearch
		push	di
		push	cx
		inc	di
		inc	cx
		mov	ax, SearchLen
@07_RevSearch:	cmp	cx, ax
		jbe	@05_RevSearch
		mov	cx, ax
@05_RevSearch:	sub	ax, cx
		std
		repe	cmpsb
		mov	dx, di
		pop	cx
		pop	di
		jne	@04_RevSearch
		or	ax, ax
		je	@09_RevSearch
		jmp	@06_RevSearch
@09_RevSearch:	inc	dx
		mov	si, dx
		mov	ax, dx
		sub	ax, Offset Buffer
		add	word ptr ArchPos[0], ax
		adc	word ptr ArchPos[2], 0
		mov	di, TargetOffs
		mov	cx, TargetLen
		add	ax, cx
		cmp	ax, BufferSize
		jbe	@10_RevSearch
		push	cx
		mov	dx, word ptr ArchPos[0]
		mov	cx, word ptr ArchPos[2]
		xor	al, al
		call	SeekArch
		pop	cx
		mov	dx, di
		jmp	BlockRead
@10_RevSearch:	cld
		rep	movsb
		clc
		retn

;Negate signed number
; Input : CX:DX: original number
; Output: CX:DX: negated number
NegateOffs:	not	dx
		not	cx
		add	dx, 1
		adc	cx, 0
		retn

;Convert little-endian long integer number to big-endian
;  Input : DS:SI: pointer to original, little-endian long integer
;          ES:DI: pointer to put the converted, big-endian long integer to
ConvLEnd:	call	ReadLEnd
		stosw
		mov	ax, dx
		stosw
		retn

;Fetch little-endian long integer number
;  Input : DS:SI: pointer to original, little-endian long integer
;  Output: DX:AX: converted, big-endian long integer
ReadLEnd:	mov	ax, 0
		mov	dx, ax
		lodsb
		jc	@01_ReadLEnd
		mov	dh, al
		lodsb
		mov	dl, al
		lodsb
@01_ReadLEnd:	mov	ah, al
		lodsb
		retn

;Convert Unix-style date stamp to DOS-style date stamp
;  Input : DX:AX: Unix-style date stamp
;          SI: epoch; year that Unix-style date stamp counts seconds from
;  Output: ECX: DOS-style date stamp
UnixToDOS:	mov	cx, 60
		xor	bx, bx
		call	LongDiv
		mov	Seconds, cl
		mov	cx, 60
		xor	bx, bx
		call	LongDiv
		mov	Minutes, cl
		mov	cx, 24
		xor	bx, bx
		call	LongDiv
		mov	Hours, cl
		dec	si
		xor	bx, bx
@02_UnixToDOS:	inc	si
		sub	ax, bx
		sbb	dx, 0
		mov	bx, 365
		test	si, 0003h
		jne	@01_UnixToDOS
		inc	bx
		push	ax
		push	dx
		mov	ax, si
		xor	dx, dx
		mov	cx, 100
		div	cx
		or	dx, dx
		pop	dx
		pop	ax
		jne	@01_UnixToDOS
		dec	bx
		push	ax
		push	dx
		mov	ax, si
		xor	dx, dx
		mov	cx, 400
		div	cx
		or	dx, dx
		pop	dx
		pop	ax
		jne	@01_UnixToDOS
		inc	bx
@01_UnixToDOS:	or	dx, dx
		jne	@02_UnixToDOS
		cmp	ax, bx
		jae	@02_UnixToDOS
		sub	bx, 365
		mov	cl, bl
		mov	Year, si
		xor	bx, bx
		xor	dx, dx
@03_UnixToDOS:	inc	bx
		sub	ax, dx
		mov	dl, DaysPerMonth[bx - 1]
		cmp	bl, 2
		jne	@04_UnixToDOS
		add	dl, cl
@04_UnixToDOS:	cmp	ax, dx
		jae	@03_UnixToDOS
		inc	al
		mov	Month, bl
		mov	Day, al
		call	PackDate
		mov	ecx, DateTime
		retn

ACE_Read:	mov	cx, ACE_HeaderEnd - ACE_Header
		call	ReadHeader
		xor	cx, cx
		mov	word ptr ACE_AddSize[0], cx
		mov	word ptr ACE_AddSize[2], cx
		test	byte ptr ACE_HeadFlags[0], 01h
		je	@01_ACE_Read
		mov	cx, 4
		mov	dx, Offset ACE_AddSize
		call	BlockRead
		or	ax, ax
		je	@02_ACE_Read
@01_ACE_Read:	mov	cx, ACE_HeaderEnd3 - ACE_Header3
		mov	dx, Offset ACE_Header2
		call	BlockRead
		or	ax, ax
@02_ACE_Read:	retn

ACE_Skip:	mov	dx, ACE_HeadSize
		xor	cx, cx
		add	dx, 4
		adc	cx, 0
		add	dx, word ptr ACE_AddSize[0]
		adc	cx, word ptr ACE_AddSize[2]
		jmp	SeekNext

;*_Next: "Next entry" routines; fetch data from next archive entry
;  Output: EBX:EAX: original file size
;          EDI:ESI: packed file size
;          ECX: date stamp
;          EDX: attributes
;
;*_FirstV: "First volume" routines; check whether the current archive is the
;  first volume of a volume set
;  Output: CF: when 0, the archive is the first volume; otherwise, an error
;              occurred or the archive is not the first volume of a volume set
;
;*_NextV: "Next volume" routines; generate file name for next volume
;  Output: CF: when 0, there is a next volume; otherwise, an error occurred or
;              the next volume is not present

;"Next entry" routine for ACE archives
ACE_Next:	cmp	First, False
		je	@01_ACE_Next
		call	ACE_Read
		je	@03_ACE_Next
		cmp	ACE_HeadType, 0
		jne	@03_ACE_Next
		mov	cx, 7
		mov	si, Offset ACE_Sign
		mov	di, Offset ACE_HeadSign
		cld
		repe	cmpsb
		je	@02_ACE_Next
@03_ACE_Next:	jmp	ArchError
@02_ACE_Next:	mov	First, False
		call	ACE_Skip
@01_ACE_Next:	call	ACE_Read
		jne	@04_ACE_Next
		jmp	ArchEnd
@04_ACE_Next:	call	ACE_Skip
		cmp	ACE_HeadType, 1
		jne	ACE_Next
		mov	si, Offset ACE_Name
		mov	di, Offset FileName
		mov	cl, byte ptr ACE_NameLen[0]
		xor	ch, ch
		stc
		call	StrCopy
		mov	eax, ACE_OrigSize
		xor	ebx, ebx
		mov	ecx, ACE_DateTime
		mov	esi, ACE_PackSize
		xor	edi, edi
		mov	edx, ACE_Attrib
@05_ACE_Next:	push	eax
		push	ebx
		mov	eax, edx
		call	CheckDir
		mov	al, byte ptr ACE_HeadFlags[1]
		mov	bx, 2010h
		call	CheckCont
		pop	ebx
		pop	eax
		clc
		retn

;"Next volume" routine for ACE archives
ACE_NextV:	xor	ax, ax
		jmp	NextVol

;"Next entry" routine for ARC archives
ARC_Next:	mov	NoAttribs, True
		mov	cx, ARC_HeaderEnd - ARC_Header
		call	ReadHeader
		cmp	ARC_HeadSign, 1Ah
		je	@01_ARC_Next
		jmp	ArchError
@01_ARC_Next:	cmp	ARC_Method, 0
		jne	@02_ARC_Next
		jmp	ArchEnd
@02_ARC_Next:	mov	dx, word ptr ARC_PackSize[0]
		mov	cx, word ptr ARC_PackSize[2]
		add	dx, ARC_HeaderEnd - ARC_Header
		adc	cx, 0
		call	SeekNext
		mov	si, Offset ARC_Name
		mov	di, Offset FileName
		mov	cx, FileNameMax
		stc
		call	StrCopy
		mov	eax, ARC_OrigSize
		xor	ebx, ebx
		mov	ecx, ARC_DateTimeRev
		ror	ecx, 16
		mov	esi, ARC_PackSize
		xor	edi, edi
		xor	edx, edx
		clc
		retn

;"Next entry" routine for ARJ archives
ARJ_Next:	mov	cx, ARJ_HeaderEnd - ARJ_Header
		call	ReadHeader
		cmp	ARJ_HeadSign, 0EA60h
		je	@01_ARJ_Next
		jmp	ArchError
@01_ARJ_Next:	cmp	ARJ_HeadSize, 0
		jne	@02_ARJ_Next
		jmp	ArchEnd
@02_ARJ_Next:	cmp	First, False
		jne	@04_ARJ_Next
		test	ARJ_HeadFlags, 08h
		je	@04_ARJ_Next
		mov	cx, ARJ_HeaderEnd2 - ARJ_Header2
		mov	dx, Offset ARJ_Header2
		call	BlockRead
@04_ARJ_Next:	mov	dl, ARJ_FirstHdr
		xor	dh, dh
		xor	cx, cx
		add	dx, 4
		adc	cx, 0
		call	SeekNext
		cmp	First, False
		jne	@03_ARJ_Next
		clc
		call	ReadName
@03_ARJ_Next:	mov	dx, ARJ_HeadSize
		sub	dl, ARJ_FirstHdr
		sbb	dh, 0
		xor	cx, cx
		call	SeekNext
		mov	cx, ARJ_HeaderEnd3 - ARJ_Header3
		call	ReadHeader
		mov	dx, ARJ_ExtHeadSize
		xor	cx, cx
		cmp	dx, 0
		je	@05_ARJ_Next
		add	dx, 4
		adc	cx, 0
@05_ARJ_Next:	add	dx, ARJ_HeaderEnd3 - ARJ_Header3
		adc	cx, 0
		cmp	First, False
		jne	@06_ARJ_Next
		add	dx, word ptr ARJ_PackSize[0]
		adc	cx, word ptr ARJ_PackSize[2]
@06_ARJ_Next:	call	SeekNext
		xor	cx, cx
		mov	dx, cx
		cmp	First, False
		jne	@07_ARJ_Next
		mov	eax, ARJ_OrigSize
		xor	ebx, ebx
		mov	ecx, ARJ_DateTime
		mov	esi, ARJ_PackSize
		xor	edi, edi
		xor	edx, edx
		mov	dx, ARJ_Attrib
@07_ARJ_Next:	push	eax
		push	ebx
		mov	eax, edx
		call	CheckDir
		mov	al, ARJ_HeadFlags
		mov	bx, 0408h
		call	CheckCont
		pop	ebx
		pop	eax
		clc
		retn

;"Next volume" routine for ARJ archives
ARJ_NextV:	mov	ax, 0101h
		jmp	NextVol

;Read file name from CAB archive file and seek to after the file name
CAB_ReadName:	clc
		call	ReadName
		mov	dl, FileNameLen
		xor	dh, dh
		xor	cx, cx
		inc	dx
		jmp	SeekNext

;"Next entry" routine for CAB archives
CAB_Next:	cmp	First, False
		je	@01_CAB_Next
		xor	eax, eax
		mov	CheckContName, al
		mov	FileCount, eax
		inc	al
		mov	NoPackSize, al
		mov	cx, CAB_HeaderEnd - CAB_Header
		push	cx
		call	ReadHeader
		pop	cx
		add	word ptr ArchPos[0], cx
		add	word ptr ArchPos[2], 0
		mov	eax, FileNum
		mov	FileCount, eax
		xor	eax, eax
		mov	ax, CAB_FileNum
		add	FileNum, eax
		push	word ptr CAB_DirOffs[0]
		push	word ptr CAB_DirOffs[2]
		push	word ptr CAB_ArchSize[0]
		push	word ptr CAB_ArchSize[2]
		mov	ax, CAB_ArchFlags
		mov	ArchFlags, al
		test	al, 02h
		je	@02_CAB_Next
		call	CAB_ReadName
		mov	si, Offset FileName
		mov	di, Offset NextVolName
		mov	cx, FileNameMax
		stc
		call	StrCopy
		call	CAB_ReadName
@02_CAB_Next:	test	ArchFlags, 01h
		je	@03_CAB_Next
		call	CAB_ReadName
		call	CAB_ReadName
@03_CAB_Next:	mov	cx, CAB_HeaderEnd2 - CAB_Header2
		call	ReadHeader
		pop	dx
		pop	ax
		sub	ax, word ptr CAB_StartPos[0]
		sbb	dx, word ptr CAB_StartPos[2]
		mov	word ptr ThisVolPack[0], ax
		mov	word ptr ThisVolPack[2], dx
		xor	eax, eax
		mov	dword ptr ThisVolPack[4], eax
		pop	cx
		pop	dx
		call	SeekArch2
@01_CAB_Next:	mov	eax, FileCount
		cmp	eax, FileNum
		jb	@04_CAB_Next
		cmp	MultiVolumes, False
		je	@05_CAB_Next
		test	ArchFlags, 02h
		je	@05_CAB_Next
		mov	ContOnNext, True
@05_CAB_Next:	jmp	ArchEnd
@04_CAB_Next:	mov	cx, CAB_HeaderEnd3 - CAB_Header3
		push	cx
		call	ReadHeader
		clc
		call	ReadName
		pop	dx
		mov	al, FileNameLen
		xor	ah, ah
		inc	ax
		add	dx, ax
		xor	cx, cx
		call	SeekNext
		cmp	MultiVolumes, False
		je	@06_CAB_Next
		cmp	CAB_HeadFlags, -3
		jne	@06_CAB_Next
		dec	FileNum
		mov	First, False
		jmp	CAB_Next
@06_CAB_Next:	mov	eax, CAB_OrigSize
		xor	ebx, ebx
		mov	ecx, CAB_DateTimeRev
		ror	ecx, 16
		xor	esi, esi
		xor	edi, edi
		xor	edx, edx
		mov	dx, CAB_Attrib
		push	eax
		mov	eax, edx
		call	CheckDir
		pop	eax
		clc
		retn

;"First volume" routine for CAB archives
CAB_FirstV:	mov	cx, CAB_HeaderEnd - CAB_Header
		call	ReadHeader
		mov	eax, CAB_HeadSign
		cmp	eax, dword ptr CAB_Sign
		jne	@01_CAB_FirstV
		xor	cx, cx
		mov	dx, cx
		call	SeekArch2
		test	CAB_ArchFlags, 01h
		clc
		je	@02_CAB_FirstV
		stc
@02_CAB_FirstV:	retn
@01_CAB_FirstV:	jmp	ArchError

;"Next volume" routine for CAB archives
CAB_NextV:	mov	FirstVolume, False
		test	ArchFlags, 02h
		stc
		je	@01_CAB_NextV
		mov	bx, Offset NextVolName
		call	ChangeName
		clc
@01_CAB_NextV:	retn

;"Next entry" routine for DWC archives
DWC_Next:	cmp	First, False
		je	@01_DWC_Next
		mov	NoAttribs, True
		mov	dx, DWC_HeaderEnd - DWC_Header
@03_DWC_Next:	push	dx
		xor	cx, cx
		call	NegateOffs
		mov	al, 2
		call	SeekArch
		mov	word ptr ArchPos[0], ax
		mov	word ptr ArchPos[2], dx
		mov	cx, DWC_HeaderEnd - DWC_Header
		call	ReadHeader
		mov	cx, 3
		mov	si, Offset DWC_Sign
		mov	di, Offset DWC_HeadSign
		cld
		repe	cmpsb
		pop	dx
		je	@02_DWC_Next
		inc	dx
		jne	@03_DWC_Next 
		jmp	ArchError
@02_DWC_Next:	xor	eax, eax
		mov	ax, DWC_FileNum
		mov	FileNum, eax
		mov	cx, DWC_HeaderEnd2 - DWC_Header2
		mul	cx
		mov	cx, dx
		mov	dx, ax
		call	NegateOffs
		call	SeekNext
@01_DWC_Next:	mov	eax, FileCount
		add	eax, DirCount
		cmp	eax, FileNum
		jb	@04_DWC_Next
		jmp	ArchEnd
@04_DWC_Next:	mov	cx, DWC_HeaderEnd2 - DWC_Header2
		call	ReadHeader
		mov	si, Offset DWC_Name
		mov	di, Offset FileName
		mov	cx, FileNameMax
		stc
		call	StrCopy
		mov	ax, word ptr DWC_Seconds[0]
		mov	dx, word ptr DWC_Seconds[2]
		sub	ax, 1680h
		sbb	dx, 12CFh
		jnc	@05_DWC_Next
		xor	ax, ax
		mov	dx, ax
@05_DWC_Next:	mov	si, 1980
		call	UnixToDOS
		mov	eax, DWC_OrigSize
		xor	ebx, ebx
		mov	esi, DWC_PackSize
		xor	edi, edi
		xor	edx, edx
		clc
		retn

;"Next entry" routine for HA archives
HA_Next:	cmp	First, False
		je	@01_HA_Next
		mov	NoAttribs, True
		mov	cx, HA_HeaderEnd - HA_Header
		call	ReadHeader
		cmp	HA_HeadSign, 'AH'
		je	@02_HA_Next
		jmp	ArchError
@02_HA_Next:	xor	eax, eax
		mov	ax, HA_FileNum
		mov	FileNum, eax
		mov	dx, HA_HeaderEnd - HA_Header
		xor	cx, cx
		call	SeekNext
@01_HA_Next:	mov	eax, FileCount
		add	eax, DirCount
		cmp	eax, FileNum
		jb	@03_HA_Next
		jmp	ArchEnd
@03_HA_Next:	mov	cx, HA_HeaderEnd2 - HA_Header2
		call	ReadHeader
		clc
		call	ReadName
		mov	si, Offset FileName
@05_HA_Next:	lodsb
		or	al, al
		je	@04_HA_Next
		cmp	al, 0FFh
		jne	@05_HA_Next
		mov	byte ptr [si][-1], DirSep
		jmp	@05_HA_Next
@04_HA_Next:	mov	di, si
		dec	di
		mov	cx, FileNameMax
		sub	cx, si
		stc
		call	StrCopy
		mov	dx, di
		sub	dx, Offset FileName
		xor	cx, cx
		lodsb
		xor	ah, ah
		add	ax, 2
		add	dx, ax
		adc	cx, 0
		add	dx, HA_HeaderEnd2 - HA_Header2
		adc	cx, 0
		add	dx, word ptr HA_PackSize[0]
		adc	cx, word ptr HA_PackSize[2]
		call	SeekNext
		mov	ax, word ptr HA_DateTime[0]
		mov	dx, word ptr HA_DateTime[2]
		sub	ax, 4650h
		sbb	dx, 0
		jnc	@06_HA_Next
		xor	ax, ax
		mov	dx, ax
@06_HA_Next:	mov	si, 1970
		call	UnixToDOS
		xor	edx, edx
		mov	al, HA_Ver_N_Type
		and	al, 0Fh
		cmp	al, 0Eh
		jne	@07_HA_Next
		call	SetDir
@07_HA_Next:	mov	eax, HA_OrigSize
		xor	ebx, ebx
		mov	esi, HA_PackSize
		xor	edi, edi
		clc
		retn

;"Next entry" routine for HAP archives
HAP_Next:	cmp	First, False
		je	@01_HAP_Next
		mov	cx, HAP_HeaderEnd - HAP_Header
		call	ReadHeader
		cmp	word ptr HAP_HeadSign[2], 'FH'
		je	@02_HAP_Next
@03_HAP_Next:	jmp	ArchError
@02_HAP_Next:	mov	dx, HAP_HeaderEnd - HAP_Header
		xor	cx, cx
		call	SeekNext
@01_HAP_Next:	mov	cx, HAP_HeaderEnd2 - HAP_Header2
		call	ReadHeader
		cmp	ax, cx
		je	@04_HAP_Next
		jmp	ArchEnd
@04_HAP_Next:	mov	cx, 5
		mov	si, Offset HAP_Sign
		mov	di, Offset HAP_HeadSign2
		cld
		repe	cmpsb
		jne	@03_HAP_Next
		mov	dx, HAP_HeaderEnd2 - HAP_Header2
		xor	cx, cx
		add	dx, word ptr HAP_PackSize[0]
		adc	cx, word ptr HAP_PackSize[2]
		call	SeekNext
		mov	si, Offset HAP_Name
		mov	di, Offset FileName
		mov	cx, FileNameMax
		stc
		call	StrCopy
		mov	eax, HAP_OrigSize
		xor	ebx, ebx
		mov	ecx, HAP_DateTime
		mov	esi, HAP_PackSize
		xor	edi, edi
		push	eax
		xor	eax, eax
		mov	al, HAP_Attrib
		mov	edx, eax
		call	CheckDir
		pop	eax
		clc
		retn

;"Next entry" routine for HPK archives
HPK_Next:	cmp	First, False
		jne	@07_HPK_Next
		jmp	@01_HPK_Next
@07_HPK_Next:	mov	NoAttribs, True
		mov	cx, HPK_HeaderEnd - HPK_Header
		call	ReadHeader
		mov	cx, 4
		mov	si, Offset HPK_Sign
		mov	di, Offset HPK_HeadSign1
		cld
		repe	cmpsb
		je	@02_HPK_Next
@03_HPK_Next:	jmp	ArchError
@02_HPK_Next:	mov	dx, HPK_HeaderEnd2 - HPK_Header2
		xor	cx, cx
		call	NegateOffs
		mov	al, 2
		call	SeekArch
		mov	word ptr ArchPos[0], ax
		mov	word ptr ArchPos[2], dx
		mov	cx, HPK_HeaderEnd2 - HPK_Header2
		call	ReadHeader
		mov	cx, 5
		mov	si, Offset HPK_Sign2
		mov	di, Offset HPK_HeadSign2
		cld
		repe	cmpsb
		jne	@03_HPK_Next
		xor	eax, eax
		mov	ax, HPK_FileNum
		xchg	al, ah
		mov	ebx, eax
		mov	ax, HPK_DirNum
		xchg	al, ah
		mov	DirNum, eax
		add	eax, ebx
		mov	FileNum, eax
		mov	si, Offset HPK_HeadSize
		clc
		call	ReadLEnd
		mov	cx, dx
		mov	dx, ax
		call	NegateOffs
		call	SeekNext
		mov	dx, word ptr ArchPos[0]
		mov	cx, word ptr ArchPos[2]
		mov	word ptr ArchPos2[0], dx
		mov	word ptr ArchPos2[2], cx
		mov	word ptr ArchPosOrig[0], dx
		mov	word ptr ArchPosOrig[2], cx
		mov	eax, FileNum
@04_HPK_Next:	push	eax
		call	HPK_Read
		call	SeekNext
		cmp	IsDirectory, False
		je	@06_HPK_Next
		inc	DirCount
@06_HPK_Next:	pop	eax
		dec	eax
		jne	@04_HPK_Next
		xor	eax, eax
		mov	DirCount, eax
		mov	dx, word ptr ArchPos[0]
		mov	cx, word ptr ArchPos[2]
		mov	word ptr ArchPos2Orig[0], dx
		mov	word ptr ArchPos2Orig[2], cx
		xchg	word ptr ArchPos2[0], dx
		xchg	word ptr ArchPos2[2], cx
		call	SeekArch2
@01_HPK_Next:	mov	eax, FileCount
		add	eax, DirCount
		cmp	eax, FileNum
		jb	@05_HPK_Next
		jmp	ArchEnd
@05_HPK_Next:	mov	dx, word ptr ArchPos[0]
		mov	cx, word ptr ArchPos[2]
		xor	al, al
		call	SeekArch
		call	HPK_Read
		call	SeekNext
		mov	dx, word ptr ArchPos2[0]
		mov	cx, word ptr ArchPos2[2]
		xor	al, al
		call	SeekArch
		clc
		call	ReadName
		inc	bx
		add	word ptr ArchPos2[0], bx
		adc	word ptr ArchPos2[2], 0
		mov	ax, word ptr HPK_Seconds[0]
		mov	dx, word ptr HPK_Seconds[2]
		mov	si, 1970
		call	UnixToDOS
		mov	eax, HPK_OrigSize
		xor	ebx, ebx
		mov	esi, HPK_PackSize
		xor	edi, edi
		xor	edx, edx
		push	eax
		mov	ax, HPK_ContainDir
		or	ax, ax
		pop	eax
		clc
		je	@08_HPK_Next
		call	HPK_Path
		jnc	@08_HPK_Next
		jmp	ArchError
@08_HPK_Next:	retn

;Descend into directory structure of HPK archive, implemented by recursive
;  pointers, and add directory names to file name, to get full file name
HPK_Path:	push	eax
		push	bx
		push	cx
		push	dx
		push	si
		push	di
		push	FileCount
		push	DirCount
		mov	al, IsDirectory
		push	ax
		mov	bx, MaxNesting
@03_HPK_Path:	mov	ax, HPK_ContainDir
		or	ax, ax
		jne	@04_HPK_Path
		clc
		jmp	@01_HPK_Path
@04_HPK_Path:	dec	bx
		jne	@05_HPK_Path
		stc
		jmp	@01_HPK_Path
@05_HPK_Path:	push	bx
		mov	si, Offset FileName
		mov	di, Offset PrevFileName
		push	di
		push	ax
		stc
		call	StrCopy
		xor	eax, eax
		mov	FileCount, eax
		mov	DirCount, eax
		pop	ax
		push	word ptr ArchPosOrig[0]
		push	word ptr ArchPosOrig[2]
		push	word ptr ArchPos2Orig[0]
		push	word ptr ArchPos2Orig[2]
@02_HPK_Path:	push	ax
		mov	dx, word ptr ArchPosOrig[0]
		mov	cx, word ptr ArchPosOrig[2]
		xor	al, al
		call	SeekArch
		call	HPK_Read
		add	word ptr ArchPosOrig[0], dx
		adc	word ptr ArchPosOrig[2], cx
		mov	dx, word ptr ArchPos2Orig[0]
		mov	cx, word ptr ArchPos2Orig[2]
		xor	al, al
		call	SeekArch
		clc
		call	ReadName
		inc	bx
		add	word ptr ArchPos2Orig[0], bx
		adc	word ptr ArchPos2Orig[2], 0
		pop	ax
		dec	ax
		jne	@02_HPK_Path
		pop	word ptr ArchPos2Orig[2]
		pop	word ptr ArchPos2Orig[0]
		pop	word ptr ArchPosOrig[2]
		pop	word ptr ArchPosOrig[0]
		mov	si, Offset FileName
		mov	di, Offset ArchPath
		push	si
		push	di
		stc
		call	StrCopy
		pop	si
		pop	di
		pop	bx
		call	AddToPath
		pop	bx
		jmp	@03_HPK_Path
@01_HPK_Path:	pop	ax
		mov	IsDirectory, al
		pop	DirCount
		pop	FileCount
		pop	di
		pop	si
		pop	dx
		pop	cx
		pop	bx
		pop	eax
		retn

;Check whether a value is stored in little- or big-endian format in HPK
;  archive header
;  Input : AL: format bit
;  Output: CF: when 0, format bit is set
HPK_Long:	test	HPK_HeadType, al
		stc
		je	@01_HPK_Long
		clc
@01_HPK_Long:	retn

;Read header from HPK archive and do some conversions on it
;  Output: DX:CX: header length
HPK_Read:	xor	edx, edx
		mov	IsDirectory, False
		mov	eax, DirCount
		cmp	eax, DirNum
		jae	@06_HPK_Read
		call	SetDir
@06_HPK_Read:	mov	cx, HPK_HeaderEnd3 - HPK_Header3
		mov	dx, Offset FileName
		call	BlockRead
		mov	si, Offset FileName
		mov	di, Offset HPK_Header
		cld
		lodsb
		stosb
		cmp	IsDirectory, False
		je	@01_HPK_Read
		push	ax
		xor	al, al
		stosb
		pop	ax
		test	al, 40h
		jmp	@02_HPK_Read
@01_HPK_Read:	movsb
		test	al, 10h
@02_HPK_Read:	mov	ax, 0
		je	@04_HPK_Read
		lodsw
		cmp	ax, word ptr DirNum[0]
		jbe	@04_HPK_Read
		xor	ax, ax
@04_HPK_Read:	stosw
		clc
		call	ConvLEnd
		cmp	IsDirectory, False
		je	@03_HPK_Read
		xor	ax, ax
		stosw
		stosw
		stosw
		stosw
		jmp	@05_HPK_Read
@03_HPK_Read:	mov	al, 80h
		call	HPK_Long
		call	ConvLEnd
		mov	al, 40h
		call	HPK_Long
		call	ConvLEnd
@05_HPK_Read:	mov	dx, si
		sub	dx, Offset FileName
		xor	cx, cx
		retn

;"Next entry" routine for HYP archives
HYP_Next:	mov	cx, HYP_HeaderEnd - HYP_Header
		call	ReadHeader
		or	ax, ax
		jne	@01_HYP_Next
		jmp	ArchEnd
@01_HYP_Next:	stc
		call	ReadName
		mov	cx, 3
		mov	si, Offset HYP_Sign
		mov	di, Offset HYP_HeadSign
		cld
		repe	cmpsb
		je	@02_HYP_Next
		jmp	ArchError
@02_HYP_Next:	mov	dl, FileNameLen
		inc	dl
		xor	dh, dh
		xor	cx, cx
		add	dx, HYP_HeaderEnd - HYP_Header
		adc	cx, 0
		add	dx, word ptr HYP_PackSize[0]
		adc	cx, word ptr HYP_PackSize[2]
		call	SeekNext
		xor	edx, edx
		mov	dl, HYP_Attrib
		mov	eax, HYP_OrigSize
		xor	ebx, ebx
		mov	ecx, HYP_DateTime
		mov	esi, HYP_PackSize
		xor	edi, edi
		clc
		retn

;"Next entry" routine for LHA archives
LHA_Next:	mov	cx, LHA_HeaderEnd - LHA_Header
		call	ReadHeader
		cmp	LHA_HeadSize, 0
		jne	@01_LHA_Next
		jmp	ArchEnd
@01_LHA_Next:	mov	cx, LHA_HeaderEnd2 - LHA_Header2
		mov	dx, Offset LHA_Header2
		call	BlockRead
		test	LHA_HeadFlags, 2
		je	@04_LHA_Next
		mov	cx, LHA_HeaderEnd3 - LHA_Header3
		mov	dx, Offset LHA_Header3
		call	BlockRead
@04_LHA_Next:	test	LHA_HeadFlags, 2
		cmc
		call	ReadName
		test	LHA_HeadFlags, 2
		je	@05_LHA_Next
		mov	di, Offset FileName
		mov	cx, LongFileNameMax
		mov	al, 1Bh
		cld
		repne	scasb
		jne	@03_LHA_Next
		dec	di
		mov	byte ptr [di], 0
@05_LHA_Next:	cmp	word ptr LHA_Method[0], 'l-'
		je	@02_LHA_Next
@03_LHA_Next:	jmp	ArchError
@02_LHA_Next:	cmp	byte ptr LHA_Method[2], 'h'
		jne	@03_LHA_Next
		cmp	byte ptr LHA_Method[4], '-'
		jne	@03_LHA_Next
		cmp	byte ptr LHA_Method[3], 'd'
		jne	@16_LHA_Next
		or	LHA_Attrib, DirAttrib
@16_LHA_Next:	mov	dl, LHA_HeadSize
		xor	dh, dh
		xor	cx, cx
		test	LHA_HeadFlags, 2
		jne	@06_LHA_Next
		add	dx, LHA_HeaderEnd - LHA_Header
		adc	cx, 0
@06_LHA_Next:	sub	dx, 2
		sbb	cx, 0
		call	SeekNext
		test	LHA_HeadFlags, 1
		je	@10_LHA_Next
		mov	cx, LHA_HeaderEnd4 - LHA_Header4
		mov	dx, Offset LHA_Header4
		call	BlockRead
		mov	cx, LHA_ExtHeadSize
		jcxz	@10_LHA_Next
		mov	dx, LongFileNameMax + 1
		cmp	cx, dx
		jb	@08_LHA_Next
		mov	cx, dx
@08_LHA_Next:	mov	dx, Offset LHA_Header5
		push	cx
		push	dx
		call	BlockRead
		pop	si
		pop	cx
		cld
@11_LHA_Next:	lodsb
		dec	cx
		cmp	al, 2
		je	@09_LHA_Next
		jcxz	@10_LHA_Next
		jmp	@11_LHA_Next
@09_LHA_Next:	jcxz	@10_LHA_Next
		push	si
		mov	di, si
@15_LHA_Next:	lodsb
		dec	cx
		cmp	al, 0FFh
		jne	@12_LHA_Next
		mov	al, DirSep
@12_LHA_Next:	cmp	al, 20h
		jae	@13_LHA_Next
		xor	al, al
@13_LHA_Next:	stosb
		or	al, al
		je	@14_LHA_Next
		jcxz	@14_LHA_Next
		jmp	@15_LHA_Next
@14_LHA_Next:	pop	si
		mov	bx, Offset FileName
		mov	di, Offset TempFileName
		push	bx
		push	di
		call	AddToPath
		pop	si
		pop	di
		stc
		call	StrCopy
@10_LHA_Next:	mov	dx, word ptr LHA_PackSize[0]
		mov	cx, word ptr LHA_PackSize[2]
		add	dx, 2
		adc	cx, 0
		call	SeekNext
		xor	edx, edx
		mov	dl, LHA_Attrib
		mov	ecx, LHA_DateTime
		test	LHA_HeadFlags, 2
		je	@07_LHA_Next
		mov	ax, cx
		mov	si, 1970
		call	UnixToDOS
@07_LHA_Next:	mov	eax, LHA_OrigSize
		xor	ebx, ebx
		mov	esi, LHA_PackSize
		xor	edi, edi
		clc
		retn

;"Next entry" routine for LIM archives
LIM_Next:	cmp	First, False
		je	@01_LIM_Next
		mov	cx, LIM_HeaderEnd - LIM_Header
		call	ReadHeader
		mov	cx, 3
		mov	si, Offset LIM_Sign
		mov	di, Offset LIM_HeadSign
		cld
		repe	cmpsb
		je	@02_LIM_Next
@07_LIM_Next:	jmp	ArchError
@02_LIM_Next:	mov	dx, LIM_HeaderEnd - LIM_Header
		xor	cx, cx
		call	SeekNext
@01_LIM_Next:	mov	cx, LIM_HeaderEnd2 - LIM_Header2
		call	ReadHeader
		or	ax, ax
		jne	@03_LIM_Next
		jmp	ArchEnd
@03_LIM_Next:	xor	cx, cx
		mov	word ptr LIM_PackSize[0], cx
		mov	word ptr LIM_PackSize[2], cx
		mov	cx, LIM_HeadSize
		mov	dx, Offset LIM_Header3
		call	BlockRead
		mov	ax, LIM_HeadType
		cmp	ax, 0D180h
		jne	@04_LIM_Next
		mov	si, Offset LIM_ContDir
		mov	di, Offset ArchPath
		mov	cx, FileNameMax
		stc
		call	StrCopy
		mov	dx, LIM_HeadSize
		xor	cx, cx
		call	SeekNext
		jmp	@01_LIM_Next
@04_LIM_Next:	cmp	ax, 0F813h
		jne	@05_LIM_Next
		jmp	ArchEnd
@05_LIM_Next:	cmp	ax, 0F123h
		jne	@07_LIM_Next
		mov	di, Offset FileName
		cmp	ArchPath, 0
		je	@06_LIM_Next
		mov	si, Offset ArchPath
		mov	cx, FileNameMax
		clc
		call	StrCopy
		mov	al, DirSep
		stosb
@06_LIM_Next:	mov	si, Offset LIM_Name
		stc
		call	StrCopy
		mov	dx, LIM_HeadSize
		xor	cx, cx
		add	dx, word ptr LIM_PackSize[0]
		adc	cx, word ptr LIM_PackSize[2]
		call	SeekNext
		mov	eax, LIM_OrigSize
		xor	ebx, ebx
		mov	ecx, LIM_DateTime
		mov	esi, LIM_PackSize
		xor	edi, edi
		xor	edx, edx
		mov	dx, LIM_Attrib
		push	eax
		mov	eax, edx
		call	CheckDir
		pop	eax
		clc
		retn

;"Next entry" routine for RAR archives
RAR_Next:	mov	cx, RAR_HeaderEnd2 - RAR_Header2
		call	ReadHeader
		or	ax, ax
		jne	@08_RAR_Next
@12_RAR_Next:	jmp	ArchEnd
@08_RAR_Next:	mov	al, RAR_HeadType
		cmp	al, 72h
		jae	@03_RAR_Next
@04_RAR_Next:	jmp	ArchError
@03_RAR_Next:	cmp	al, 7Bh
		je	@12_RAR_Next
		ja	@04_RAR_Next
		xor	ecx, ecx
		mov	RAR_PackSize, ecx
		mov	cx, RAR_HeaderEnd4 - RAR_Header3
		mov	dx, Offset RAR_Header3
		cmp	al, 74h
		je	@05_RAR_Next
		mov	cx, RAR_HeaderEnd3 - RAR_Header3
		test	byte ptr RAR_HeadFlags[1], 80h
		je	@06_RAR_Next
@05_RAR_Next:	call	BlockRead
@06_RAR_Next:	cmp	RAR_HeadType, 74h
		jne	@01_RAR_Next
		xor	eax, eax
		mov	RAR_OrigSizeHi, eax
		mov	RAR_PackSizeHi, eax
		test	byte ptr RAR_HeadFlags[1], 01h
		je	@01_RAR_Next
		mov	cx, RAR_HeaderEnd5 - RAR_Header5
		mov	dx, Offset RAR_Header5
		call	BlockRead
@01_RAR_Next:	clc
		call	ReadName
		mov	bl, byte ptr RAR_NameLen[0]
		call	CutName
		mov	dx, RAR_HeadSize
		xor	cx, cx
		add	dx, word ptr RAR_PackSize[0]
		adc	cx, word ptr RAR_PackSize[2]
		call	SeekNext
		xor	cx, cx
		mov	dx, cx
		cmp	RAR_HeadType, 74h
		je	@09_RAR_Next
		mov	byte ptr FileName[0], 0
		jmp	@07_RAR_Next
@09_RAR_Next:	mov	al, byte ptr RAR_HeadFlags[0]
		mov	bx, 0201h
		call	CheckCont
		mov	eax, RAR_OrigSize
		mov	ebx, RAR_OrigSizeHi
		mov	ecx, RAR_DateTime
		mov	esi, RAR_PackSize
		mov	edi, RAR_PackSizeHi
		mov	edx, RAR_Attrib
		cmp	RAR_HostOS, 3
		je	@10_RAR_Next
		cmp	RAR_HostOS, 5
		jne	@07_RAR_Next
@10_RAR_Next:	and	edx, 0000F000h
		cmp	dx, 4000h
		jne	@11_RAR_Next
		or	dl, 10h
@11_RAR_Next:	and	dx, 0010h
@07_RAR_Next:	push	eax
		mov	eax, edx
		call	CheckDir
		pop	eax
		clc
		retn

;"First volume" routine for RAR archives
RAR_FirstV:	mov	HundredsInExt, False
		mov	cx, RAR_HeaderEnd - RAR_Header
		push	cx
		call	ReadHeader
		pop	cx
		mov	si, Offset RAR_Sign
		mov	di, Offset RAR_Header
		cld
		repe	cmpsb
		jne	@01_RAR_FirstV
		mov	dx, RAR_HeaderEnd - RAR_Header
		xor	cx, cx
		call	SeekNext
		mov	cx, RAR_HeaderEnd2 - RAR_Header2
		call	ReadHeader
		or	ax, ax
		stc
		je	@02_RAR_FirstV
		cmp	RAR_HeadType, 73h
		jne	@01_RAR_FirstV
		mov	ax, RAR_HeadFlags
		test	al, 10h
		je	@03_RAR_FirstV
		mov	AltVolNumbering, True
		test	ah, 01h
		stc
		je	@02_RAR_FirstV
@03_RAR_FirstV:	mov	dx, RAR_HeadSize
		xor	cx, cx
		call	SeekNext
		clc
@02_RAR_FirstV:	retn
@01_RAR_FirstV:	jmp	ArchError

;"Next volume" routine for RAR archives
RAR_NextV:	cmp	AltVolNumbering, False
		je	@01_RAR_NextV
		jmp	AltNextVol
@01_RAR_NextV:	xor	ax, ax
		jmp	NextVol

;"Next entry" routine for SQZ archives
SQZ_Next:	cmp	First, False
		je	@01_SQZ_Next
		mov	cx, SQZ_HeaderEnd - SQZ_Header
		call	ReadHeader
		mov	cx, 5
		mov	si, Offset SQZ_Sign
		mov	di, Offset SQZ_HeadSign
		cld
		repe	cmpsb
		je	@02_SQZ_Next
@03_SQZ_Next:	jmp	ArchError
@02_SQZ_Next:	mov	al, SQZ_Flags
		mov	ArchFlags, al
		and	al, 08h
		jne	@03_SQZ_Next
		mov	dx, SQZ_HeaderEnd - SQZ_Header
		xor	cx, cx
		call	SeekNext
@01_SQZ_Next:	mov	cx, SQZ_HeaderEnd2 - SQZ_Header2
		call	ReadHeader
		mov	cl, SQZ_HeadSize
		or	cl, cl
		jne	@04_SQZ_Next
		jmp	ArchEnd
@04_SQZ_Next:	cmp	cl, 18
		ja	@05_SQZ_Next
		mov	cx, SQZ_HeaderEnd3 - SQZ_Header3
		call	ReadHeader
		mov	dx, SQZ_ExtDataSize
		xor	cx, cx
		call	SeekNext
		jmp	@06_SQZ_Next
@05_SQZ_Next:	xor	ch, ch
		push	cx
		inc	cx
		mov	al, SQZ_HeaderEnd4 - SQZ_Header4
		cmp	cl, al
		jbe	@07_SQZ_Next
		mov	cl, al
@07_SQZ_Next:	call	ReadHeader
		test	ArchFlags, 01h
		jne	@08_SQZ_Next
		mov	cx, 3
		mov	si, Offset SQZ_PackSize
		mov	di, si
@09_SQZ_Next:	call	ConvLEnd
		loop	@09_SQZ_Next
		movsb
		call	ConvLEnd
@08_SQZ_Next:	pop	dx
		push	dx
		add	dx, 2
		xor	cx, cx
		add	dx, word ptr SQZ_PackSize[0]
		adc	cx, word ptr SQZ_PackSize[2]
		call	SeekNext
		pop	cx
		sub	cx, 18
		mov	si, Offset SQZ_Name
		mov	di, Offset FileName
		mov	cx, FileNameMax
		stc
		call	StrCopy
		test	ArchFlags, 02h
		jne	@10_SQZ_Next
		mov	ax, word ptr SQZ_DateTime[0]
		mov	dx, word ptr SQZ_DateTime[2]
		mov	si, 1970
		call	UnixToDOS
		mov	ecx, DateTime
		mov	word ptr SQZ_DateTime[0], cx
		mov	word ptr SQZ_DateTime[2], dx
@10_SQZ_Next:	xor	edx, edx
		mov	dl, SQZ_Attrib
		mov	eax, SQZ_OrigSize
		xor	ebx, ebx
		mov	cx, word ptr SQZ_DateTime[0]
		mov	dx, word ptr SQZ_DateTime[2]
		mov	esi, SQZ_PackSize
		xor	edi, edi
@06_SQZ_Next:	clc
		retn

;"Next entry" routine for YAC archives
YAC_Next:	cmp	First, False
		je	@01_YAC_Next
		mov	NoPackSize, True
		mov	cx, YAC_HeaderEnd - YAC_Header
		call	ReadHeader
		cmp	YAC_HeadSign, 'CY'
		je	@02_YAC_Next
		jmp	ArchError
@02_YAC_Next:	xor	eax, eax
		mov	ax, YAC_FileNum
		mov	FileNum, eax
		mov	dx, YAC_HeaderEnd - YAC_Header
		xor	cx, cx
		call	SeekNext
@01_YAC_Next:	mov	eax, FileCount
		add	eax, DirCount
		cmp	eax, FileNum
		jb	@03_YAC_Next
		xor	dx, dx
		mov	cx, dx
		mov	al, 2
		call	SeekArch
		sub	ax, word ptr ArchPos[0]
		sbb	dx, word ptr ArchPos[2]
		mov	word ptr ArchPackAll[0], ax
		mov	word ptr ArchPackAll[2], dx
		xor	eax, eax
		mov	dword ptr ArchPackAll[4], eax
		jmp	ArchEnd
@03_YAC_Next:	mov	cx, YAC_HeaderEnd2 - YAC_Header2
		call	ReadHeader
		clc
		call	ReadName
		mov	bl, byte ptr YAC_NameLen[0]
		call	CutName
		mov	dl, FileNameLen
		xor	dh, dh
		xor	cx, cx
		add	dx, YAC_HeaderEnd2 - YAC_Header2
		call	SeekNext
		mov	eax, YAC_OrigSize
		xor	ebx, ebx
		mov	ecx, YAC_DateTime
		mov	esi, YAC_PackSize
		xor	edi, edi
		xor	edx, edx
		mov	dx, YAC_Attrib
		push	eax
		mov	eax, edx
		call	CheckDir
		pop	eax
		clc
		retn

;"Next entry" routine for ZIP archives
ZIP_Next:	cmp	First, False
		je	@01_ZIP_Next
		mov	si, Offset ZIP_Sign
		mov	cx, 4
		mov	di, Offset ZIP_Header2
		mov	bx, ZIP_HeaderEnd2 - ZIP_Header2
		call	RevSearch
		jc	@03_ZIP_Next
		cmp	ZIP_FileNum, 0
		je	@02_ZIP_Next
		mov	dx, word ptr ZIP_DirOffs[0]
		mov	cx, word ptr ZIP_DirOffs[2]
		call	SeekArch2
		mov	First, False
		jmp	ZIP_Next
@02_ZIP_Next:	jmp	ArchEnd
@03_ZIP_Next:	jmp	ArchError
@01_ZIP_Next:	mov	cx, ZIP_HeaderEnd - ZIP_Header
		call	ReadHeader
		cmp	word ptr ZIP_HeadSign[0], 'KP'
		jne	@03_ZIP_Next
		mov	ax, word ptr ZIP_HeadSign[2]
		cmp	ax, 0605h
		je	@02_ZIP_Next
		cmp	ax, 0201h
		je	@05_ZIP_Next
		cmp	ax, 0505h
		jne	@03_ZIP_Next
		mov	dx, ZIP_HeaderEnd3 - ZIP_Header3
		xor	cx, cx
		add	dx, ZIP_SigSize
		adc	cx, 0
		call	SeekNext
		jmp	@01_ZIP_Next
@05_ZIP_Next:	clc
		call	ReadName
		mov	dx, ZIP_HeaderEnd - ZIP_Header
		xor	cx, cx
		add	dx, ZIP_NameLen
		adc	cx, 0
		add	dx, ZIP_ExtHeadSize
		adc	cx, 0
		add	dx, ZIP_CommentSize
		adc	cx, 0
		call	SeekNext
		mov	eax, ZIP_OrigSize
		xor	ebx, ebx
		mov	ecx, ZIP_DateTime
		mov	esi, ZIP_PackSize
		xor	edi, edi
		mov	edx, ZIP_Attrib
		push	eax
		push	ebx
		mov	bl, byte ptr ZIP_NameLen[0]
		call	CutName
		cmp	byte ptr FileName[bx][-1], '/'
		jne	@04_ZIP_Next
		mov	byte ptr FileName[bx][-1], 0
		call	SetDir
@04_ZIP_Next:	pop	ebx
		pop	eax
		clc
		retn

;"Next entry" routine for ZOO archives
ZOO_Next:	cmp	First, False
		je	@01_ZOO_Next
		mov	NoAttribs, True
		mov	cx, ZOO_HeaderEnd - ZOO_Header
		call	ReadHeader
		mov	cx, 3
		mov	si, Offset ZOO_Sign
		mov	di, Offset ZOO_Header
		cld
		repe	cmpsb
		je	@02_ZOO_Next
@03_ZOO_Next:	jmp	ArchError
@02_ZOO_Next:	mov	dx, word ptr ZOO_StartOffs[0]
		mov	cx, word ptr ZOO_StartOffs[2]
		call	SeekArch2
@01_ZOO_Next:	mov	cx, ZOO_HeaderEnd2 - ZOO_Header2
		call	ReadHeader
		mov	cx, 4
		mov	si, Offset ZOO_Sign2
		mov	di, Offset ZOO_HeadSign3
		cld
		repe	cmpsb
		jne	@03_ZOO_Next
		mov	dx, word ptr ZOO_NextOffs[0]
		mov	cx, word ptr ZOO_NextOffs[2]
		mov	ax, dx
		or	ax, cx
		jne	@04_ZOO_Next
		jmp	ArchEnd
@04_ZOO_Next:	call	SeekArch2
		mov	si, Offset ZOO_Name
		mov	di, Offset FileName
		mov	cx, FileNameMax
		stc
		call	StrCopy
		mov	bx, ArchFile
		mov	eax, ZOO_OrigSize
		xor	ebx, ebx
		mov	ecx, ZOO_DateTimeRev
		ror	ecx, 16
		mov	esi, ZOO_PackSize
		xor	edi, edi
		xor	edx, edx
		clc
		retn

  ;Introductory message
Hello		db	'Archive List and Date Stamp 0.94.4 beta by Joe Forster/STA', 13, 10, 13, 10, '$'
  ;Usage
Usage		db	'This program lists the contents of many archive formats and optionally changes', 13, 10
		db	'archive date stamps to that of the latest file inside.', 13, 10, 13, 10
		db	'Usage: ARCLDS [-|/<options>] <filename>$'
NoArchives	db	'No archives found$'	;No archives error message
Aborted		db	'Program aborted$'	;Program abort message
  ;Display string fragments
TenSpaces	db	'    '
SixSpaces	db	' '
FiveSpaces	db	'   '
TwoSpaces	db	'  ', 0
NotValid	db	' is not a valid ', 0
Damaged		db	' is a damaged ', 0
Archive		db	' archive', 0
Plural		db	's', 0
NoFiles		db	'  No files found', 0
Continue	db	'Press any key to continue...', 0
Listing		db	'Listing', 0
Stamping	db	'Stamping', 0
Colon		db	': ', 0
Percent		db	'% ', 0
File		db	' file', 0
Conjunctive	db	' and ', 0
Directory	db	' director', 0
YSingular	db	'y', 0
YPlural		db	'ies', 0
TotalTitle	db	'Grand total: ', 0
  ;List header
ListTitle	db	' Original   Packed  Ratio  Date     Time    Attr Name', 0
  ;List separator line
Separator	db	'--------- --------- ---- -------- -------- ----- ------------------------------'
  ;Empty string
DummyStr	db	0
  ;Line feed
LineFeed	db	13, 10, '$'
  ;Number of days per month
DaysPerMonth	db	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
  ;Attribute position (first byte) and character (second byte) for each
  ;  attribute bit
AttribDefs	db	0, 0, 0, 0, 1, 'A', 0, 'D', 0, 0, 2, 'S', 3, 'H', 4, 'R'
  ;Archive signatures
ACE_Sign	db	'**ACE**'
CAB_Sign	db	'MSCF'
DWC_Sign	db	'DWC'
HAP_Sign	db	00h, 8Eh, 68h, 4Ah, 57h
HPK_Sign2	db	'`'
HPK_Sign	db	'HPAK'
HYP_Sign	db	1Ah, 'HP'
LIM_Sign	db	'LM', 1Ah
RAR_Sign	db	'Rar!', 1Ah, 7, 0
SQZ_Sign	db	'HLSQZ'
ZIP_Sign	db	'PK', 5, 6
ZOO_Sign	db	'ZOO'
ZOO_Sign2	db	0DCh, 0A7h, 0C4h, 0FDh
  ;Archive extensions, assuming that all are exactly 3 characters long; "#"
  ;  characters match any decimal digit; extensions containing "#" represent
  ;  the pattern of non-first volume of a multi-volume archive, in which case
  ;  the extension of the first volume is the previous extension in this table
ArchExts	db	'ACE', 'C##', 'ARC', 'ARJ'
		db	'A##', 'CAB', 'DWC', 'HA', 0
		db	'HAP', 'HPK', 'HYP', 'LHA'
		db	'LIM', 'LZH', 'PAK', 'RAR'
		db	'R##', 'SQZ', 'YC', 0, 'ZIP'
		db	'ZOO'
  ;Offsets of "next entry" routines for each archive type
NextProgs	dw	ACE_Next, ACE_Next, ARC_Next, ARJ_Next
		dw	ARJ_Next, CAB_Next, DWC_Next, HA_Next
		dw	HAP_Next, HPK_Next, HYP_Next, LHA_Next
		dw	LIM_Next, LHA_Next, ARC_Next, RAR_Next
		dw	RAR_Next, SQZ_Next, YAC_Next, ZIP_Next
		dw	ZOO_Next
  ;Offsets of "first volume" routines for each archive type
FirstVolProgs	dw	NoFirstVol, NoFirstVol, NoFirstVol, NoFirstVol
		dw	NoFirstVol, CAB_FirstV, NoFirstVol, NoFirstVol
		dw	NoFirstVol, NoFirstVol, NoFirstVol, NoFirstVol
		dw	NoFirstVol, NoFirstVol, NoFirstVol, RAR_FirstV
		dw	NoFirstVol, NoFirstVol, NoFirstVol, NoFirstVol
		dw	NoFirstVol
  ;Offsets of "next volume" routines for each archive type
NextVolProgs	dw	ACE_NextV, NoNextVol, NoNextVol, ARJ_NextV
		dw	NoNextVol, CAB_NextV, NoNextVol, NoNextVol
		dw	NoNextVol, NoNextVol, NoNextVol, NoNextVol
		dw	NoNextVol, NoNextVol, NoNextVol, RAR_NextV
		dw	NoNextVol, NoNextVol, NoNextVol, NoNextVol
		dw	NoNextVol

DataStart:

LFNSearchRec		LongSearchRec <?>	;Long file name search record
Buffer		db	BufferMax dup (?)	;Data buffer
NumStrBuffer	db	11 + 1 dup (?)		;Number-to-string conversion
  ;File names
SearchPar	db	LongFileNameMax + 1 dup (?)
OrigArchName	db	LongFileNameMax + 1 dup (?)
FileNameLen	db	?			;Length, preceeding file name
FileName	db	LongFileNameMax + 1 dup (?)
PrevFileName	db	LongFileNameMax + 1 dup (?)
TempFileName	db	LongFileNameMax + 1 dup (?)
NextVolName	db	LongFileNameMax + 1 dup (?)
ArchPath	db	LongFileNameMax + 1 dup (?)
ReadPath	db	LongFileNameMax + 1 dup (?)
ReadFName	db	LongFileNameMax + 1 dup (?)
ReadExt		db	LongFileNameMax + 1 dup (?)
ArchExt		db	LongFileNameMax + 1 dup (?)
ClrLine		db	81 + 1 dup (?)		;Clear complete line
AttribStr	db	5 + 1 dup (?)		;Attributes in string form
Year		dw	?			;Stand alone date stamp
Month		db	?			; components
Day		db	?
Hours		db	?
Minutes		db	?
Seconds		db	?
ThisVolPack	dq	?			;Total packed size in volume
ArchOrigAll	dq	?			;Total original size in volume
ArchPackAll	dq	?			;Total packed size in volume
TotalOrigSize	dq	?			;Grand total original size
TotalPackSize	dq	?			;Grand total packed size
OrigSize	dq	?			;Original size of current file
PackSize	dq	?			;Packed size of current file
ArchPos		dd	?			;Current archive file pointer
ArchPos2	dd	?			;Temp file pointer storage
ArchPosOrig	dd	?			;Temp file pointer storage
ArchPos2Orig	dd	?			;Temp file pointer storage
TotalFileNum	dd	?			;Grand total file number
TotalDirNum	dd	?			;Grand total directory number
TotalArchNum	dd	?			;Grand total archive number
TotalDateTime	dd	?			;Date stamp of latest file
FileCount	dd	?			;Number of current file
DirCount	dd	?			;Number of current directory
ArchCount	dd	?			;Number of current archive
DateTime	dd	?			;Date stamp of current file
FileNum		dd	?			;Total file number in archive
DirNum		dd	?			;Total dir number in archive
ArchNum		dd	?			;Number of volumes in archive
ArchDateTime	dd	?			;Date stamp of archive file
Attrib		dd	?			;Attributes of current file
FileNameOffs	dw	?			;Offset of file name in DTA
LFNSearchHandle	dw	?			;Long name search handle
ArchFile	dw	?			;Archive file handle
ArchExtOffs	dw	?			;Offset of archive extension
NextProg	dw	?			;Offset to "next entry"
FirstVolProg	dw	?			;Offset to "first volume"
NextVolProg	dw	?			;Offset to "next volume"
SearchOffs	dw	?			;Offset of current search char
SearchLen	dw	?			;Length of search string
TargetOffs	dw	?			;Offset of current buffer char
TargetLen	dw	?			;Length of search buffer
BufferSize	dw	?			;Used size of search buffer
MatchLen	dw	?			;Length of matching string
OrigArchAttr	dw	?			;Original attribs of archive
LineCount	db	?			;Current screen line number
ArchFlags	db	?			;Archive file internal flags
VolBaseChar	db	?			;Base char for archive ext
EscHit		db	?			;Escape pressed flag
NoAttribs	db	?			;No attributes flag
NoPackSize	db	?			;No packed file sizes flag
SkipDirs	db	?			;Ignore directories flag
GrandTotal	db	?			;Display grand total flag
LongLines	db	?			;Display full file names flag
Pause		db	?			;Pause each screenful flag
StampDate	db	?			;Stamp archive dates flag
MultiVolumes	db	?			;Multi-volume archives flag
ScreenHeight	db	?			;Height of screen
IsDirectory	db	?			;File is a directory flag
Found		db	?			;Any archives found flag
ArchOpened	db	?			;Archive has been opened flag
FirstVolume	db	?			;Archive is first volume flag
First		db	?			;File is first in archive flag
Error		db	?			;Error occurred flag
EndOfFile	db	?			;End of archive reached flag
FeedLine	db	?			;Line feed printed flag
PrintHeader	db	?			;List header printed flag
ContOnNext	db	?			;File cont on next vol flag
ContFromPrev	db	?			;File cont from prev vol flag
SumOrigSizes	db	?			;Sum orig sizes in vols flag
SearchFirst	db	?			;First read during search flag
CheckContName	db	?			;Check spanned file names flag
HundredsInExt	db	?			;Digit may start vol ext flag
AltVolNumbering	db	?			;Alternative vol nums flag

;Header buffers for each archive type, laid over each other to conserve memory
Header:
		org	Header
ACE_Header:
ACE_HeadCheck	dw	?
ACE_HeadSize	dw	?
ACE_HeadType	db	?
ACE_HeadFlags	dw	?
ACE_HeaderEnd:
ACE_AddSize	dd	?
ACE_Header2:
ACE_HeadSign	db	7 dup (?)
ACE_VerExtract	db	?
ACE_Version	db	?
ACE_HostOS	db	?
ACE_VolumeNum	db	?
ACE_ArcDateTime	dd	?
ACE_Reserved	db	8 dup (?)
ACE_HeaderEnd2:
		org	ACE_HeaderEnd
ACE_Header3:
ACE_PackSize	dd	?
ACE_OrigSize	dd	?
ACE_DateTime	dd	?
ACE_Attrib	dd	?
ACE_Check	dd	?
ACE_TechInfo	dd	?
ACE_Reserved2	db	2 dup (?)
ACE_NameLen	dw	?
ACE_Name	db	LongFileNameMax dup (?)
ACE_HeaderEnd3:

		org	Header
ARC_Header:
ARC_HeadSign	db	?
ARC_Method	db	?
ARC_Name	db	13 dup (?)
ARC_PackSize	dd	?
ARC_DateTimeRev	dd	?
ARC_Check	dw	?
ARC_OrigSize	dd	?
ARC_HeaderEnd:

		org	Header
ARJ_Header:
ARJ_HeadSign	dw	?
ARJ_HeadSize	dw	?
ARJ_FirstHdr	db	?
ARJ_Version	db	?
ARJ_VerExtract	db	?
ARJ_HostOS	db	?
ARJ_HeadFlags	db	?
ARJ_Method	db	?
ARJ_FileType	db	?
ARJ_Reserved	db	?
ARJ_DateTime	dd	?
ARJ_PackSize	dd	?
ARJ_OrigSize	dd	?
ARJ_Check	dd	?
ARJ_FileSpec	dw	?
ARJ_Attrib	dw	?
ARJ_HostData	dw	?
ARJ_HeaderEnd:
ARJ_Header2:
ARJ_ExtFilePos	dd	?
ARJ_HeaderEnd2:
		org	Header
ARJ_Header3:
ARJ_HeadCheck	dd	?
ARJ_ExtHeadSize	dw	?
ARJ_HeaderEnd3:

		org	Header
CAB_Header:
CAB_HeadSign	dd	?
CAB_Unknown1	db	4 dup (?)
CAB_ArchSize	dd	?
CAB_Unknown2	db	4 dup (?)
CAB_DirOffs	dd	?
CAB_Unknown3	db	6 dup (?)
CAB_FieldNum	dw	?
CAB_FileNum	dw	?
CAB_ArchFlags	dw	?
CAB_Unknown4	db	2 dup (?)
CAB_VolNum	dw	?
CAB_HeaderEnd:
		org	Header
CAB_Header2:
CAB_StartPos	dd	?
CAB_Unknown5	db	4 dup (?)
CAB_HeaderEnd2:
		org	Header
CAB_Header3:
CAB_OrigSize	dd	?
CAB_Unknown6	db	4 dup (?)
CAB_HeadFlags	dw	?
CAB_DateTimeRev	dd	?
CAB_Attrib	dw	?
CAB_HeaderEnd3:

		org	Header
DWC_Header:
DWC_Unknown1	db	16 dup (?)
DWC_ArchSeconds	dd	?
DWC_FileNum	dw	?
DWC_Unknown2	db	2 dup (?)
DWC_HeadSign	db	3 dup (?)
DWC_HeaderEnd:
		org	Header
DWC_Header2:
DWC_Name	db	13 dup (?)
DWC_OrigSize	dd	?
DWC_Seconds	dd	?
DWC_PackSize	dd	?
DWC_Offset	dd	?
DWC_Method	db	?
DWC_CommentLen	dw	?
DWC_Check	dw	?
DWC_HeaderEnd2:

		org	Header
HA_Header:
HA_HeadSign	dw	?
HA_FileNum	dw	?
HA_HeaderEnd:
		org	Header
HA_Header2:
HA_Ver_N_Type	db	?
HA_PackSize	dd	?
HA_OrigSize	dd	?
HA_Check	dd	?
HA_DateTime	dd	?
HA_HeaderEnd2:

		org	Header
HAP_Header:
HAP_HeadSign	db	4 dup (?)
HAP_Unknown1	db	10 dup (?)
HAP_HeaderEnd:
		org	Header
HAP_Header2:
HAP_HeadSign2	db	5 dup (?)
HAP_PackSize	dd	?
HAP_Unknown2	db	9 dup (?)
HAP_Attrib	db	?
HAP_DateTime	dd	?
HAP_OrigSize	dd	?
HAP_Name	db	13 dup (?)
HAP_HeaderEnd2:

		org	Header
HPK_Header:
HPK_HeadSign1	db	4 dup (?)
HPK_HeaderEnd:
		org	Header
HPK_Header2:
HPK_DirNum	dw	?
HPK_FileNum	dw	?
HPK_HeadSize	dd	?
HPK_HeadCheck	dw	?
HPK_HeadSign2	db	5 dup (?)
HPK_HeaderEnd2:
		org	Header
HPK_Header3:
HPK_HeadType	db	?
HPK_Unknown	db	?
HPK_ContainDir	dw	?
HPK_Seconds	dd	?
HPK_OrigSize	dd	?
HPK_PackSize	dd	?
HPK_HeaderEnd3:

		org	Header
HYP_Header:
HYP_HeadSign	db	3 dup (?)
HYP_Version	db	?
HYP_PackSize	dd	?
HYP_OrigSize	dd	?
HYP_DateTime	dd	?
HYP_Check	dd	?
HYP_Attrib	db	?
HYP_HeaderEnd:

		org	Header
LHA_Header:
LHA_HeadSize	db	?
LHA_HeadCheck	db	?
LHA_HeaderEnd:
LHA_Header2:
LHA_Method	db	5 dup (?)
LHA_PackSize	dd	?
LHA_OrigSize	dd	?
LHA_DateTime	dd	?
LHA_Attrib	db	?
LHA_HeadFlags	db	?
LHA_HeaderEnd2:
LHA_Header3:
LHA_Check	db	2 dup (?)
LHA_Unknown	db	4 dup (?)
LHA_HeaderEnd3:
LHA_Header4:
LHA_ExtHeadSize	dw	?
LHA_HeaderEnd4:
LHA_Header5:
LHA_ExtHead	db	LongFileNameMax + 1 dup (?)
LHA_HeaderEnd5:

		org	Header
LIM_Header:
LIM_HeadSign	db	3 dup (?)
LIM_Unknown1	db	2 dup (?)
LIM_Version	db	?
LIM_Unknown2	db	2 dup (?)
LIM_HeaderEnd:
		org	Header
LIM_Header2:
LIM_HeadType	dw	?
LIM_HeadSize	dw	?
LIM_HeaderEnd2:
LIM_Header3:
LIM_ContDir	db	LongFileNameMax + 1 dup (?)
LIM_HeaderEnd3:
		org	LIM_Header3
LIM_Header4:
LIM_Unknown3	dw	?
LIM_DateTime	dd	?
LIM_Attrib	dw	?
LIM_Method	db	?
LIM_OrigSize	dd	?
LIM_PackSize	dd	?
LIM_Check	dd	?
LIM_Name	db	LongFileNameMax + 1 dup (?)
LIM_HeaderEnd4:

		org	Header
RAR_Header:
RAR_HeadSign	db	7 dup (?)
RAR_HeaderEnd:
		org	Header
RAR_Header2:
RAR_HeadCheck	dw	?
RAR_HeadType	db	?
RAR_HeadFlags	dw	?
RAR_HeadSize	dw	?
RAR_HeaderEnd2:
RAR_Header3:
RAR_PackSize	dd	?
RAR_HeaderEnd3:
RAR_Header4:
RAR_OrigSize	dd	?
RAR_HostOS	db	?
RAR_Check	dd	?
RAR_DateTime	dd	?
RAR_VerExtract	db	?
RAR_Method	db	?
RAR_NameLen	dw	?
RAR_Attrib	dd	?
RAR_HeaderEnd4:
RAR_Header5:
RAR_PackSizeHi	dd	?
RAR_OrigSizeHi	dd	?
RAR_HeaderEnd5:

		org	Header
SQZ_Header:
SQZ_HeadSign	db	5 dup (?)
SQZ_Version	db	?
SQZ_HostOS	db	?
SQZ_Flags	db	?
SQZ_HeaderEnd:
		org	Header
SQZ_Header2:
SQZ_HeadSize	db	?
SQZ_HeaderEnd2:
		org	Header
SQZ_Header3:
SQZ_ExtDataSize	dw	?
SQZ_HeaderEnd3:
		org	Header
SQZ_Header4:
SQZ_HeadCheck	db	?
SQZ_Method	db	?
SQZ_PackSize	dd	?
SQZ_OrigSize	dd	?
SQZ_DateTime	dd	?
SQZ_Attrib	db	?
SQZ_Check	dd	?
SQZ_Name	db	FileNameMax + 1 dup (?)
SQZ_HeaderEnd4:

		org	Header
YAC_Header:
YAC_Unknown1	db	4 dup (?)
YAC_ArchSize	dd	?
YAC_Unknown2	db	6 dup (?)
YAC_HeadSign	dw	?
YAC_Unknown3	db	4 dup (?)
YAC_FileNum	dw	?
YAC_Unknown4	db	32 dup (?)
YAC_HeaderEnd:
		org	Header
YAC_Header2:
YAC_Unknown5	db	?
YAC_NameLen	dw	?
YAC_DateTime	dd	?
YAC_Attrib	dw	?
YAC_OrigSize	dd	?
YAC_PackSize	dd	?
YAC_Unknown6	db	2 dup (?)
YAC_HeaderEnd2:

		org	Header
ZIP_Header:
ZIP_HeadSign	db	4 dup (?)
ZIP_VerCreated	dw	?
ZIP_VerExtract	dw	?
ZIP_HeadFlag	dw	?
ZIP_Method	dw	?
ZIP_DateTime	dd	?
ZIP_Check	dd	?
ZIP_PackSize	dd	?
ZIP_OrigSize	dd	?
ZIP_NameLen	dw	?
ZIP_ExtHeadSize	dw	?
ZIP_CommentSize	dw	?
ZIP_StartVol	dw	?
ZIP_IntAttr	dw	?
ZIP_Attrib	dd	?
ZIP_HeadOffs	dd	?
ZIP_HeaderEnd:
		org	Header
ZIP_Header2:
ZIP_HeadSign2	db	4 dup (?)
ZIP_VolNumber	dw	?
ZIP_LastVol	dw	?
ZIP_LocFileNum	dw	?
ZIP_FileNum	dw	?
ZIP_DirSize	dd	?
ZIP_DirOffs	dd	?
ZIP_ArchCmtSize	dw	?
ZIP_HeaderEnd2:
		org	Header
ZIP_Header3:
ZIP_HeadSign3	db	4 dup (?)
ZIP_SigSize	dw	?
ZIP_HeaderEnd3:

		org	Header
ZOO_Header:
ZOO_HeadSign	db	20 dup (?)
ZOO_HeadSign2	db	4 dup (?)
ZOO_StartOffs	dd	?
ZOO_HeaderEnd:
		org	Header
ZOO_Header2:
ZOO_HeadSign3	db	4 dup (?)
ZOO_Type	db	?
ZOO_Method	db	?
ZOO_NextOffs	dd	?
ZOO_Offset	dd	?
ZOO_DateTimeRev	dd	?
ZOO_Check	dw	?
ZOO_OrigSize	dd	?
ZOO_PackSize	dd	?
ZOO_VerExtract	dw	?
ZOO_Deleted	db	?
ZOO_Structure	db	?
ZOO_CommentOffs	dd	?
ZOO_CommentLen	dw	?
ZOO_Name	db	13 dup (?)
ZOO_ExtHeadSize	dw	?
ZOO_TimeZone	db	?
ZOO_HeadCheck	dw	?
ZOO_HeaderEnd2:

HeaderEnd:

DataEnd:

CSeg		ends

		end	Main
