;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                     BFC.ASM                     
;                                                 
;               Binary File Compare               
;

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

		jumps

False		equ	0
True		equ	1

BufferSize	equ	64512
ProgramSize	equ	40960
LongFileNameMax	equ	255

LongSearchRec	struc
lsAttr		dd	?
lsCreateDate	dd	?, ?
lsAccessDate	dd	?, ?
lsModifyDate	dd	?, ?
lsSizeHi	dd	?
lsSize		dd	?
lsReserved	db	8 dup (?)
lsName		db	260 dup (?)
lsShortName	db	14 dup (?)
LongSearchRec	ends

Main:		mov	ax, ds:[0006h]
		cmp	ax, ProgramSize
		jbe	@09
		mov	bx, ProgramSize / 16
		mov	ah, 4Ah
		int	21h
		mov	sp, ProgramSize
		xor	ax, ax
		push	ax
@09:		mov	di, Offset DataStart
		mov	cx, DataEnd - DataStart
		xor	al, al
		cld
		rep	stosb
		mov	dx, Offset Hello
		mov	ah, 9
		int	21h
		mov	FindAttr, 21h
		mov	bl, -1
		xor	di, di
		call	ParamStr
		cmp	bh, 2
		jae	@01
		mov	ErrorLevel, 4
		mov	dx, Offset Usage
		mov	ah, 9
		int	21h
		jmp	@02
@01:		mov	bl, 3
@08:		mov	di, Offset Parameter
		mov	cx, LongFileNameMax
		call	ParamStr
		cmp	bh, bl
		jne	@05
		mov	si, Offset Parameter
		lodsb
		cmp	al, '-'
		je	@06
		cmp	al, '/'
		jne	@07
@06:		lodsb
		or	al, al
		je	@07
		call	UpCase
		cmp	al, 'F'
		jne	@11
		mov	NoNotFound, True
		jmp	@06
@11:		cmp	al, 'H'
		jne	@14
		mov	FindAttr, 27h
		jmp	@06
@14:		cmp	al, 'P'
		jne	@12
		mov	NoPercent, True
		jmp	@06
@12:		cmp	al, 'Q'
		jne	@13
		mov	Quiet, True
		jmp	@06
@13:		cmp	al, 'S'
		jne	@04
		mov	Subdirs, True
		jmp	@06
@04:		cmp	al, 'L'
		jne	@06
		mov	LongLines, True
		jmp	@06
@07:		inc	bl
		jmp	@08
@05:		push	es
		mov	ax, 0040h
		mov	es, ax
		mov	ax, es:[004Ah]
		pop	es
		mov	ScreenWidth, ax
		mov	bl, 2
		mov	di, Offset Parameter
		mov	cx, LongFileNameMax
		call	ParamStrX
		mov	si, Offset Parameter
		mov	di, Offset Dir2
		mov	bx, Offset Name2
		mov	bp, Offset Ext2
		call	SplitName
		mov	bl, 1
		mov	di, Offset Parameter
		mov	cx, LongFileNameMax
		call	ParamStrX
		mov	si, Offset Parameter
		mov	di, Offset Dir1
		mov	bx, Offset Name1
		mov	bp, Offset Ext1
		call	SplitName
		mov	ax, Offset Dir1
		push	ax
		mov	ax, Offset Dir2
		push	ax
		call	ListDir
		cmp	FilesFound, False
		jne	@10
		mov	bx, Offset Parameter
		mov	dx, Offset FName1
		mov	cx, ScreenWidth
		sub	cx, 11
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset NotFound
		jmp	@03
@10:		cmp	FilesCompared, False
		jne	@02
		mov	dx, Offset NotCompared
@03:		mov	ah, 9
		int	21h
		or	ErrorLevel, 2
@02:		mov	al, ErrorLevel
		mov	ah, 4Ch
		int	21h

ListDir		proc	pascal near ArgPath1: word, ArgPath2: word
		local	Path1:byte:LongFileNameMax + 1
		local	Path2:byte:LongFileNameMax + 1
		local	FileNameOffs:Word
		local	LFNSearchHandle:Word
		local	LFNSearchRec:LongSearchRec
		cld
		lea	di, Path1
		mov	si, ArgPath1
		mov	cx, LongFileNameMax
		stc
		call	StrCopy
		lea	di, Path2
		mov	si, ArgPath2
		mov	cx, LongFileNameMax
		stc
		call	StrCopy
		lea	dx, LFNSearchRec
		mov	ah, 1Ah
		int	21h
		mov	di, Offset FName1
		mov	cx, LongFileNameMax
		lea	si, Path1
		clc
		call	StrCopy
		mov	si, Offset Name1
		clc
		call	StrCopy
		mov	si, Offset Ext1
		stc
		call	StrCopy
		mov	dx, Offset FName1
		mov	cx, FindAttr
		lea	di, LFNSearchRec
		call	FindFirst
		mov	LFNSearchHandle, ax
		mov	FileNameOffs, bx
		jnc	@01_ListDir
		jmp	@41_ListDir
@01_ListDir:	mov	FilesFound, True
		mov	si, FileNameOffs
		xor	di, di
		mov	bx, Offset NameTemp
		mov	dx, Offset ExtTemp
		call	FSplit
		mov	di, Offset FName1
		mov	cx, LongFileNameMax
		lea	si, Path1
		clc
		call	StrCopy
		mov	si, Offset NameTemp
		clc
		call	StrCopy
		mov	si, Offset ExtTemp
		stc
		call	StrCopy
		mov	di, Offset FName2
		mov	cx, LongFileNameMax
		lea	si, Path2
		clc
		call	StrCopy
		mov	si, Offset Name2
		mov	bx, Offset NameTemp
		clc
		call	CloneName
		mov	si, Offset Ext2
		mov	bx, Offset ExtTemp
		stc
		call	CloneName
		mov	dx, Offset FName1
		xor	al, al
		call	OpenFile
		jnc	@03_ListDir
		jmp	@04_ListDir
@03_ListDir:	mov	si, ax
		push	si
		lea	dx, LFNSearchRec2
		mov	ah, 1Ah
		int	21h
		mov	dx, Offset FName2
		mov	cx, FindAttr
		mov	di, Offset LFNSearchRec2
		call	FindFirst
		pop	si
		pushf
		lea	dx, LFNSearchRec
		mov	ah, 1Ah
		int	21h
		popf
		jc	@42_ListDir
		push	si
		push	bx
		mov	bx, ax
		call	FindClose
		mov	di, Offset FName2
		mov	cx, LongFileNameMax
		lea	si, Path2
		clc
		call	StrCopy
		pop	si
		stc
		call	StrCopy
		pop	si
		push	si
		mov	dx, Offset FName2
		xor	al, al
		call	OpenFile
		pop	si
		jnc	@06_ListDir
@42_ListDir:	or	ErrorLevel, 2
		cmp	NoNotFound, False
		jne	@35_ListDir
		call	PrintComp
		mov	dx, Offset Indent
		mov	ah, 9
		int	21h
		mov	bx, Offset FName2
		mov	dx, Offset Parameter
		mov	cx, 67
		clc
		call	PrintStr
		mov	dx, Offset NotFound
		mov	ah, 9
		int	21h
@35_ListDir:	jmp	@05_ListDir
@06_ListDir:	mov	di, ax
		call	PrintComp
		mov	FilesCompared, True
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jc	@09_ListDir
		mov	Buffer1, ax
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jnc	@10_ListDir
@09_ListDir:	mov	dx, Offset NoMemory
		jmp	@03
@10_ListDir:	mov	Buffer2, ax
		mov	bx, si
		mov	ax, 4202h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	word ptr Length1[0], ax
		mov	word ptr Length1[2], dx
		mov	ax, 4200h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	bx, di
		mov	ax, 4202h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	word ptr Length2[0], ax
		mov	word ptr Length2[2], dx
		mov	ax, 4200h
		xor	cx, cx
		xor	dx, dx
		int	21h
		mov	ax, word ptr Length1[0]
		mov	dx, word ptr Length1[2]
		mov	bx, word ptr Length2[0]
		mov	cx, word ptr Length2[2]
		cmp	dx, cx
		ja	@08_ListDir
		jne	@07_ListDir
		cmp	ax, bx
		jbe	@07_ListDir
@08_ListDir:	mov	ax, bx
		mov	dx, cx
@07_ListDir:	mov	word ptr ReadLen[0], ax
		mov	word ptr ReadLen[2], dx
		xor	ax, ax
		mov	word ptr Diff[0], ax
		mov	word ptr Diff[2], ax
		mov	word ptr Pos[0], ax
		mov	word ptr Pos[2], ax
		cmp	NoPercent, False
		jne	@33_ListDir
		call	Percent
@33_ListDir:	call	Escape
@17_ListDir:	cmp	EscHit, False
		je	@21_ListDir
		jmp	@11_ListDir
@21_ListDir:	mov	ax, word ptr ReadLen[0]
		mov	dx, word ptr ReadLen[2]
		mov	bx, word ptr Pos[0]
		mov	cx, word ptr Pos[2]
		sub	ax, bx
		sbb	dx, cx
		jnc	@18_ListDir
		jmp	@11_ListDir
@18_ListDir:	or	dx, dx
		jne	@12_ListDir
		or	ax, ax
		jne	@19_ListDir
		jmp	@11_ListDir
@19_ListDir:	cmp	ax, BufferSize
		jbe	@13_ListDir
@12_ListDir:	mov	ax, BufferSize
@13_ListDir:	mov	cx, ax
		mov	bx, si
		mov	ax, Buffer1
		call	BlockRead
		mov	bx, di
		mov	ax, Buffer2
		call	BlockRead
		call	Escape
		cmp	EscHit, False
		je	@26_ListDir
		jmp	@11_ListDir
@26_ListDir:	xor	bx, bx
@16_ListDir:	push	ds
		mov	ds, cs:Buffer1
		mov	al, [bx]
		mov	ds, cs:Buffer2
		mov	ah, [bx]
		pop	ds
		cmp	al, ah
		je	@14_ListDir
		or	ErrorLevel, 1
		push	cx
		push	bx
		cmp	Quiet, False
		jne	@22_ListDir
		push	ax
		mov	dx, Offset Indent
		mov	ah, 9
		int	21h
		mov	ax, word ptr Pos[0]
		mov	dx, word ptr Pos[2]
		mov	cx, 0830h
		call	HexStr
		clc
		call	PrintStr
		mov	dx, Offset Colon
		mov	ah, 9
		int	21h
		pop	ax
		push	ax
		xor	ah, ah
		xor	dx, dx
		mov	cx, 0230h
		call	HexStr
		clc
		call	PrintStr
		mov	dl, ' '
		mov	ah, 2
		int	21h
		pop	ax
		mov	al, ah
		xor	ah, ah
		xor	dx, dx
		mov	cx, 0230h
		call	HexStr
		stc
		call	PrintStr
@22_ListDir:	inc	word ptr Diff[0]
		jne	@20_ListDir
		inc	word ptr Diff[2]
		call	Escape
@20_ListDir:	pop	bx
		pop	cx
@14_ListDir:	inc	bx
		inc	word ptr Pos[0]
		jne	@15_ListDir
		inc	word ptr Pos[2]
@15_ListDir:	dec	cx
		je	@27_ListDir
		jmp	@16_ListDir
@27_ListDir:	cmp	NoPercent, False
		jne	@34_ListDir
		call	Percent
@34_ListDir:	jmp	@17_ListDir
@11_ListDir:	push	es
		mov	es, Buffer1
		mov	ah, 49h
		int	21h
		mov	es, Buffer2
		mov	ah, 49h
		int	21h
		pop	es
		xor	al, al
		cmp	EscHit, False
		je	@32_ListDir
		jmp	@02_ListDir
@32_ListDir:	mov	ax, word ptr Diff[0]
		mov	dx, word ptr Diff[2]
		or	ax, dx
		je	@23_ListDir
		mov	dx, Offset Indent
		mov	ah, 9
		int	21h
		mov	bx, Offset FName1
		mov	dx, Offset Parameter
		mov	cx, ScreenWidth
		sub	cx, 34
		shr	cx, 1
		push	cx
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset Conjunctive
		mov	ah, 9
		int	21h
		mov	bx, Offset FName2
		mov	dx, Offset Parameter
		pop	cx
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset Differ
		mov	ah, 9
		int	21h
		mov	ax, word ptr Diff[0]
		mov	dx, word ptr Diff[2]
		call	DecStr
		clc
		call	PrintStr
		mov	dx, Offset Bytes
		mov	ah, 9
		int	21h
		mov	ax, word ptr Diff[0]
		mov	dx, word ptr Diff[2]
		or	dx, dx
		jne	@24_ListDir
		cmp	ax, 1
		je	@25_ListDir
@24_ListDir:	mov	dl, 's'
		mov	ah, 2
		int	21h
@25_ListDir:	mov	dx, Offset LineFeed
		mov	ah, 9
		int	21h
@23_ListDir:	mov	bx, Offset FName1
		mov	cx, Offset FName2
		mov	ax, word ptr ReadLen[0]
		mov	dx, word ptr ReadLen[2]
		cmp	dx, word ptr Length1[2]
		ja	@29_ListDir
		jne	@30_ListDir
		cmp	ax, word ptr Length1[0]
		jae	@29_ListDir
@30_ListDir:	call	PrintLonger
		jmp	@31_ListDir
@29_ListDir:	cmp	dx, word ptr Length2[2]
		ja	@31_ListDir
		jne	@28_ListDir
		cmp	ax, word ptr Length2[0]
		jae	@31_ListDir
@28_ListDir:	xchg	bx, cx
		call	PrintLonger
@31_ListDir:	cmp	NoPercent, False
		jne	@39_ListDir
		call	ClrLine
@39_ListDir:	mov	bx, di
		call	CloseFile
@05_ListDir:	mov	bx, si
		call	CloseFile
@04_ListDir:	cmp	EscHit, False
		jne	@02_ListDir
		mov	bx, LFNSearchHandle
		lea	di, LFNSearchRec
		call	FindNext
		jc	@02_ListDir
		jmp	@01_ListDir
@02_ListDir:	mov	bx, LFNSearchHandle
		call	FindClose
@41_ListDir:	call	Escape
		cmp	EscHit, False
		jne	@36_ListDir
		cmp	Subdirs, False
		je	@36_ListDir
		mov	di, Offset FName1
		mov	cx, LongFileNameMax
		lea	si, Path1
		clc
		call	StrCopy
		mov	si, Offset AllFiles
		stc
		call	StrCopy
		mov	dx, Offset FName1
		mov	cx, 37h
		lea	di, LFNSearchRec
		call	FindFirst
		mov	LFNSearchHandle, ax
		mov	FileNameOffs, bx
		jc	@36_ListDir
@38_ListDir:	mov	di, FileNameOffs
		cmp	byte ptr [di], '.'
		jne	@40_ListDir
		cmp	byte ptr [di][1], 0
		je	@37_ListDir
		cmp	word ptr [di][1], '.'
		je	@37_ListDir
@40_ListDir:	mov	di, Offset FName1
		mov	cx, LongFileNameMax
		lea	si, Path1
		clc
		call	StrCopy
		mov	si, FileNameOffs
		clc
		call	StrCopy
		mov	ax, '\'
		stosw
		mov	di, Offset FName2
		mov	cx, LongFileNameMax
		lea	si, Path2
		clc
		call	StrCopy
		mov	si, FileNameOffs
		clc
		call	StrCopy
		mov	ax, '\'
		stosw
		mov	ax, Offset FName1
		push	ax
		mov	ax, Offset FName2
		push	ax
		call	ListDir
		call	Escape
		cmp	EscHit, False
		jne	@36_ListDir
		lea	dx, LFNSearchRec
		mov	ah, 1Ah
		int	21h
@37_ListDir:	mov	bx, LFNSearchHandle
		lea	di, LFNSearchRec
		call	FindNext
		jnc	@38_ListDir
		mov	bx, LFNSearchHandle
		call	FindClose
@36_ListDir:	ret
		endp

FindFirst:	xor	ch, ch
		mov	si, 1
		mov	ax, 714Eh
		stc
		int	21h
		jnc	@02_FindFirst
		cmp	ax, 7100h
		stc
		jne	@01_FindFirst
		mov	ah, 4Eh
		int	21h
		lea	bx, [di][001Eh]
		jmp	@01_FindFirst
@02_FindFirst:	lea	bx, [di].LongSearchRec.lsName
@01_FindFirst:	retn

FindNext:	mov	si, 1
		mov	ax, 714Fh
		stc
		int	21h
		jnc	@01_FindNext
		cmp	ax, 7100h
		stc
		jne	@01_FindNext
		mov	ah, 4Fh
		int	21h
@01_FindNext:	retn

FindClose:	mov	ax, 71A1h
		int	21h
		retn

OpenFile:	mov	ah, 40h
		mov	si, 0001h
		or	al, al
		je	@01_OpenFile
		mov	ah, 20h
		cmp	al, 2
		je	@01_OpenFile
		mov	si, 0012h
@01_OpenFile:	mov	bl, al
		xor	bh, bh
		xchg	si, dx
		xor	di, di
		push	cx
		xor	cx, cx
		mov	ax, 716Ch
		stc
		int	21h
		pop	cx
		jnc	@02_OpenFile
		cmp	ax, 7100h
		je	@03_OpenFile
		cmp	ax, 5
		stc
		jne	@02_OpenFile
		and	bl, 0Fh
		xor	cx, cx
		stc
		mov	ax, 716Ch
		int	21h
		jmp	@02_OpenFile
@03_OpenFile:	mov	dx, si
		mov	al, bl
		mov	ah, 3Ch
		cmp	al, 1
		je	@04_OpenFile
		mov	ah, 3Dh
		xor	cx, cx
@04_OpenFile:	push	ax
		int	21h
		pop	bx
		jnc	@02_OpenFile
		cmp	ax, 5
		stc
		jne	@02_OpenFile
		mov	ax, bx
		and	al, 0Fh
		int	21h
@02_OpenFile:	retn

CloseFile:	mov	ah, 3Eh
		int	21h
		retn

PrintLonger:	or	ErrorLevel, 1
		push	cx
		push	bx
		mov	dx, Offset Indent
		mov	ah, 9
		int	21h
		pop	bx
		mov	dx, Offset Parameter
		mov	cx, ScreenWidth
		sub	cx, 20
		push	cx
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset Longer
		mov	ah, 9
		int	21h
		pop	cx
		pop	bx
		mov	dx, Offset Parameter
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset LineFeed
		mov	ah, 9
		int	21h
		retn

PrintComp:	mov	dx, Offset Comparing
		mov	ah, 9
		int	21h
		mov	bx, Offset FName1
		mov	dx, Offset Parameter
		mov	cx, ScreenWidth
		sub	cx, 16
		shr	cx, 1
		push	cx
		call	MakeName
		clc
		call	PrintStr
		mov	dx, Offset Conjunctive
		mov	ah, 9
		int	21h
		mov	bx, Offset FName2
		mov	dx, Offset Parameter
		pop	cx
		call	MakeName
		stc
		jmp	PrintStr


BlockRead:	push	ds
		push	dx
		mov	ds, ax
		xor	dx, dx
		mov	ah, 3Fh
		int	21h
		pop	dx
		pop	ds
		retn

Escape:		mov	ah, 1
		int	16h
		je	@01_Escape
		xor	ah, ah
		int	16h
		cmp	ax, 011Bh
		jne	@01_Escape
		mov	EscHit, True
@01_Escape:	retn

ClrLine:	mov	dl, 13
		mov	ah, 2
		int	21h
		mov	cx, 79
		mov	dl, ' '
@01_ClrLine:	int	21h
		loop	@01_ClrLine
		mov	dl, 13
		mov	ah, 2
		int	21h
		retn

Percent:	mov	ax, word ptr ReadLen[0]
		mov	dx, word ptr ReadLen[2]
		mov	cx, 100
		xor	bx, bx
		call	LongDiv
		jc	@01_Percent
		or	ax, ax
		jne	@02_Percent
		or	dx, dx
		je	@03_Percent
@02_Percent:	mov	cx, ax
		mov	bx, dx
		mov	ax, word ptr Pos[0]
		mov	dx, word ptr Pos[2]
		call	LongDiv
		cmp	al, 100
		jbe	@04_Percent
@03_Percent:	mov	al, 100
@04_Percent:	push	ax
		mov	dl, ' '
		mov	ah, 2
		int	21h
		pop	ax
		xor	dx, dx
		mov	bx, 10
		mov	cx, 0320h
		call	NumStr
		call	PrintStr
		cmp	al, 100
		mov	dx, Offset Complete
		mov	ah, 9
		int	21h
@01_Percent:	retn

HexStr:		mov	bx, 10h
		jmp	NumStr
DecStr:		mov	bx, 10
		xor	cx, cx
NumStr:		push	si
		push	di
		push	cx
		mov	si, bx
		mov	di, Offset NumStrBuffer[10]
		mov	byte ptr [di], 0
		mov	cx, di
		mov	bx, dx
@01_NumStr:	xor	dx, dx
		xchg	bx, ax
		div	si
		xchg	bx, ax
		div	si
		add	dl, '0'
		cmp	dl, '9'
		jbe	@02_NumStr
		add	dl, 'A' - '0' - 10
@02_NumStr:	dec	di
		mov	[di], dl
		mov	dx, ax
		or	dx, bx
		jne	@01_NumStr
		sub	cx, di
		pop	bx
		or	bh, bh
		je	@03_NumStr
		sub	bh, cl
		jbe	@03_NumStr
@04_NumStr:	dec	di
		mov	byte ptr [di], bl
		inc	cx
		dec	bh
		jne	@04_NumStr
@03_NumStr:	mov	dx, di
		pop	di
		pop	si
		retn

FSplit:		push	dx
		mov	dx, si
		call	StrLen
		add	si, ax
		dec	si
		xor	cx, cx
		std
@04_FSplit:	cmp	si, dx
		jb	@01_FSplit
		lodsb
		cmp	al, '.'
		jne	@02_FSplit
		or	cx, cx
		jne	@02_FSplit
		mov	cx, si
		inc	cx
@02_FSplit:	cmp	al, '\'
		je	@03_FSplit
		cmp	al, ':'
		jne	@04_FSplit
@03_FSplit:	inc	si
@01_FSplit:	inc	si
		or	cx, cx
		jne	@05_FSplit
		mov	cx, dx
		xchg	si, dx
		call	StrLen
		xchg	si, dx
		add	cx, ax
@05_FSplit:	xchg	si, dx
		sub	cx, dx
		sub	dx, si
		push	cx
		mov	cx, LongFileNameMax
		stc
		call	StrPartCopy
		mov	di, bx
		pop	dx
		mov	cx, LongFileNameMax
		stc
		call	StrPartCopy
		pop	di
		mov	cx, LongFileNameMax
		stc
		call	StrCopy
		retn

SplitName:	push	si
		push	di
		push	bx
		push	bp
		mov	dx, bp
		call	FSplit
		pop	bp
		pop	bx
		pop	si
		pop	di
		mov	ax, ds:[bp]
		or	al, al
		jne	@02_SplitName
		mov	al, [bx]
		or	al, al
		jne	@01_SplitName
		mov	ax, '*'
		mov	[bx], ax
		mov	ds:[bp][1], ax
		mov	al, '.'
		mov	ds:[bp], al
		jmp	@01_SplitName
@02_SplitName:	cmp	ax, '.'
		jne	@01_SplitName
		mov	ds:[bp], ah
@01_SplitName:	mov	cx, LongFileNameMax
		clc
		call	StrCopy
		mov	si, bx
		clc
		call	StrCopy
		mov	si, bp
		stc
		call	StrCopy
		retn

CloneName:	cld
		pushf
@04_CloneName:	mov	ah, [si]
		or	ah, ah
		je	@01_CloneName
		mov	al, [bx]    
		cmp	ah, '?'
		je	@02_CloneName
		cmp	ah, '*'
		je	@03_CloneName
		mov	al, ah
@02_CloneName:	inc	si
@03_CloneName:	cmp	byte ptr [bx], 0
		je	@06_CloneName
		inc	bx
@06_CloneName:	or	al, al
		je	@01_CloneName
		stosb
		loop	@04_CloneName
@01_CloneName:	cmp	byte ptr [di][-1], '.'
		jne	@07_CloneName
		dec	di
@07_CloneName:	popf
		jnc	@05_CloneName
		xor	al, al
		stosb
@05_CloneName:	retn

MakeName:	push	si
		push	di
		mov	si, bx
		mov	di, dx
		cmp	LongLines, False
		jne	@02_MakeName
		call	StrLen
		cmp	al, cl
		jbe	@02_MakeName
		push	ax
		push	si
		lodsw
		stosw
		lodsb
		stosb
		pop	si
		pop	ax
		add	si, ax
		sub	si, cx
		add	si, 6
		mov	ax, '..'
		stosw
		stosb
@02_MakeName:	lodsb
		stosb
		or	al, al
		jne	@02_MakeName
@01_MakeName:	pop	di
		pop	si
		retn

StrCopy:	mov	dx, cx
StrPartCopy:	cld
		pushf
		or	di, di
		jne	@04_StrCopy
		popf
		retn
@04_StrCopy:	or	cx, cx
		je	@01_StrCopy
@02_StrCopy:	or	dx, dx
		je	@01_StrCopy
		lodsb
		or	al, al
		je	@01_StrCopy
		stosb
		dec	dx
		loop	@02_StrCopy
@01_StrCopy:	xor	al, al
		popf
		jnc	@03_StrCopy
		stosb
@03_StrCopy:	retn

StrLen:		cld
		push	si
		xor	ah, ah
@02_StrLen:	lodsb
		or	al, al
		je	@01_StrLen
		inc	ah
		or	ah, ah
		jne	@02_StrLen
@01_StrLen:	pop	si
		mov	al, ah
		xor	ah, ah
		retn

PrintStr:	push	si
		push	bx
		push	cx
		pushf
		mov	si, dx
		mov	bx, 1
		call	StrLen
		or	ax, ax
		je	@01_PrintStr
		mov	cx, ax
		mov	ah, 40h
		int	21h
@01_PrintStr:	popf
		jnc	@02_PrintStr
		mov	dx, Offset LineFeed
		mov	cx, 2
		mov	ah, 40h
		int	21h
@02_PrintStr:	pop	cx
		pop	bx
		pop	si
		retn

ParamStr:	mov	si, 0081h
		xor	bh, bh
		xor	ah, ah
@01_ParamStr:	lodsb
		cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		inc	bh
		cmp	bl, bh
		je	@03_ParamStr
@04_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, '"'
		jne	@07_ParamStr
		xor	ah, 1
		jmp	@08_ParamStr
@07_ParamStr:	or	ah, ah
		jne	@08_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
@08_ParamStr:	lodsb
		jmp	@04_ParamStr
@03_ParamStr:	or	di, di
		je	@05_ParamStr
@06_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, '"'
		jne	@09_ParamStr
		xor	ah, 1
		jmp	@10_ParamStr
@09_ParamStr:	or	ah, ah
		jne	@11_ParamStr
		cmp	al, ' '
		je	@02_ParamStr
		cmp	al, 9
		je	@02_ParamStr
@11_ParamStr:	stosb
@10_ParamStr:	lodsb
		loop	@06_ParamStr
@02_ParamStr:	xor	al, al
		stosb
@05_ParamStr:	retn

GetEnvStr:	push	ds
		push	es
		push	ds
		push	di
		mov	ds, ds:[002Ch]
		mov	bx, si
		xor	si, si
		cld
@03_GetEnvStr:	cmp	byte ptr [si], 0
		je	@01_GetEnvStr
		mov	di, bx
@06_GetEnvStr:	mov	al, es:[di]
		inc	di
		call	UpCase
		mov	ah, al
		lodsb
		call	UpCase
		cmp	al, '='
		jne	@04_GetEnvStr
		xor	al, al
@04_GetEnvStr:	cmp	al, ah
		jne	@05_GetEnvStr
		test	al, al
		jne	@06_GetEnvStr
		jmp	@01_GetEnvStr
@05_GetEnvStr:	dec	si
@02_GetEnvStr:	lodsb
		or	al, al
		jne	@02_GetEnvStr
		jmp	@03_GetEnvStr
@01_GetEnvStr:	pop	bx
		mov	di, si
		push	ds
		pop	es
		xor	al, al
		mov	cx, 256
		repne	scasb
		not	cl
		pop	es
		mov	di, bx
		rep	movsb
		xor	al, al
		stosb
		pop	es
		pop	ds
		retn

ParamStrX:	push	di
		call	ParamStr
		pop	si
		cmp	byte ptr [si], '%'
		jne	@01_ParamStrX
		mov	di, si
		inc	si
		call	GetEnvStr
@01_ParamStrX:	retn

UpCase:		cmp	al, 'a'
		jb	@01_UpCase
		cmp	al, 'z'
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

LongDiv:	push	si
		push	di
		xor	dx, bx
		pushf
		xor	dx, bx
		pushf
		jns	@01_LongDiv
		not	dx
		neg	ax
		sbb	dx, -1
@01_LongDiv:	or	bx, bx
		jns	@02_LongDiv
		not	bx
		neg	cx
		sbb	bx, -1
@02_LongDiv:	jne	@03_LongDiv
		cmp	dx, cx
		jb	@04_LongDiv
		jcxz	@10_LongDiv
		xchg	ax, bx
		xchg	ax, dx
		div	cx
		xchg	ax, bx
@04_LongDiv:	div	cx
		mov	cx, dx
		mov	dx, bx
		xor	bx, bx
		jmp	@05_LongDiv
@03_LongDiv:	push	dx
		push	ax
		mov	si, cx
		mov	di, bx
		or	bh, bh
		je	@06_LongDiv
		mov	cl, ch
		mov	ch, bl
		mov	bl, bh
		xor	bh, bh
		mov	al, ah
		mov	ah, dl
		mov	dl, dh
		mov	dh, bh
@06_LongDiv:	shr	dx, 1
		rcr	ax, 1
		shr	bx, 1
		rcr	cx, 1
		jne	@06_LongDiv
		div	cx
		mov	cx, ax
		mov	bx, ax
		mul	di
		xchg	ax, cx
		mul	si
		add	dx, cx
		pop	cx
		sub	cx, ax
		mov	ax, bx
		pop	bx
		sbb	bx, dx
		jnb	@07_LongDiv
		add	cx, si
		adc	bx, di
		dec	ax
@07_LongDiv:	xor	dx, dx
@05_LongDiv:	popf
		jns	@08_LongDiv
		not	bx
		neg	cx
		sbb	bx, -1
@08_LongDiv:	popf
		jns	@09_LongDiv
		not	dx
		neg	ax
		sbb	dx, -1
@09_LongDiv:	clc
		jmp	@11_LongDiv
@10_LongDiv:	stc
@11_LongDiv:	pop	di
		pop	si
		retn

Hello		db	'Binary File Compare by Joe Forster/STA', 13, 10, 13, 10, '$'
Usage		db	'This program compares two binary files similarly to DOS''s "FC /B" command.', 13, 10, 13, 10
		db	'Usage: BFC <filename1> <filename2> [-|/<options>]', 13, 10, '$'
NotFound	db	' not found', 13, 10, '$'
NotCompared	db	'No files to compare', 13, 10, '$'
NoMemory	db	'Out of memory', 13, 10, '$'
Comparing	db	'Comparing $'
Conjunctive	db	' and $'
Complete	db	'% complete', 13, '$'
Differ		db	' differ in $'
Bytes		db	' byte$'
Longer		db	' is longer than $'
Indent		db	'  $'
Colon		db	': $'
AllFiles	db	'*.*', 0
LineFeed	db	13, 10, '$'

DataStart:

ErrorLevel	db	?
LongLines	db	?
NoNotFound	db	?
NoPercent	db	?
Quiet		db	?
Subdirs		db	?
EscHit		db	?
FilesFound	db	?
FilesCompared	db	?
FilesDiffed	db	?
FindAttr	dw	?
ScreenWidth	dw	?
Buffer1		dw	?
Buffer2		dw	?
Pos		dd	?
Diff		dd	?
ReadLen		dd	?
Length1		dd	?
Length2		dd	?
NumStrBuffer	db	10 + 1 dup (?)
Parameter	db	LongFileNameMax + 1 dup (?)
FName1		db	LongFileNameMax + 1 dup (?)
FName2		db	LongFileNameMax + 1 dup (?)
Dir1		db	LongFileNameMax + 1 dup (?)
Dir2		db	LongFileNameMax + 1 dup (?)
Name1		db	LongFileNameMax + 1 dup (?)
Name2		db	LongFileNameMax + 1 dup (?)
NameTemp	db	LongFileNameMax + 1 dup (?)
Ext1		db	LongFileNameMax + 1 dup (?)
Ext2		db	LongFileNameMax + 1 dup (?)
ExtTemp		db	LongFileNameMax + 1 dup (?)
LFNSearchRec2		LongSearchRec <?>

DataEnd:

CSeg		ends

		end	Main
