;Ŀ
;                 Joe Forster/STA                 
;                                                 
;                     CUT.ASM                     
;                                                 
;         Text file line beginning cutter         
;

CSeg		segment
		assume	cs:CSeg, ds:CSeg, ss:CSeg
		org	0100h

BufferSize	equ	64512
ProgramSize	equ	4096

Main:		mov	ax, ds:[0006h]
		cmp	ax, ProgramSize
		jbe	@16
		mov	bx, ProgramSize / 16
		mov	ah, 4Ah
		int	21h
		mov	sp, ProgramSize
		xor	ax, ax
		push	ax
@16:		mov	di, Offset DataStart
		mov	cx, DataEnd - DataStart
		xor	al, al
		cld
		rep	stosb
		mov	dx, Offset Hello
		mov	ah, 9
		int	21h
		mov	bl, 2
		mov	di, Offset SearchPar
		mov	cx, 79
		call	ParamStr
		cmp	bh, 2
		jae	@01
		mov	dx, Offset Usage
		mov	ah, 9
		int	21h
		xor	al, al
		jmp	@03
@01:		mov	si, Offset SearchPar
		call	StrNum
		or	dx, dx
		jne	@17
		or	ax, ax
		je	@17
		cmp	ax, 256
		jb	@18
@17:		mov	dx, Offset InvalidNumber
		jmp	@11
@18:		mov	CutNum, al
		mov	bl, 1
		mov	di, Offset SearchPar
		mov	cx, 79
		call	ParamStr
		mov	si, Offset SearchPar
		mov	di, Offset ReadPath
		xor	bx, bp
		xor	bp, bp
		call	FSplit
		mov	si, Offset SearchPar
		mov	di, Offset ReadName
		mov	cx, 79
		stc
		call	StrCopy
		mov	dx, Offset SearchPar
		mov	cx, 21h
		mov	ah, 4Eh
		int	21h
		jnc	@06
		mov	dx, Offset SearchPar
		clc
		call	PrintStr
		mov	dx, Offset NotFound
		jmp	@11
@06:		mov	si, Offset ReadPath
		mov	di, Offset ReadName
		mov	cx, 79
		clc
		call	StrCopy
		mov	si, 009Eh
		stc
		call	StrCopy
		mov	si, Offset ReadPath
		mov	di, Offset WriteName
		mov	cx, 79
		clc
		call	StrCopy
		mov	si, Offset TempName
		stc
		call	StrCopy
		mov	dx, Offset ReadName
		mov	ax, 3D00h
		int	21h
		jnc	@07
		jmp	@04
@07:		mov	si, ax
		mov	bx, si
		mov	ax, 5700h
		int	21h
		mov	Time, cx
		mov	Date, dx
		mov	dx, Offset WriteName
		mov	cx, 0022h
		mov	ah, 3Ch
		int	21h
		jnc	@08
		jmp	@09
@08:		mov	di, ax
		mov	bx, BufferSize / 16
		mov	ah, 48h
		int	21h
		jnc	@10
		mov	dx, Offset NoMemory
		jmp	@11
@10:		mov	Buffer, ax
		mov	dx, Offset Converting
		mov	ah, 9
		int	21h
		mov	dx, Offset ReadName
		stc
		call	PrintStr
		xor	ax, ax
		mov	EndOfFile, al
		mov	BufferLength, ax
		mov	BufferPoint, ax
		call	ReadByte
@12:		mov	bx, Offset Line
		mov	dh, CutNum
		mov	cx, 255
@13:		mov	ah, EndOfFile
		or	ah, ah
		jne	@14
		cmp	al, 13
		je	@02
		cmp	al, 10
		jne	@15
@02:		xor	dh, dh
@15:		or	dh, dh
		jne	@05
		mov	[bx], al
		inc	bx
		inc	dh
@05:		dec	dh
		mov	dl, al
		call	ReadByte
		cmp	dl, 10
		je	@14
		loop	@13
@14:		push	ax
		mov	dx, Offset Line
		sub	bx, Offset Line
		mov	cx, bx
		mov	bx, di
		mov	ah, 40h
		int	21h
		pop	ax
		mov	ah, EndOfFile
		or	ah, ah
		je	@12
		push	es
		mov	es, Buffer
		mov	ah, 49h
		int	21h
		pop	es
		mov	bx, di
		mov	ax, 5701h
		mov	cx, Time
		mov	dx, Date
		int	21h
		mov	ah, 3Eh
		int	21h
@09:		pushf
		mov	bx, si
		mov	ah, 3Eh
		int	21h
		popf
		jc	@04
		call	RenameTemp
@04:		mov	ah, 4Fh
		int	21h
		jc	@20
		jmp	@06
@11:		mov	ah, 9
		int	21h
		mov	al, 1
		jmp	@19
@20:		call	NormalAttr
@03:		xor	al, al
@19:		mov	ah, 4Ch
		int	21h

RenameTemp:	mov	dx, Offset ReadName
		mov	ah, 41h
		int	21h
		jc	@01_RenameTemp
		mov	dx, Offset WriteName
		mov	di, Offset ReadName
		mov	ah, 56h
		int	21h
@01_RenameTemp:	retn

NormalAttr:	mov	dx, Offset SearchPar
		mov	cx, 23h
		mov	ah, 4Eh
		int	21h
		jc	@01_NormalAttr
@02_NormalAttr:	mov	cl, byte ptr ds:[0095h]
		test	cl, 2
		je	@03_NormalAttr
		and	cl, 0FDh
		xor	ch, ch
		push	cx
		mov	si, Offset ReadPath
		mov	di, Offset WriteName
		push	di
		mov	cx, 79
		clc
		call	StrCopy
		mov	si, 009Eh
		stc
		call	StrCopy
		pop	dx
		pop	cx
		mov	ax, 4301h
		int	21h
@03_NormalAttr:	mov	ah, 4Fh
		int	21h
		jnc	@02_NormalAttr
@01_NormalAttr:	retn

StrNum:		push	di
		push	bx
		call	StrLen
		mov	cx, ax
		xor	ax, ax
		xor	dx, dx
		xor	di, di
		jcxz	@06_StrNum
		cmp	byte ptr [si], '$'
		je	@07_StrNum
@03_StrNum:	mov	bl, [si]
		sub	bl, '0' + 10
		add	bl, 10
		jnc	@04_StrNum
		test	dh, 0F0h
		jne	@06_StrNum
		push	bx
		shl	ax, 1
		rcl	dx, 1
		push	dx
		push	ax
		shl	ax, 1
		rcl	dx, 1
		shl	ax, 1
		rcl	dx, 1
		pop	bx
		add	ax, bx
		pop	bx
		adc	dx, bx
		pop	bx
		xor	bh, bh
		add	ax, bx
		adc	dx, 0
		inc	si
		loop	@03_StrNum
@04_StrNum:	jmp	@01_StrNum
@06_StrNum:	stc
		jmp	@01_StrNum
@07_StrNum:	inc	si
		dec	cx
		je	@06_StrNum
@08_StrNum:	mov	bl, [si]
		cmp	bl, 'a'
		jb	@09_StrNum
		sub	bl, 32
@09_StrNum:	sub	bl, '0' + 10
		add	bl, 10
		jc	@05_StrNum
		sub	bl, 7 + 16
		add	bl, 6
		jnc	@04_StrNum
		add	bl, 10
@05_StrNum:	mov	bh, 4
@02_StrNum:	shl	ax, 1
		rcl	dx, 1
		jc	@06_StrNum
		dec	bh
		jne	@02_StrNum
		or	al, bl
		inc	si
		loop	@08_StrNum
		clc
@01_StrNum:	pop	bx
		pop	di
		retn

FSplit:		mov	dx, si
		call	StrLen
		add	si, ax
		dec	si
		xor	cx, cx
		std
@04_FSplit:	cmp	si, dx
		jb	@01_FSplit
		lodsb
		cmp	al, '.'
		jne	@02_FSplit
		or	cx, cx
		jne	@02_FSplit
		mov	cx, si
		inc	cx
@02_FSplit:	cmp	al, '\'
		je	@03_FSplit
		cmp	al, ':'
		jne	@04_FSplit
@03_FSplit:	inc	si
@01_FSplit:	inc	si
		or	cx, cx
		jne	@05_FSplit
		mov	cx, dx
		xchg	si, dx
		call	StrLen
		xchg	si, dx
		add	cx, ax
@05_FSplit:	xchg	si, dx
		sub	cx, dx
		sub	dx, si
		push	cx
		mov	cx, 67
		stc
		call	StrPartCopy
		mov	di, bx
		pop	dx
		mov	cx, 8
		stc
		call	StrPartCopy
		mov	di, bp
		mov	cx, 4
		stc
		call	StrCopy
		retn

StrCopy:	mov	dx, cx
StrPartCopy:	cld
		pushf
		or	di, di
		jne	@04_StrCopy
		popf
		retn
@04_StrCopy:	or	cx, cx
		je	@01_StrCopy
@02_StrCopy:	or	dx, dx
		je	@01_StrCopy
		lodsb
		or	al, al
		je	@01_StrCopy
		stosb
		dec	dx
		loop	@02_StrCopy
@01_StrCopy:	xor	al, al
		popf
		jnc	@03_StrCopy
		stosb
@03_StrCopy:	retn

StrLen:		cld
		push	si
		xor	ah, ah
@02_StrLen:	lodsb
		or	al, al
		je	@01_StrLen
		inc	ah
		or	ah, ah
		jne	@02_StrLen
@01_StrLen:	pop	si
		mov	al, ah
		xor	ah, ah
		retn

PrintStr:	push	si
		push	bx
		push	cx
		pushf
		mov	si, dx
		mov	bx, 1
		call	StrLen
		or	ax, ax
		je	@01_PrintStr
		mov	cx, ax
		mov	ah, 40h
		int	21h
@01_PrintStr:	popf
		jnc	@02_PrintStr
		mov	dx, Offset LineFeed
		mov	cx, 2
		mov	ah, 40h
		int	21h
@02_PrintStr:	pop	cx
		pop	bx
		pop	si
		retn

ReadByte:	push	es
		push	bx
		push	cx
		push	dx
		mov	al, 26
		mov	ah, EndOfFile
		or	ah, ah
		jne	@02_ReadByte
		mov	es, Buffer
		mov	ax, BufferPoint
		cmp	ax, BufferLength
		jne	@01_ReadByte
		mov	bx, si
		mov	cx, BufferSize
		xor	dx, dx
		push	ds
		mov	ds, cs:Buffer
		mov	ah, 3Fh
		int	21h
		pop	ds
		mov	BufferPoint, 0
		mov	BufferLength, ax
		or	ax, ax
		jne	@01_ReadByte
		mov	EndOfFile, 1
		xor	al, al
		jmp	@02_ReadByte
@01_ReadByte:	mov	bx, BufferPoint
		mov	al, es:[bx]
		inc	BufferPoint
		cmp	al, 26
		jne	@02_ReadByte
		mov	EndOfFile, 1
@02_ReadByte:	pop	dx
		pop	cx
		pop	bx
		pop	es
		retn

ParamStr:	mov	si, 0081h
		xor	bh, bh
@01_ParamStr:	lodsb
		cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		inc	bh
		cmp	bl, bh
		je	@03_ParamStr
@04_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@01_ParamStr
		cmp	al, 9
		je	@01_ParamStr
		lodsb
		jmp	@04_ParamStr
@03_ParamStr:	or	di, di
		je	@05_ParamStr
@06_ParamStr:	cmp	al, 13
		je	@02_ParamStr
		cmp	al, ' '
		je	@02_ParamStr
		cmp	al, 9
		je	@02_ParamStr
		call	UpCase
		stosb
		lodsb
		loop	@06_ParamStr
@02_ParamStr:	xor	al, al
		stosb
@05_ParamStr:	retn

UpCase:		cmp	al, 'a'
		jb	@01_UpCase
		cmp	al, 'z'
		ja	@01_UpCase
		sub	al, 'a' - 'A'
@01_UpCase:	retn

Hello		db	'Text file line beginning cutter by Joe Forster/STA', 13, 10, 13, 10, '$'
Usage		db	'This program cuts characters off of every line beginning in a text file.', 13, 10, 13, 10
		db	'Usage: CUT <filename> <cut-off-value>', 13, 10, '$'
NotFound	db	' not found', 13, 10, '$'
NoMemory	db	'Out of memory', 13, 10, '$'
InvalidNumber	db	'Invalid number', 13, 10, '$'
Converting	db	'Converting $'
LineFeed	db	13, 10
TempName	db	'$$TEMP$$.TMP', 0

DataStart:

Line		db	255 + 1 dup (?), ?
Time		dw	?
Date		dw	?
CutNum		db	?
EndOfFile	db	?
BufferLength	dw	?
BufferPoint	dw	?
Buffer		dw	?
SearchPar	db	79 + 1 dup (?)
ReadName	db	79 + 1 dup (?)
WriteName	db	79 + 1 dup (?)
ReadPath	db	79 + 1 dup (?)

DataEnd:

CSeg		ends

		end	Main
