{
Ŀ
                 Joe Forster/STA                 
                                                 
                   CUTBINK.PAS                   
                                                 
                BINK movie cutter                

}

{
  Reference material:
  - http://wiki.multimedia.cx/index.php?title=Bink_Container
  - http://lists.mplayerhq.hu/pipermail/ffmpeg-devel/2008-April/045346.html
}

uses
  DOS;

const
  fmReadOnly    = 0;
  fmWriteOnly   = 1;
  fmReadWrite   = 2;
  fmModeMask    = $0F;
  fmExclusive   = $20;
  fmShared      = $40;
  MaxStrLen     = 255;
  MaxNameLen    = 80;
  BufferMax     = 61440;
  chDirSep      = '\';
  BINKSign      = $004B4942;

type
  PLongint      = ^Longint;
  ExtFile       = record
    Orig        : file;
    LongName    : string;
  end;
  PExtFile      = ^ExtFile;
  TBINKHeader   = record
    Signature   : array [0..2] of Char;
    Version     : Char;
    FileSize,
    FrameNum1,
    LargestFrameSize,
    FrameNum2,
    Width,
    Height,
    FPSDividend,
    FPSDivisor,
    Unknown,
    AudioTrackNum: Longint;
  end;
  TBinkExtHeader= array [0..255] of Longint;

var
  LongFileNames : Boolean;
  DummyByte,
  MaxFileNameLen: Byte;
  ReadAttr,
  BufferSize,
  BINKExtHeadSize: Word;
  NumOK         : Integer;
  FrameNum,
  RealFrameNum,
  FrameCount,
  OrigFramePos,
  NewFramePos,
  PrevFramePos,
  FirstFramePos,
  LastFramePos,
  FrameSize,
  LargestFrameSize,
  ReadTime,
  ReadSize,
  ReadPos       : Longint;
  ReadFile,
  WriteFile     : ExtFile;
  ReadBuffer    : array [0..BufferMax - 1] of Byte;
  DOSDate       : DateTime;
  BINKHeader    : TBINKHeader;
  BINKExtHeader : TBINKExtHeader;

procedure ExecLFN; assembler;
asm
    push ds;
    push ax;
    mov ax, Seg(InOutRes);
    mov ds, ax;
    cmp LongFileNames, False;
    pop ax;
    pop ds;
    jne @1;
    mov ax, $7100;
    stc;
    jmp @2;
@1: mov ah, $71;
    stc;
    int $21;
    jc @2;
    cmp ax, $7100;
    stc;
    je @2;
    clc;
@2:
end;

function InitLongNames: Boolean; assembler;
var
  S,
  T             : string;
asm
    push ds;
    push ss;
    pop ds;
    push ss;
    pop es;
    lea si, S;
    mov byte ptr [si], 0;
    lea di, T;
    xor cl, cl;
    mov ch, $80;
    mov al, $60;
    call ExecLFN;
    pop ds;
    mov bl, True;
    mov bh, MaxStrLen;
    jnc @1;
    cmp ax, $7100;
    jne @1;
    mov bl, False;
    mov bh, MaxNameLen;
@1: mov LongFileNames, bl;
    mov MaxFileNameLen, bh;
    mov al, bl;
end;

function LongParamStr(Index: Byte): string; assembler;
asm
    push ds;
    mov dl, Index;
    or dl, dl;
    je @12;
    xor dh, dh;
    mov ax, PrefixSeg;
    mov ds, ax;
    mov di, $0080;
    mov cl, [di];
    xor ch, ch;
    inc di;
    xor bx, bx;
    xor ah, ah;
@1: jcxz @3;
@2: mov al, [di];
    cmp al, '"';
    jne @7;
    xor ah, 1;
    inc di;
    dec cx;
    jmp @3;
@7: cmp al, ' ';
    ja @3;
    inc di;
    loop @2;
@3: mov si, di;
    jcxz @5;
@4: mov al, [di];
    cmp al, '"';
    jne @8;
    xor ah, 1;
@8: cmp al, ' ';
    ja @9;
    or ah, ah;
    je @5;
@9: inc di;
    loop @4;
@5: mov ax, di;
    sub ax, si;
    je @6;
    inc bx;
    dec dx;
    jnz @1;
@6: les di, @Result;
    mov bx, di;
    inc di;
    xor dl, dl;
    mov cx, ax;
    jcxz @12;
@11:lodsb;
    cmp al, '"';
    je @10;
    stosb;
    inc dl;
@10:loop @11;
@12:mov es:[bx], dl;
    pop ds;
end;

function LongOpenFile(Name: string; var F: ExtFile; Mode: Byte): Integer;
var
  B             : Byte;
  W             : Word;
  I             : Integer;
begin
  F.LongName := Name;
  B := 0;
  case Mode of
    fmReadOnly: B := fmShared;
    fmReadWrite, fmWriteOnly: B := fmExclusive;
  end;
  FileMode := Mode or B;
  asm
    mov W, 0;
    push ds;
    mov al, FileMode;
    xor ah, ah;
    push ax;
    push ss;
    pop ds;
    lea si, Name;
    mov bl, [si];
    xor bh, bh;
    inc si;
    mov byte ptr [si][bx], 0;
    xor di, di;
    mov dx, $01;
    mov bl, al;
    and bl, $0F;
    cmp bl, fmWriteOnly;
    jne @1;
    mov dx, $12;
@1: mov bl, al;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    pop bx;
    jnc @2;
    cmp ax, 5;
    jne @4;
    and bl, $0F;
    mov al, $6C;
    xor cx, cx;
    call ExecLFN;
    jnc @2;
@4: pop ds;
    mov W, ax;
    xor ax, ax;
    jmp @3;
@2: pop ds;
    les di, F;
    mov es:[di].ExtFile.Orig.FileRec.Mode, fmInOut;
    mov es:[di].ExtFile.Orig.FileRec.RecSize, 1;
@3: mov es:[di].ExtFile.Orig.FileRec.Handle, ax;
  end;
  LongOpenFile := W;
end;

procedure ExtClose(var F: ExtFile);
begin
  Close(F.Orig);
end;

function ExtFileSize(var F: ExtFile): Longint;
begin
  ExtFileSize := FileSize(F.Orig);
end;

function ExtFilePos(var F: ExtFile): Longint;
begin
  ExtFilePos := FilePos(F.Orig);
end;

procedure ExtSeek(var F: ExtFile; Pos: Longint);
begin
  Seek(F.Orig, Pos);
end;

procedure ExtGetFTime(var F: ExtFile; var Time: Longint);
begin
  GetFTime(F.Orig, Time);
end;

procedure ExtSetFTime(var F: ExtFile; Time: Longint);
begin
  SetFTime(F.Orig, Time);
end;

procedure ExtBlockRead(var F: ExtFile; var Buf; Count: Word);
begin
  BlockRead(F.Orig, Buf, Count);
end;

procedure ExtBlockWrite(var F: ExtFile; var Buf; Count: Word);
begin
  BlockWrite(F.Orig, Buf, Count);
end;

begin
  WriteLn('BINK movie cutter by Joe Forster/STA');
  WriteLn;
  if ParamCount < 3 then
  begin
    WriteLn('This program cuts BINK movies into its first few frames.');
    WriteLn;
    WriteLn('Usage: CUTBINK <source-file> <destination-file> <number-of-frames>');
  end
  else
  begin
    Val(LongParamStr(3), RealFrameNum, NumOK);
    if NumOK = 0 then
    begin
      if RealFrameNum < 0 then RealFrameNum := 0;
      FrameNum := RealFrameNum;
      if FrameNum = 0 then Inc(FrameNum);
      LongFileNames := True;
      if InitLongNames then
      begin
        if LongOpenFile(LongParamStr(1), ReadFile, fmReadOnly) = 0 then
        begin
          ExtGetFTime(ReadFile, ReadTime);
          ExtBlockRead(ReadFile, BINKHeader, SizeOf(TBINKHeader));
          LargestFrameSize := 0;
          BINKExtHeadSize := BINKHeader.AudioTrackNum * (3 * SizeOf(Longint));
          ExtBlockRead(ReadFile, BINKExtHeader, BINKExtHeadSize);
          if ((PLongint(@BINKHeader.Signature)^ and $00FFFFFF) = (BINKSign and $00FFFFFF))
            and (BINKHeader.Version in ['b', 'f'..'i']) then
          begin
            if FrameNum <= BINKHeader.FrameNum1 then
            begin
              if (LongOpenFile(LongParamStr(2), WriteFile, fmWriteOnly) = 0) then
              begin
                ExtBlockWrite(WriteFile, BINKHeader, SizeOf(TBINKHeader));
                ExtBlockWrite(WriteFile, BINKExtHeader, BINKExtHeadSize);
                NewFramePos := SizeOf(TBINKHeader) + BINKExtHeadSize + (FrameNum + 1) * SizeOf(Longint);
                PrevFramePos := SizeOf(TBINKHeader) + BINKExtHeadSize + (BINKHeader.FrameNum1 + 1) * SizeOf(Longint);
                for FrameCount := 0 to BINKHeader.FrameNum1 + 1 do
                begin
                  if FrameCount <= BINKHeader.FrameNum1 then
                    ExtBlockRead(ReadFile, OrigFramePos, SizeOf(Longint));
                  if FrameCount = 0 then FirstFramePos := OrigFramePos;
                  if RealFrameNum = 0 then
                  begin
                    FrameSize := 1;
                    LastFramePos := OrigFramePos + FrameSize;
                  end
                  else
                  begin
                    if FrameCount = RealFrameNum then LastFramePos := OrigFramePos;
                    FrameSize := OrigFramePos - PrevFramePos;
                  end;
                  if (FrameCount > 0) and (FrameCount <= FrameNum + 1) then
                  begin
                    ExtBlockWrite(WriteFile, NewFramePos, SizeOf(Longint));
                    Inc(NewFramePos, FrameSize);
                    if FrameSize > LargestFrameSize then LargestFrameSize := FrameSize;
                  end;
                  PrevFramePos := OrigFramePos;
                end;
                if RealFrameNum = 0 then
                begin
                  DummyByte := 0;
                  ExtBlockWrite(WriteFile, DummyByte, SizeOf(DummyByte));
                end
                else
                begin
                  ReadSize := LastFramePos - FirstFramePos;
                  while ReadSize > 0 do
                  begin
                    if ReadSize > BufferMax then BufferSize := BufferMax else BufferSize := ReadSize;
                    ExtBlockRead(ReadFile, ReadBuffer, BufferSize);
                    ExtBlockWrite(WriteFile, ReadBuffer, BufferSize);
                    Dec(ReadSize, BufferSize);
                  end;
                end;
                BINKHeader.FrameNum1 := FrameNum;
                BINKHeader.FrameNum2 := FrameNum;
                BINKHeader.LargestFrameSize := LargestFrameSize;
                BINKHeader.FileSize := ExtFilePos(WriteFile) - (2 * SizeOf(Longint));
                ExtSeek(WriteFile, 0);
                ExtBlockWrite(WriteFile, BINKHeader, SizeOf(TBINKHeader));
                ExtSetFTime(WriteFile, ReadTime);
                ExtClose(WriteFile);
                WriteLn('Movie copied successfully');
              end
              else
              begin
                WriteLn('Cannot open ', LongParamStr(2));
              end;
            end
            else
              WriteLn('Movie is too short');
          end
          else
            WriteLn('Invalid BINK signature');
          ExtClose(ReadFile);
        end
        else
          WriteLn('Cannot open ', LongParamStr(1));
      end
      else
        WriteLn('Long filenames are not available');
    end
    else
      WriteLn('Invalid number of frames');
  end;
end.
