/*
    1541EMU, the Commodore 1541 disk drive emulator
    Copyright (C) 2001-2002 Ville Muikkula
    Copyright (C) 1998-2000 Andreas Boose
 *
 * attach.c - File system attach management.
 *
 * This file was formerly part of VICE, the Versatile Commodore Emulator.
 * Written by
 *  Andreas Boose <boose@linux.rz.fh-hannover.de>
 * Modifications by
 *  Ville Muikkula <1541@surfeu.fi>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <limits.h>
#include "diskimg.h"
#include "drive.h"
#include "gcr.h"
#include "tui.h"
/* ------------------------------------------------------------------------- */

void detach_disk_image(disk_image_t *image)
{
    if (image!=NULL)
    {
        drive_detach_image(image);
        disk_image_close(image);
        image->GCR_dirty = 0;
        gcr_destroy_image(image->gcr);
        image->gcr = NULL;
        free(image->name);
        image->name = NULL;
    }
}


int attach_disk_image(disk_image_t *imgptr, const char *filename)
{
    int err = -1;
    int i;

    if (filename == NULL)
    {
        tui_error("No name, cannot attach floppy image.");
        return -1;
    }
    imgptr->name=malloc(PATH_MAX);
    _fixpath(filename, imgptr->name);
    strupr(imgptr->name);
    for (i=0; i<strlen(imgptr->name); i++)
        if (imgptr->name[i]=='/') imgptr->name[i]='\\';

    imgptr->read_only = Global_Read_Only_Access;

    if (disk_image_open(imgptr) < 0)
    {
        free(imgptr->name);
        imgptr->name = NULL;
        return -1;
    }

    imgptr->gcr = gcr_create_image();
    imgptr->GCR_dirty = 0;

    err = drive_attach_image(imgptr);
    if (err)
    {
        gcr_destroy_image(imgptr->gcr);
        imgptr->gcr = NULL;
        free(imgptr->name);
        imgptr->name = NULL;
    }
    return err;
}

