;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* c1541link.i
;*
;****************************************************************************
;****************************************************************************


%ifndef C1541LINK_I
%define C1541LINK_I

%include "defines.i"
%include "macros.i"
%include "ec64types.i"

%include "cpu65xx.i"
%include "via6522.i"
%include "disc.i"
%include "c1541memory.i"

;****************************************************************************
;* Exported Symbols *********************************************************
;****************************************************************************
%ifdef C1541LINK_N
global c1541link_initialize
global c1541link_exit
global c1541link_instance_initialize
global c1541link_instance_exit
global c1541link_reset_hard
global c1541link_reset_soft
global c1541link_via_counter_set
global c1541link_via_counter_refresh
global c1541link_via_counter_clear
global c1541link_via_counter_process
global c1541link_via1_irq
global c1541link_via1_pb
global c1541link_via1_pa
global c1541link_via1_ca1
global c1541link_via1_cb2
global c1541link_via1_ca2
global c1541link_via2_irq
global c1541link_via2_pb
global c1541link_via2_pa
global c1541link_via2_ca1
global c1541link_via2_cb2
global c1541link_via2_ca2
global c1541link_disc_sync
global c1541link_disc_data
global vc1541link_status
%else
extern c1541link_initialize
extern c1541link_exit
extern c1541link_instance_initialize
extern c1541link_instance_exit
extern c1541link_reset_hard
extern c1541link_reset_soft
extern c1541link_via_counter_set
extern c1541link_via_counter_refresh
extern c1541link_via_counter_clear
extern c1541link_via_counter_process
extern c1541link_via1_irq
extern c1541link_via1_pb
extern c1541link_via1_pa
extern c1541link_via1_ca1
extern c1541link_via1_cb2
extern c1541link_via1_ca2
extern c1541link_via2_irq
extern c1541link_via2_pb
extern c1541link_via2_pa
extern c1541link_via2_ca1
extern c1541link_via2_cb2
extern c1541link_via2_ca2
extern c1541link_disc_sync
extern c1541link_disc_data
extern vc1541link_status
%endif



;****************************************************************************
;* Module Data **************************************************************
;****************************************************************************
%assign C1541LINK_COUNTER_TABLE_ENTRIES	4

				struc	tc1541link
				alignb	4
d__c1541link_modulid:		resd	1
d__c1541link_counter_base:	resd	1
d__c1541link_counter:		resd	1
ad__c1541link_counter_table:	resd	(2 * C1541LINK_COUNTER_TABLE_ENTRIES)
b__vc1541link_motor_state:	resb	1
b__vc1541link_led_state:	resb	1
b__vc1541link_track:		resb	1
b__c1541link_serial_bus:	resb	1
				endstruc



				struc	tc1541
				alignb	32
tcpu65xx__c1541:		resb	tcpu65xx_size
				alignb	32
tlink__c1541:			resb	tc1541link_size
				alignb	32
tvia6522__c1541_1:		resb	tvia6522_size
				alignb	32
tvia6522__c1541_2:		resb	tvia6522_size
				alignb	32
tdisc__c1541:			resb	tdisc_size
				alignb	32
tmemory__c1541:			resb	tc1541memory_size
				endstruc



;****************************************************************************
;* assign's & define's ******************************************************
;****************************************************************************
%assign C1541LINK_COUNTER_DEFAULT_VALUE	010000000h

%define C1541LINK_MODULID		esi + tlink__c1541 + d__c1541link_modulid
%define C1541LINK_COUNTER_BASE		esi + tlink__c1541 + d__c1541link_counter_base
%define C1541LINK_COUNTER		esi + tlink__c1541 + d__c1541link_counter
%define C1541LINK_COUNTER_TABLE		esi + tlink__c1541 + ad__c1541link_counter_table
%define VC1541LINK_MOTOR_STATE		esi + tlink__c1541 + b__vc1541link_motor_state
%define VC1541LINK_LED_STATE		esi + tlink__c1541 + b__vc1541link_led_state
%define VC1541LINK_TRACK		esi + tlink__c1541 + b__vc1541link_track
%define C1541LINK_SERIAL_BUS		esi + tlink__c1541 + b__c1541link_serial_bus

%assign C1541LINK_VIA1_COUNTER_OFFSET	000h
%assign C1541LINK_VIA2_COUNTER_OFFSET	002h

%assign C1541LINK_VIA1_IRQ_NUMBER	001h
%assign C1541LINK_VIA2_IRQ_NUMBER	002h



;****************************************************************************
;* Macro's ******************************************************************
;****************************************************************************
%macro C1541LINK_CALL_INITIALIZE 0
			call	c1541link_initialize
%endmacro



%macro C1541LINK_CALL_INSTANCE_INITIALIZE 1
			call	c1541link_instance_initialize
			mov	dword eax, %1
			mov	dword [C1541LINK_MODULID], eax
%endmacro



%macro C1541LINK_CALL_RESET_HARD 0
			call	c1541link_reset_hard
%endmacro



%macro C1541LINK_CALL_RESET_SOFT 0
			call	c1541link_reset_soft
%endmacro



%macro C1541LINK_CALL_DECREMENT_COUNTER 0
			dec	dword [C1541LINK_COUNTER]
			jnz	%%no_call
			call	c1541link_via_counter_process
%%no_call:
%endmacro

%macro VC1541LINK_CALL_RESET 0
                        call    vc1541link_reset
%endmacro
                        
%endif

