;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* c1541link.n
;*
;****************************************************************************
;****************************************************************************


%define C1541LINK_N
%include "c1541lnk.i"
%include "core.i"
%include "link.i"
%include "status.i"
%include "print.i"
%include "main.i"

%assign COUNTER_TABLE_ENTRIES   C1541LINK_COUNTER_TABLE_ENTRIES
%assign COUNTER_DEFAULT_VALUE   C1541LINK_COUNTER_DEFAULT_VALUE

%define MODULID                 C1541LINK_MODULID
%define COUNTER_BASE            C1541LINK_COUNTER_BASE
%define COUNTER                 C1541LINK_COUNTER
%define COUNTER_TABLE           C1541LINK_COUNTER_TABLE
%define MOTOR_STATE             VC1541LINK_MOTOR_STATE
%define LED_STATE               VC1541LINK_LED_STATE
%define TRACK                   VC1541LINK_TRACK
%define SERIAL_BUS              C1541LINK_SERIAL_BUS

%assign VIA1_IRQ_NUMBER         C1541LINK_VIA1_IRQ_NUMBER
%assign VIA2_IRQ_NUMBER         C1541LINK_VIA2_IRQ_NUMBER



;****************************************************************************
;* c1541link_initialize *****************************************************
;****************************************************************************
section .text
c1541link_initialize:
                        ret



;****************************************************************************
;* c1541link_exit ***********************************************************
;****************************************************************************
section .text
c1541link_exit:
                        ret



;****************************************************************************
;* c1541link_instance_initialize ********************************************
;****************************************************************************
section .text
c1541link_instance_initialize:
                        INSTANCE_INITIALIZE  tc1541link_size



;****************************************************************************
;* c1541link_instance_exit **************************************************
;****************************************************************************
section .text
c1541link_instance_exit:
                        ret



;****************************************************************************
;* c1541link_reset_hard *****************************************************
;****************************************************************************
section .text
c1541link_reset_hard:
                        jmp     c1541link_reset_soft



;****************************************************************************
;* c1541link_reset_soft *****************************************************
;****************************************************************************
section .text
c1541link_reset_soft:
                        push    dword eax
                        push    dword ebx
                        xor     dword ebx, ebx
                        xor     dword eax, eax
                        mov     byte  [MOTOR_STATE], bl
                        call    status_vc1541_motor
                        mov     byte  [LED_STATE], bl
                        call    status_vc1541_led
                        mov     byte  [TRACK], bl
                        call    status_vc1541_track

                        mov     byte  [SERIAL_BUS], bl
.clear_table:           mov     dword [COUNTER_TABLE + 8 * ebx], eax
                        mov     dword [COUNTER_TABLE + 8 * ebx + 4], eax
                        inc     byte  bl
                        cmp     byte  bl, COUNTER_TABLE_ENTRIES
                        jb      .clear_table
                        mov     dword eax, COUNTER_DEFAULT_VALUE
                        mov     dword [COUNTER_BASE], eax
                        mov     dword [COUNTER], eax
                        pop     dword ebx
                        pop     dword eax
                        ret



;****************************************************************************
;* counter_substract ********************************************************
;****************************************************************************
section .text
counter_substract:
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        mov     dword eax, [COUNTER_BASE]
                        xor     dword ebx, ebx
                        sub     dword eax, [COUNTER]
.loop:                  mov     dword ecx, [COUNTER_TABLE + 8 * ebx]
                        test    dword ecx, ecx
                        jz      .result_skip
                        sub     dword ecx, eax
                        jz      .result_wrong
                        jnc     .result_ok
.result_wrong:          mov     dword eax, [MODULID]
                        xor     dword ebx, ebx
                        mov     dword ecx, __LINE__
                        jmp     core_exception
.result_ok:             mov     dword [COUNTER_TABLE + 8 * ebx], ecx
.result_skip:           inc     byte  bl
                        cmp     byte  bl, COUNTER_TABLE_ENTRIES
                        jb      .loop
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        ret



;****************************************************************************
;* counter_select ***********************************************************
;****************************************************************************
section .text
counter_select:
                        push    dword eax
                        push    dword ebx
                        push    dword ecx
                        mov     dword eax, COUNTER_DEFAULT_VALUE
                        xor     dword ebx, ebx
.loop:                  mov     dword ecx, [COUNTER_TABLE + 8 * ebx]
                        test    dword ecx, ecx
                        jz      .skip
                        cmp     dword ecx, eax
                        jnb     .skip
                        mov     dword eax, ecx
.skip:                  inc     byte  bl
                        cmp     byte  bl, COUNTER_TABLE_ENTRIES
                        jb      .loop
                        mov     dword [COUNTER_BASE], eax
                        mov     dword [COUNTER], eax
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
                        ret



;****************************************************************************
;* c1541link_via_counter_set ************************************************
;****************************************************************************
;* eax=>  counter offset
;* ebx=>  handler address
;* ecx=>  counter value
;****************************************************************************
section .text
c1541link_via_counter_set:
                        call    counter_substract
                        mov     dword [COUNTER_TABLE + 8 * eax], ecx
                        mov     dword [COUNTER_TABLE + 8 * eax + 4], ebx
                        jmp     counter_select



;****************************************************************************
;* c1541link_via_counter_refresh ********************************************
;****************************************************************************
;* eax=>  counter offset
;* ebx=>  handler address
;* ecx=>  counter value
;****************************************************************************
section .text
c1541link_via_counter_refresh:
                        mov     dword [COUNTER_TABLE + 8 * eax], ecx
                        mov     dword [COUNTER_TABLE + 8 * eax + 4], ebx
                        ret



;****************************************************************************
;* c1541link_via_counter_clear **********************************************
;****************************************************************************
;* eax=>  counter offset
;****************************************************************************
section .text
c1541link_via_counter_clear:
                        push    dword ebx
                        xor     dword ebx, ebx
                        call    counter_substract
                        mov     dword [COUNTER_TABLE + 8 * eax], ebx
                        mov     dword [COUNTER_TABLE + 8 * eax + 4], ebx
                        pop     dword ebx
                        jmp     counter_select



;****************************************************************************
;* c1541link_via_counter_process ********************************************
;****************************************************************************
section .text
c1541link_via_counter_process:
                        mov     dword eax, [COUNTER_BASE]
                        xor     dword ebx, ebx
.loop:                  mov     dword ecx, [COUNTER_TABLE + 8 * ebx]
                        mov     dword edx, [COUNTER_TABLE + 8 * ebx + 4]
                        sub     dword ecx, eax
                        jc      .counter_disabled
                        mov     dword [COUNTER_TABLE + 8 * ebx], ecx
                        jnz     .counter_disabled
                        push    dword eax
                        push    dword ebx
                        mov     dword eax, [.ap__via_offsets + 4 * ebx]
                        push    dword ecx
                        lea     dword edi, [esi + eax]
                        call    dword edx
                        pop     dword ecx
                        pop     dword ebx
                        pop     dword eax
.counter_disabled:      inc     byte  bl
                        cmp     byte  bl, COUNTER_TABLE_ENTRIES
                        jb      .loop
                        jmp     counter_select

                        align   4
.ap__via_offsets:       dd      tvia6522__c1541_1
                        dd      tvia6522__c1541_1
                        dd      tvia6522__c1541_2
                        dd      tvia6522__c1541_2



;****************************************************************************
;* c1541link_via1_irq *******************************************************
;****************************************************************************
section .text
c1541link_via1_irq:
                        push    dword eax
                        test    byte  al, al
                        jnz     .set
.clear:                 mov     byte  al, VIA1_IRQ_NUMBER
                        call    cpu65xx_signal_clear_irq
                        pop     dword eax
                        ret
.set:                   mov     byte  al, VIA1_IRQ_NUMBER
                        call    cpu65xx_signal_set_irq
                        pop     dword eax
                        ret



;****************************************************************************
;* c1541link_via1_pb ********************************************************
;****************************************************************************
section .text
c1541link_via1_pb:
                        push    dword eax
                        push    dword ebx
         jnc .read
         mov    byte  al, [VIA6522_LATCH_PB]
         mov    byte  bl, [VIA6522_REGISTERS + VIA6522_DDRB]
                        and     byte  al, bl
                        xor     byte  bl, NOT8
                        or      byte  al, bl
                        mov     byte  [SERIAL_BUS], al
         stc
.read    call link_serial_bus
.skip_serial_bus:
         pop dword ebx
         pop dword eax
         ret

;****************************************************************************
;* vc1541link_via1_ca1 ******************************************************
;****************************************************************************
section .text
c1541link_via1_ca1:
                        push dword eax
                        and byte al, 1
                        xor byte al, [_Cable_Type]
                        xor byte al, [_LPT_IRQ_Active_Edge]
                        mov byte [_Polarity], al
                        stc
                        call link_serial_bus
                        pop dword eax
                        ret


;****************************************************************************
;* c1541link_via1_pa ********************************************************
;****************************************************************************
section .text
c1541link_via1_pa:
                        ret



;****************************************************************************
;* c1541link_via1_cb2 *******************************************************
;****************************************************************************
section .text
c1541link_via1_cb2:
                        ret



;****************************************************************************
;* c1541link_via2_ca1 *******************************************************
;****************************************************************************
section .text
c1541link_via2_ca1:
                        ret



;****************************************************************************
;* c1541link_via1_ca2 *******************************************************
;****************************************************************************
section .text
c1541link_via1_ca2:
                        ret



;****************************************************************************
;* c1541link_via2_irq *******************************************************
;****************************************************************************
section .text
c1541link_via2_irq:
                        push    dword eax
                        test    byte  al, al
                        jnz     .set
.clear:                 mov     byte  al, VIA2_IRQ_NUMBER
                        call    cpu65xx_signal_clear_irq
                        pop     dword eax
                        ret
.set:                   mov     byte  al, VIA2_IRQ_NUMBER
                        call    cpu65xx_signal_set_irq
                        pop     dword eax
                        ret



;****************************************************************************
;* c1541link_via2_pb ********************************************************
;****************************************************************************
section .text
c1541link_via2_pb:
                        jnc .read
                        push    dword eax
                        mov     byte  al, [VIA6522_REGISTERS + VIA6522_PB]
                        mov     byte  ah, al
                        and     byte  al, 003h
                        shr     byte  ah, 5
                        call    disc_signal_head
                        and     byte  ah, 003h
                        mov     byte  al, ah
                        call    disc_signal_speed
                        call vc1541link_status
                        pop     dword eax
                        ret

.read                   push dword edi
                        mov     dword edi, (tc1541__1 + tvia6522__c1541_2)
                        mov     byte  al, [VIA6522_SIGNAL_PB]
                        and byte al, 0EFh
                        test byte [_Write_Protect_Sense], 1
                        jnz .wps_active
                        or      byte  al, 010h
.wps_active:            call via6522_signal_pb
                        pop dword edi
                        ret


;****************************************************************************
;* c1541link_via2_pa ********************************************************
;****************************************************************************
section .text
c1541link_via2_pa:
                        push    dword eax
                        push    dword ebx
                        mov     byte  al, [VIA6522_LATCH_PA]
                        mov     byte  bl, [VIA6522_REGISTERS + VIA6522_DDRA]
                        and     byte  al, bl
                        xor     byte  bl, NOT8
                        or      byte  al, bl
                        call    disc_signal_data
                        pop     dword ebx
                        pop     dword eax
                        ret



;****************************************************************************
;* c1541link_via2_cb2 *******************************************************
;****************************************************************************
section .text
c1541link_via2_cb2:
                        call    disc_signal_rw
                        ret



;****************************************************************************
;* c1541link_via2_ca2 *******************************************************
;****************************************************************************
section .text
c1541link_via2_ca2:
                        call    disc_signal_byte_ready
                        ret



;****************************************************************************
;* c1541link_disc_sync ******************************************************
;****************************************************************************
section .text
c1541link_disc_sync:
                        push    dword eax
                        push    dword edi
                        mov     dword edi, (tc1541__1 + tvia6522__c1541_2)
                        mov     byte  ah, [VIA6522_SIGNAL_PB]
                        and     byte  ah, 07fh
                        shl     byte  al, 7
                        or      byte  al, ah
                        or      byte  al, ah
                        and     byte  al, 0EFh
                        test byte [_Write_Protect_Sense], 1
                        jnz .wps_active
                        or      byte  al, 010h
.wps_active:            call    via6522_signal_pb
                        pop     dword edi
                        pop     dword eax
                        ret



;****************************************************************************
;* c1541link_disc_data ******************************************************
;****************************************************************************
section .text
c1541link_disc_data:
                        push    dword edi
                        mov     dword edi, (tc1541__1 + tvia6522__c1541_2)
                        call    via6522_signal_pa
                        pop     dword edi
                        ret


;****************************************************************************
;* vc1541link_status ********************************************************
;****************************************************************************
section .text
vc1541link_status:
                        push    dword eax
                        push    dword ebx
                        push    dword edi
                        lea     dword edi, [esi + tvia6522__c1541_2]
                        mov     byte  al, [VIA6522_LATCH_PB]
                        mov     byte  bl, [VIA6522_REGISTERS + VIA6522_DDRB]
                        and     byte  al, bl
                        xor     byte  bl, NOT8
                        or      byte  al, bl
                        shr     byte  al, 2
                        and     byte  al, 1
                        cmp     byte  [MOTOR_STATE], al
                        je      .skip_motor
                        mov     byte  [MOTOR_STATE], al
                        mov     byte  bl, al
                        mov     dword eax, [MODULID]
                        call    status_vc1541_motor
.skip_motor:            mov     byte  al, [VIA6522_LATCH_PB]
                        mov     byte  bl, [VIA6522_REGISTERS + VIA6522_DDRB]
                        and     byte  al, bl
                        xor     byte  bl, NOT8
                        or      byte  al, bl
                        shr     byte  al, 3
                        and     byte  al, 1
                        cmp     byte  [LED_STATE], al
                        je      .skip_led
                        mov     byte  [LED_STATE], al
                        mov     byte  bl, al
                        mov     dword eax, [MODULID]
                        call    status_vc1541_led
.skip_led:              mov     byte  al, [DISC_TRACK]
                        cmp     byte  [TRACK], al
                        je      .skip_track
                        mov     byte  [TRACK], al
                        mov     byte  bl, al
                        mov     dword eax, [MODULID]
                        call    status_vc1541_track
.skip_track:            pop     dword edi
                        pop     dword ebx
                        pop     dword eax
                        ret

