;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* c1541memory.i
;*
;****************************************************************************
;****************************************************************************

extern _drive_rom1541           ; defined in drive.c

%ifndef C1541MEMORY_I
%define C1541MEMORY_I

%include "defines.i"
%include "macros.i"
%include "ec64types.i"

;****************************************************************************
;* Exported Symbols *********************************************************
;****************************************************************************
%ifdef C1541MEMORY_N
global c1541memory_initialize
global c1541memory_exit
global c1541memory_instance_initialize
global c1541memory_instance_exit
global c1541memory_reset_hard
global c1541memory_reset_soft
global c1541memory_read_opcode
global c1541memory_read_stack
global c1541memory_read_data
global c1541memory_write_stack
global c1541memory_write_data
global c1541memory_load_rom_kernel
%else
extern c1541memory_initialize
extern c1541memory_exit
extern c1541memory_instance_initialize
extern c1541memory_instance_exit
extern c1541memory_reset_hard
extern c1541memory_reset_soft
extern c1541memory_read_opcode
extern c1541memory_read_stack
extern c1541memory_read_data
extern c1541memory_write_stack
extern c1541memory_write_data
extern c1541memory_load_rom_kernel
%endif



;****************************************************************************
;* Module Data **************************************************************
;****************************************************************************
				struc	tc1541memory
				alignb	4
d__c1541memory_modulid:	resd	1
d__c1541memory_state:		resd	1
ab__c1541memory_ram:		resb	00800h
;ab__c1541memory_kernel_rom:     resb    04000h
				endstruc



;****************************************************************************
;* assign's & define's ******************************************************
;****************************************************************************
%define C1541MEMORY_MODULID		esi + tmemory__c1541 + d__c1541memory_modulid
%define C1541MEMORY_STATE		esi + tmemory__c1541 + d__c1541memory_state
%define C1541MEMORY_RAM			esi + tmemory__c1541 + ab__c1541memory_ram
;%define C1541MEMORY_KERNEL_ROM          esi + tmemory__c1541 + ab__c1541memory_kernel_rom
%define C1541MEMORY_KERNEL_ROM _drive_rom1541


%assign C1541MEMORY_STACK_LIMIT_EXCEEDED		000000001h
%assign C1541MEMORY_WORD_LIMIT_EXCEEDED			000000002h



;****************************************************************************
;* Macro's ******************************************************************
;****************************************************************************
%macro C1541MEMORY_CALL_INITIALIZE 0
			call	c1541memory_initialize
%endmacro



%macro C1541MEMORY_CALL_INSTANCE_INITIALIZE 1
			call	c1541memory_instance_initialize
			mov	dword eax, %1
			mov	dword [C1541MEMORY_MODULID], eax
%endmacro



%macro C1541MEMORY_CALL_RESET_HARD 0
			call	c1541memory_reset_hard
%endmacro

%macro C1541MEMORY_CALL_RESET_SOFT 0
			call	c1541memory_reset_soft
%endmacro

%endif

