;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002  Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* c1541memory.n
;*
;****************************************************************************
;****************************************************************************


%define C1541MEMORY_N
%include "c1541mem.i"
%include "c1541lnk.i"
%include "core.i"


;****************************************************************************
;****************************************************************************
;*
;* PART 1: assign's & define's
;*
;****************************************************************************
;****************************************************************************


%define MODULID                 C1541MEMORY_MODULID
%define STATE                   C1541MEMORY_STATE
%define RAM                     C1541MEMORY_RAM
%define KERNEL_ROM              C1541MEMORY_KERNEL_ROM

%assign STACK_LIMIT_EXCEEDED    C1541MEMORY_STACK_LIMIT_EXCEEDED
%assign WORD_LIMIT_EXCEEDED     C1541MEMORY_WORD_LIMIT_EXCEEDED


;****************************************************************************
;****************************************************************************
;*
;* PART 2: Initialisation & Management Routines
;*
;****************************************************************************
;****************************************************************************





;****************************************************************************
;* c1541memory_initialize ***************************************************
;****************************************************************************
section .text
c1541memory_initialize:
                        ret



;****************************************************************************
;* c1541memory_exit *********************************************************
;****************************************************************************
section .text
c1541memory_exit:
                        ret



;****************************************************************************
;* c1541memory_instance_initialize ******************************************
;****************************************************************************
section .text
c1541memory_instance_initialize:
                        INSTANCE_INITIALIZE  tc1541memory_size



;****************************************************************************
;* c1541memory_instance_exit ************************************************
;****************************************************************************
section .text
c1541memory_instance_exit:
                        ret



;****************************************************************************
;* c1541memory_reset_hard ***************************************************
;****************************************************************************
section .text
c1541memory_reset_hard:
                        push    dword eax
                        push    dword ecx
                        push    dword edi
                        xor     dword eax, eax
                        mov     dword ecx, 00200h
                        lea     dword edi, [RAM]
                        cld
                        rep stosd
                        pop     dword edi
                        pop     dword ecx
                        pop     dword eax
                        jmp     c1541memory_reset_soft



;****************************************************************************
;* c1541memory_reset_soft ***************************************************
;****************************************************************************
section .text
c1541memory_reset_soft:
                        mov     dword [STATE], 0
                        ret



;****************************************************************************
;* c1541memory_load_rom_kernel **********************************************
;****************************************************************************
;* eax=>  position of the ROM
;****************************************************************************
section .text
c1541memory_load_rom_kernel:
                        push    dword esi
                        lea     dword edi, [KERNEL_ROM]
                        mov     dword esi, eax
                        mov     dword ecx, 04000h
                        cld
                        rep movsb
                        pop     dword esi
                        ret





;****************************************************************************
;****************************************************************************
;*
;* PART 3: Memory Access Routines
;*
;****************************************************************************
;****************************************************************************





;****************************************************************************
;* c1541memory_read *********************************************************
;****************************************************************************
section .text
c1541memory_read:
                        push dword ebx
                        and     dword ebx, 0ffffh
                        cmp     dword ebx, 8000h
                        jae     .read_kernel_rom
                        test dword ebx, 9800h
                        jz .read_ram_1
                        and dword ebx, 9C0Fh
                        cmp byte bh, 1Ch
                        je .read_via2
                        cmp byte bh, 18h
                        je .read_via1
                        mov     byte  al, 0FFh
                        pop dword ebx
                        ret
.read_ram_1:            lea     dword ebp, [RAM]
                        and dword ebx, 7FFh
                        mov     byte  al, [ebp + ebx]
                        pop dword ebx
                        ret
.read_via1:             lea     dword edi, [esi + tvia6522__c1541_1]
                        call    via6522_read
                        pop dword ebx
                        ret
.read_via2:             lea     dword edi, [esi + tvia6522__c1541_2]
                        call    via6522_read
                        pop dword ebx
                        ret
.read_kernel_rom:       and dword ebx, 3FFFh
                        mov     byte  al, [KERNEL_ROM + ebx]
                        pop dword ebx
                        ret



;****************************************************************************
;* c1541memory_write ********************************************************
;****************************************************************************
section .text
c1541memory_write:
                        push dword ebx
                        and     dword ebx, 0ffffh
                        test dword ebx, 9800h
                        jz .write_ram_1
                        and dword ebx, 9C0Fh
                        cmp byte bh, 1Ch
                        je .write_via2
                        cmp byte bh, 18h
                        je .write_via1
                        pop dword ebx
                        ret
.write_ram_1:           lea     dword ebp, [RAM]
                        and dword ebx, 7FFh
                        mov     byte  [ebp + ebx], al
                        pop dword ebx
                        ret
.write_via1:            lea     dword edi, [esi + tvia6522__c1541_1]
                        call    via6522_write
                        pop dword ebx
                        ret
.write_via2:            lea     dword edi, [esi + tvia6522__c1541_2]
                        call    via6522_write
                        pop dword ebx
                        ret



;****************************************************************************
;* read_stack ***************************************************************
;****************************************************************************
section .text
read_stack:
%ifdef C1541MEMORY_ASSERTION
%ifdef C1541MEMORY_ASSERTION_STACK
                        cmp     dword ebx, 00100h
                        jae     .check_high_limit
.limit_exceeded:        mov     dword ebx, STACK_LIMIT_EXCEEDED
                        mov     dword eax, [MODULID]
                        mov     dword [STATE], ebx
                        xor     dword ebx, ebx
                        mov     dword ecx, __LINE__
                        jmp     core_assertion
.check_high_limit:      cmp     dword ebx, 00200h
                        jb      .read
                        jmp     .limit_exceeded
.read:
%endif
%endif
                        mov     byte  al, [RAM + ebx]
                        ret



;****************************************************************************
;* write_stack **************************************************************
;****************************************************************************
section .text
write_stack:
%ifdef C1541MEMORY_ASSERTION
%ifdef C1541MEMORY_ASSERTION_STACK
                        cmp     dword ebx, 00100h
                        jae     .check_high_limit
.limit_exceeded:        mov     dword ebx, STACK_LIMIT_EXCEEDED
                        mov     dword eax, [MODULID]
                        mov     dword [STATE], ebx
                        xor     dword ebx, ebx
                        mov     dword ecx, __LINE__
                        jmp     core_assertion
.check_high_limit:      cmp     dword ebx, 00200h
                        jb      .write
                        jmp     .limit_exceeded
.write:
%endif
%endif
                        mov     byte  [RAM + ebx], al
                        ret

c1541memory_read_opcode:        equ     c1541memory_read
c1541memory_read_stack:         equ     read_stack
c1541memory_read_data:          equ     c1541memory_read
c1541memory_write_stack:        equ     write_stack
c1541memory_write_data:         equ     c1541memory_write
