;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* core.i
;*
;****************************************************************************
;****************************************************************************





%ifndef CORE_I
%define CORE_I

%include "defines.i"
%include "macros.i"
%include "ec64types.i"

%include "core/core.i"
%include "c1541lnk.i"

;****************************************************************************
;* Exported Symbols *********************************************************
;****************************************************************************
%ifdef CORE_N
global _core_start
global _core_initialize
global _core_cycle_loop
global core_exit
global _core_reset_hard
global core_emulate
global core_new_frame
global core_exception
global core_assertion
global core_trap
global core_log
global core_get_c64_cycles
global _core_get_c1541_cycles
global core_bp_entries
global core_bp_get
global core_bp_add
global core_bp_delete
global core_get_information
global core_set_log_options
global tc64__1
global tc1541__1
global PROCESSING_DISK_CHANGE
global _CURRENT_GCR_IMAGE
global _bamdir
%else
extern core_initialize
extern core_exit
extern core_reset_hard
extern core_emulate
extern core_new_frame
extern core_exception
extern core_assertion
extern core_trap
extern core_log
extern core_get_c64_cycles
extern _core_get_c1541_cycles
extern core_bp_entries
extern core_bp_get
extern core_bp_add
extern core_bp_delete
extern core_get_information
extern core_set_log_options
extern tc64__1
extern tc1541__1
extern _CURRENT_GCR_IMAGE
%endif



;****************************************************************************
;* Module Data **************************************************************
;****************************************************************************
%assign CORE_STACK_SIZE		00100h



				struc	tcore
				alignb	4
d__core_modulid:		resd	1
q__core_c64_cycles:		resd	2
q__core_c1541_cycles:		resd	2
d__core_cycle_difference1:	resd	1
d__core_cycle_difference2:	resd	1
d__core_cycle_counter:		resd	1
d__core_cycle_counter_base:	resd	1
d__core_cycles_counted:		resd	1
d__core_cycles_left:		resd	1

p__core_stack_pointer_extern:	resd	1
p__core_stack_pointer:		resd	1
ad__core_stack:			resd	CORE_STACK_SIZE

d__core_information_modulid:	resd	1
d__core_information_type:	resd	1
d__core_information_number:	resd	1

p__core_log_buffer:		resd	1
p__core_log_offset:		resd	1
d__core_log_size:		resd	1

tc1541__core_c1541:		resb	tc1541_size
				endstruc



;****************************************************************************
;* assign's & defines's *****************************************************
;****************************************************************************
%define CORE_MODULID			tcore__1 + d__core_modulid
%define CORE_C64_CYCLES			tcore__1 + q__core_c64_cycles
%define CORE_C1541_CYCLES		tcore__1 + q__core_c1541_cycles
%define CORE_CYCLE_DIFFERENCE1		tcore__1 + d__core_cycle_difference1
%define CORE_CYCLE_DIFFERENCE2		tcore__1 + d__core_cycle_difference2
%define CORE_CYCLE_COUNTER		tcore__1 + d__core_cycle_counter
%define CORE_CYCLE_COUNTER_BASE		tcore__1 + d__core_cycle_counter_base
%define CORE_CYCLES_COUNTED		tcore__1 + d__core_cycles_counted
%define CORE_CYCLES_LEFT		tcore__1 + d__core_cycles_left

%define CORE_STACK_POINTER_EXTERN	tcore__1 + p__core_stack_pointer_extern
%define CORE_STACK_POINTER		tcore__1 + p__core_stack_pointer
%define CORE_STACK			tcore__1 + ad__core_stack

%define CORE_INFORMATION_MODULID	tcore__1 + d__core_information_modulid
%define CORE_INFORMATION_TYPE		tcore__1 + d__core_information_type
%define CORE_INFORMATION_NUMBER		tcore__1 + d__core_information_number

%define CORE_LOG_BUFFER			tcore__1 + p__core_log_buffer
%define CORE_LOG_OFFSET			tcore__1 + p__core_log_offset
%define CORE_LOG_SIZE			tcore__1 + d__core_log_size

%define CORE_C64			tcore__1 + tc64__core_c64
%define CORE_C1541			tcore__1 + tc1541__core_c1541

%endif

