;
;   1541EMU, the Commodore 1541 disk drive emulator for DOS
;   Copyright (C) 2001  Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* core.i
;*
;****************************************************************************
;****************************************************************************





%ifndef EC64CORE_CORE_I
%define EC64CORE_CORE_I

%assign CORE_ERROR_EXCEPTION		1
%assign CORE_ERROR_ASSERTION		2
%assign CORE_ERROR_TRAP			3
%assign CORE_ERROR_BPLOG_FULL		4
%assign CORE_ERROR_NOT_IMPLEMENTED	5
%assign CORE_ERROR_BAD_VALUE		6
%assign CORE_ERROR_BAD_BPTYPE		7
%assign CORE_ERROR_BPTABLE_FULL		8
%assign CORE_ERROR_BAD_MODULID		9

%assign CORE_MODULID_CORE		1
%assign CORE_MODULID_LINK		2
%assign CORE_MODULID_C64LINK		3
%assign CORE_MODULID_C64MEMORY		4
%assign CORE_MODULID_C64CPU		5
%assign CORE_MODULID_C64VIC		6
%assign CORE_MODULID_C64SID		7
%assign CORE_MODULID_C64CIA1		8
%assign CORE_MODULID_C64CIA2		9
%assign CORE_MODULID_C1541LINK		10
%assign CORE_MODULID_C1541MEMORY	11
%assign CORE_MODULID_C1541CPU		12
%assign CORE_MODULID_C1541VIA1		13
%assign CORE_MODULID_C1541VIA2		14
%assign CORE_MODULID_C1541DISC		15

%ifdef FUTURE_PLANS
%assign CORE_INFOTYPE_NOT_IMPLEMENTED		1
%assign CORE_INFOTYPE_BAD_VALUE			2

%assign CORE_INFONUMBER_CPU_ILLEGAL_OPCODE	1
%assign CORE_INFONUMBER_CPU_ILLEGAL_IRQ		2
%assign CORE_INFONUMBER_VIC_LOG_OVERFLOW	3
%assign CORE_INFONUMBER_CIA_CASCADED_TIMER	4
%assign CORE_INFONUMBER_CIA_CNT			5
%endif

%assign CORE_BPFLAG_TRAP		1
%assign CORE_BPFLAG_LOG			2

%assign CORE_BPTYPE_CPU_READ_OPCODE	1
%assign CORE_BPTYPE_CPU_READ_STACK	2
%assign CORE_BPTYPE_CPU_READ_DATA	3
%assign CORE_BPTYPE_CPU_WRITE_STACK	4
%assign CORE_BPTYPE_CPU_WRITE_DATA	5
%assign CORE_BPTYPE_VIC_IRQ		6
%assign CORE_BPTYPE_CIA_IRQ		7
%assign CORE_BPTYPE_VIA_IRQ		8

					struc	tcoreinfo
					alignb	4
d__coreinfo_modulid:			resd	1
d__coreinfo_type:			resd	1
d__coreinfo_number:			resd	1
					endstruc

%endif
