;
;   1541EMU, the Commodore 1541 disk drive emulator
;   Copyright (C) 2001-2002 Ville Muikkula
;   Copyright (C) Karsten Scheibler
;
;  This file was formerly part of ec64, the Commodore 64 emulator for Linux.
;  Written by
;   Karsten Scheibler <karsten.scheibler@bigfoot.de>
;  Modifications by
;   Ville Muikkula <1541@surfeu.fi>
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License version 2 as
;   published by the Free Software Foundation.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;****************************************************************************
;****************************************************************************
;*
;* cpu65xx.i
;*
;****************************************************************************
;****************************************************************************





%ifndef CPU65XX_I
%define CPU65XX_I

%include "defines.i"
%include "macros.i"
%include "ec64types.i"
%include "core/cpu65xx.i"

;****************************************************************************
;* maximum breakpoint entries ***********************************************
;****************************************************************************
%assign CPU65XX_MAX_BP_READ_OPCODE	8
%assign CPU65XX_MAX_BP_READ_STACK	8
%assign CPU65XX_MAX_BP_READ_DATA	8
%assign CPU65XX_MAX_BP_WRITE_STACK	8
%assign CPU65XX_MAX_BP_WRITE_DATA	8



;****************************************************************************
;* Exported Symbols *********************************************************
;****************************************************************************
%ifdef CPU65XX_N
global cpu65xx_initialize
global cpu65xx_exit
global cpu65xx_instance_initialize
global cpu65xx_instance_exit
global cpu65xx_reset_hard
global cpu65xx_reset_soft
global cpu65xx_bp_entries
global cpu65xx_bp_get
global cpu65xx_bp_add
global cpu65xx_bp_delete
global cpu65xx_signal_set_irq
global cpu65xx_signal_clear_irq
global cpu65xx_signal_set_nmi
global cpu65xx_signal_set_dma
global cpu65xx_signal_clear_dma
global cpu65xx_signal_set_overflow
%else
extern cpu65xx_initialize
extern cpu65xx_exit
extern cpu65xx_instance_initialize
extern cpu65xx_instance_exit
extern cpu65xx_reset_hard
extern cpu65xx_reset_soft
extern cpu65xx_bp_entries
extern cpu65xx_bp_get
extern cpu65xx_bp_add
extern cpu65xx_bp_delete
extern cpu65xx_signal_set_irq
extern cpu65xx_signal_clear_irq
extern cpu65xx_signal_set_nmi
extern cpu65xx_signal_set_dma
extern cpu65xx_signal_clear_dma
extern cpu65xx_signal_set_overflow
%endif



;****************************************************************************
;* Module Data **************************************************************
;****************************************************************************
					struc	tcpubp
					alignb	4
w__cpubp_flags:				resw	1
w__cpubp_low_limit:			resw	1
w__cpubp_high_limit:			resw	1
b__cpubp_value:				resb	1
b__cpubp_bit_mask:			resb	1
					endstruc



					struc	tcpumem
					alignb	4
p__cpumem_dma:				resd	1
p__cpumem_no_dma:			resd	1
					endstruc



					struc	tcpubase
					alignb	4
d__cpubase_state:			resd	1
p__cpubase_execute_cycle:		resd	1
p__cpubase_optional_address:		resd	1
q__cpubase_irq_timestamp:		resd	2
q__cpubase_nmi_timestamp:		resd	2
q__cpubase_dma_timestamp:		resd	2
d__cpubase_program_counter:		resd	1
d__cpubase_stack_pointer:		resd	1
d__cpubase_zeropage_address:		resd	1
d__cpubase_effective_address:		resd	1
b__cpubase_opcode:			resb	1
b__cpubase_data_byte:			resb	1
b__cpubase_alu_byte:			resb	1
b__cpubase_accumulator:			resb	1
b__cpubase_index_x:			resb	1
b__cpubase_index_y:			resb	1
b__cpubase_flag_register:		resb	1
					resb	1
					endstruc



					struc	tcpu65xx
					alignb	4
d__cpu65xx_modulid:			resd	1
p__cpu65xx_get_cycles:			resd	1
tcpubase__cpu65xx_base:			resb	tcpubase_size
atcpumem__cpu65xx_memory_functions:	resb	(5 * tcpumem_size)
%ifdef CPU65XX_ENABLE_BP
ap__cpu65xx_memory_functions_no_bp:	resd	5
ab__cpu65xx_bp_offsets:			resb	5
					resb	3
atcpubp__cpu65xx_bp_read_opcode:	resb	(CPU65XX_MAX_BP_READ_OPCODE * tcpubp_size)
atcpubp__cpu65xx_bp_read_stack:		resb	(CPU65XX_MAX_BP_READ_STACK * tcpubp_size)
atcpubp__cpu65xx_bp_read_data:		resb	(CPU65XX_MAX_BP_READ_DATA * tcpubp_size)
atcpubp__cpu65xx_bp_write_stack:	resb	(CPU65XX_MAX_BP_WRITE_STACK * tcpubp_size)
atcpubp__cpu65xx_bp_write_data:		resb	(CPU65XX_MAX_BP_WRITE_DATA * tcpubp_size)
%endif
					endstruc



;****************************************************************************
;* assign's & defines's *****************************************************
;****************************************************************************
%define CPUBP_FLAGS			w__cpubp_flags
%define CPUBP_LOW_LIMIT			w__cpubp_low_limit
%define CPUBP_HIGH_LIMIT		w__cpubp_high_limit
%define CPUBP_VALUE			b__cpubp_value
%define CPUBP_BIT_MASK			b__cpubp_bit_mask
%define CPUBP_SIZE			tcpubp_size

%define CPUMEM_DMA			p__cpumem_dma
%define CPUMEM_NO_DMA			p__cpumem_no_dma
%define CPUMEM_SIZE			tcpumem_size

%define CPUBASE_STATE			d__cpubase_state
%define CPUBASE_EXECUTE_CYCLE		p__cpubase_execute_cycle
%define CPUBASE_OPTIONAL_ADDRESS	p__cpubase_optional_address
%define CPUBASE_IRQ_TIMESTAMP		q__cpubase_irq_timestamp
%define CPUBASE_NMI_TIMESTAMP		q__cpubase_nmi_timestamp
%define CPUBASE_DMA_TIMESTAMP		q__cpubase_dma_timestamp
%define CPUBASE_PROGRAM_COUNTER		d__cpubase_program_counter
%define CPUBASE_STACK_POINTER		d__cpubase_stack_pointer
%define CPUBASE_ZEROPAGE_ADDRESS	d__cpubase_zeropage_address
%define CPUBASE_EFFECTIVE_ADDRESS	d__cpubase_effective_address
%define CPUBASE_OPCODE			b__cpubase_opcode
%define CPUBASE_DATA_BYTE		b__cpubase_data_byte
%define CPUBASE_ALU_BYTE		b__cpubase_alu_byte
%define CPUBASE_ACCUMULATOR		b__cpubase_accumulator
%define CPUBASE_INDEX_X			b__cpubase_index_x
%define CPUBASE_INDEX_Y			b__cpubase_index_y
%define CPUBASE_FLAG_REGISTER		b__cpubase_flag_register
%define CPUBASE_SIZE			tcpubase_size

%define CPU65XX_MODULID			esi + d__cpu65xx_modulid
%define CPU65XX_GET_CYCLES		esi + p__cpu65xx_get_cycles
%define CPU65XX_BASE			esi + tcpubase__cpu65xx_base
%define CPU65XX_MEMORY_FUNCTIONS	esi + atcpumem__cpu65xx_memory_functions
%ifdef CPU65XX_ENABLE_BP
%define CPU65XX_MEMORY_FUNCTIONS_NO_BP	esi + ap__cpu65xx_memory_functions_no_bp
%define CPU65XX_BP_OFFSETS		esi + ab__cpu65xx_bp_offsets
%define CPU65XX_BP_READ_OPCODE		esi + atcpubp__cpu65xx_bp_read_opcode
%define CPU65XX_BP_READ_STACK		esi + atcpubp__cpu65xx_bp_read_stack
%define CPU65XX_BP_READ_DATA		esi + atcpubp__cpu65xx_bp_read_data
%define CPU65XX_BP_WRITE_STACK		esi + atcpubp__cpu65xx_bp_write_stack
%define CPU65XX_BP_WRITE_DATA		esi + atcpubp__cpu65xx_bp_write_data
%endif



%define CPU65XX_STATE			CPU65XX_BASE + CPUBASE_STATE
%define CPU65XX_EXECUTE_CYCLE		CPU65XX_BASE + CPUBASE_EXECUTE_CYCLE
%define CPU65XX_OPTIONAL_ADDRESS	CPU65XX_BASE + CPUBASE_OPTIONAL_ADDRESS
%define CPU65XX_IRQ_TIMESTAMP		CPU65XX_BASE + CPUBASE_IRQ_TIMESTAMP
%define CPU65XX_NMI_TIMESTAMP		CPU65XX_BASE + CPUBASE_NMI_TIMESTAMP
%define CPU65XX_DMA_TIMESTAMP		CPU65XX_BASE + CPUBASE_DMA_TIMESTAMP
%define CPU65XX_PROGRAM_COUNTER		CPU65XX_BASE + CPUBASE_PROGRAM_COUNTER
%define CPU65XX_STACK_POINTER   	CPU65XX_BASE + CPUBASE_STACK_POINTER
%define CPU65XX_ZEROPAGE_ADDRESS	CPU65XX_BASE + CPUBASE_ZEROPAGE_ADDRESS
%define CPU65XX_EFFECTIVE_ADDRESS	CPU65XX_BASE + CPUBASE_EFFECTIVE_ADDRESS
%define CPU65XX_OPCODE			CPU65XX_BASE + CPUBASE_OPCODE
%define CPU65XX_DATA_BYTE		CPU65XX_BASE + CPUBASE_DATA_BYTE
%define CPU65XX_ALU_BYTE		CPU65XX_BASE + CPUBASE_ALU_BYTE
%define CPU65XX_ACCUMULATOR		CPU65XX_BASE + CPUBASE_ACCUMULATOR
%define CPU65XX_INDEX_X			CPU65XX_BASE + CPUBASE_INDEX_X
%define CPU65XX_INDEX_Y			CPU65XX_BASE + CPUBASE_INDEX_Y
%define CPU65XX_FLAG_REGISTER		CPU65XX_BASE + CPUBASE_FLAG_REGISTER
%define CPU65XX_READ_OPCODE		CPU65XX_MEMORY_FUNCTIONS + CPUMEM_DMA
%define CPU65XX_READ_OPCODE_NO_DMA	CPU65XX_MEMORY_FUNCTIONS + CPUMEM_NO_DMA
%define CPU65XX_READ_STACK		CPU65XX_MEMORY_FUNCTIONS + 1 * CPUMEM_SIZE + CPUMEM_DMA
%define CPU65XX_READ_STACK_NO_DMA	CPU65XX_MEMORY_FUNCTIONS + 1 * CPUMEM_SIZE + CPUMEM_NO_DMA
%define CPU65XX_READ_DATA		CPU65XX_MEMORY_FUNCTIONS + 2 * CPUMEM_SIZE + CPUMEM_DMA
%define CPU65XX_READ_DATA_NO_DMA	CPU65XX_MEMORY_FUNCTIONS + 2 * CPUMEM_SIZE + CPUMEM_NO_DMA
%define CPU65XX_WRITE_STACK		CPU65XX_MEMORY_FUNCTIONS + 3 * CPUMEM_SIZE + CPUMEM_NO_DMA
%define CPU65XX_WRITE_DATA		CPU65XX_MEMORY_FUNCTIONS + 4 * CPUMEM_SIZE + CPUMEM_NO_DMA
%ifdef CPU65XX_ENABLE_BP
%define CPU65XX_READ_OPCODE_NO_BP	CPU65XX_MEMORY_FUNCTIONS_NO_BP
%define CPU65XX_READ_STACK_NO_BP	CPU65XX_MEMORY_FUNCTIONS_NO_BP + 4
%define CPU65XX_READ_DATA_NO_BP		CPU65XX_MEMORY_FUNCTIONS_NO_BP + 8
%define CPU65XX_WRITE_STACK_NO_BP	CPU65XX_MEMORY_FUNCTIONS_NO_BP + 12
%define CPU65XX_WRITE_DATA_NO_BP	CPU65XX_MEMORY_FUNCTIONS_NO_BP + 16
%define CPU65XX_BP_READ_OPCODE_OFFSET	CPU65XX_BP_OFFSETS
%define CPU65XX_BP_READ_STACK_OFFSET	CPU65XX_BP_OFFSETS + 1
%define CPU65XX_BP_READ_DATA_OFFSET	CPU65XX_BP_OFFSETS + 2
%define CPU65XX_BP_WRITE_STACK_OFFSET	CPU65XX_BP_OFFSETS + 3
%define CPU65XX_BP_WRITE_DATA_OFFSET	CPU65XX_BP_OFFSETS + 4
%endif



;****************************************************************************
;* CPU65XX_STATE Flags ******************************************************
;****************************************************************************
%assign CPU65XX_STATE_ILLEGAL_OPCODE		000000001h
%assign	CPU65XX_STATE_ILLEGAL_IRQ		000000002h
%assign CPU65XX_STATE_SIGNAL_IRQ1		000000100h
%assign CPU65XX_STATE_SIGNAL_IRQ2		000000200h
%assign CPU65XX_STATE_SIGNAL_IRQ3		000000400h
%assign CPU65XX_STATE_SIGNAL_IRQ4		000000800h
%assign CPU65XX_STATE_SIGNAL_IRQ		000001000h
%assign CPU65XX_STATE_SIGNAL_NMI		000002000h
%assign CPU65XX_STATE_SIGNAL_IRQ_OR_NMI		000004000h
%assign CPU65XX_STATE_SIGNAL_DMA		000008000h
%assign CPU65XX_STATE_PROCESSING_IRQ  		000200000h
%assign CPU65XX_STATE_PROCESSING_NMI  		000400000h
%assign CPU65XX_STATE_PROCESSING_RESET		000800000h



;****************************************************************************
;* The 6502/6510 Flags ******************************************************
;****************************************************************************
;* The reserved flag is always set. The break flag is only cleared if an irq
;* or nmi occured, otherwise it is set.
;****************************************************************************
%assign CPU65XX_FLAG_N		080h	;negative, 1 = result is negative
%assign CPU65XX_FLAG_N_BIT	7
%assign CPU65XX_FLAG_V		040h	;overflow, 1 = true
%assign CPU65XX_FLAG_V_BIT	6
%assign CPU65XX_FLAG_R		020h	;reserved flag
%assign CPU65XX_FLAG_R_BIT	5
%assign CPU65XX_FLAG_B		010h	;break
%assign CPU65XX_FLAG_B_BIT	4
%assign CPU65XX_FLAG_D		008h	;decimal mode, 1 = enabled
%assign CPU65XX_FLAG_D_BIT	3
%assign CPU65XX_FLAG_I		004h	;irq disable, 1 = irq's disabled
%assign CPU65XX_FLAG_I_BIT	2
%assign CPU65XX_FLAG_Z		002h	;zero, 1 = result is zero
%assign CPU65XX_FLAG_Z_BIT	1
%assign CPU65XX_FLAG_C		001h	;carry, 1 = true
%assign CPU65XX_FLAG_C_BIT	0



;****************************************************************************
;* Macro's ******************************************************************
;****************************************************************************
%macro CPU65XX_CALL_INITIALIZE 0
			call	cpu65xx_initialize
%endmacro



%macro CPU65XX_CALL_INSTANCE_INITIALIZE 7
			call	cpu65xx_instance_initialize
			mov	dword eax, %1
			mov	dword ebx, %2
			mov	dword [CPU65XX_MODULID], eax
			mov	dword [CPU65XX_GET_CYCLES], ebx
			mov	dword eax, %3
			mov	dword ebx, %4
			mov	dword ecx, %5
			mov	dword [CPU65XX_READ_OPCODE], eax
			mov	dword [CPU65XX_READ_OPCODE_NO_DMA], eax
			mov	dword [CPU65XX_READ_STACK], ebx
			mov	dword [CPU65XX_READ_STACK_NO_DMA], ebx
			mov	dword [CPU65XX_READ_DATA], ecx
			mov	dword [CPU65XX_READ_DATA_NO_DMA], ecx
%ifdef CPU65XX_ENABLE_BP
			mov	dword [CPU65XX_READ_OPCODE_NO_BP], eax
			mov	dword [CPU65XX_READ_STACK_NO_BP], ebx
			mov	dword [CPU65XX_READ_DATA_NO_BP], ecx
%endif
			mov	dword eax, %6
			mov	dword ebx, %7
			mov	dword [CPU65XX_WRITE_STACK], eax
			mov	dword [CPU65XX_WRITE_DATA], ebx
%ifdef CPU65XX_ENABLE_BP
			mov	dword [CPU65XX_WRITE_STACK_NO_BP], eax
			mov	dword [CPU65XX_WRITE_DATA_NO_BP], ebx
%endif
%endmacro



%macro CPU65XX_CALL_RESET_HARD 0
			call	cpu65xx_reset_hard
%endmacro



%macro CPU65XX_CALL_RESET_SOFT 0
			call	cpu65xx_reset_soft
%endmacro



%macro CPU65XX_CALL_CYCLE 0
			call	dword [CPU65XX_EXECUTE_CYCLE]
%endmacro



%macro CPU65XX_SET_READ_OPCODE 1
			mov	dword [CPU65XX_READ_OPCODE], %1
			mov	dword [CPU65XX_READ_OPCODE_NO_DMA], %1
%ifdef CPU65XX_ENABLE_BP
			mov	dword [CPU65XX_READ_OPCODE_NO_BP], %1
%endif
%endmacro



%macro CPU65XX_SET_READ_STACK 1
			mov	dword [CPU65XX_READ_STACK], %1
			mov	dword [CPU65XX_READ_STACK_NO_DMA], %1
%ifdef CPU65XX_ENABLE_BP
			mov	dword [CPU65XX_READ_STACK_NO_BP], %1
%endif
%endmacro



%macro CPU65XX_SET_READ_DATA 1
			mov	dword [CPU65XX_READ_DATA], %1
			mov	dword [CPU65XX_READ_DATA_NO_DMA], %1
%ifdef CPU65XX_ENABLE_BP
			mov	dword [CPU65XX_READ_DATA_NO_BP], %1
%endif
%endmacro



%macro CPU65XX_SET_WRITE_STACK 1
			mov	dword [CPU65XX_WRITE_STACK], %1
%ifdef CPU65XX_ENABLE_BP
			mov	dword [CPU65XX_WRITE_STACK_NO_BP], %1
%endif
%endmacro



%macro CPU65XX_SET_WRITE_DATA 1
			mov	dword [CPU65XX_WRITE_DATA], %1
%ifdef CPU65XX_ENABLE_BP
			mov	dword [CPU65XX_WRITE_DATA_NO_BP], %1
%endif
%endmacro



%endif
;********************************************* karsten.scheibler@bigfoot.de *

